/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.screen.widget;

import com.raoulvdberge.refinedstorage.RSKeyBindings;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.integration.jei.JeiIntegration;
import com.raoulvdberge.refinedstorage.integration.jei.RSJeiPlugin;
import com.raoulvdberge.refinedstorage.render.RenderSettings;
import com.raoulvdberge.refinedstorage.screen.BaseScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;

public class SearchWidget
extends TextFieldWidget {
    private static final List<String> HISTORY = new ArrayList<String>();
    private int mode;
    private int historyIndex;

    public SearchWidget(FontRenderer fontRenderer, int x, int y, int width) {
        fontRenderer.getClass();
        super(fontRenderer, x, y, width, 9, "");
        this.historyIndex = -1;
        this.func_146185_a(false);
        this.func_146189_e(true);
        this.func_146193_g(RenderSettings.INSTANCE.getSecondaryColor());
    }

    public void updateJei() {
        if (JeiIntegration.isLoaded() && (this.mode == 2 || this.mode == 3)) {
            RSJeiPlugin.RUNTIME.getIngredientFilter().setFilterText(this.func_146179_b());
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean clickedWidget;
        boolean wasFocused = this.isFocused();
        boolean result = super.mouseClicked(mouseX, mouseY, mouseButton);
        boolean bl = clickedWidget = mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
        if (clickedWidget && mouseButton == 1) {
            this.func_146180_a("");
            this.setFocused(true);
        } else if (wasFocused != this.isFocused()) {
            this.saveHistory();
        }
        return result;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifier) {
        boolean result = super.keyPressed(keyCode, scanCode, modifier);
        if (this.isFocused()) {
            if (keyCode == 265) {
                this.updateHistory(-1);
                result = true;
            } else if (keyCode == 264) {
                this.updateHistory(1);
                result = true;
            } else if (keyCode == 257 || keyCode == 335) {
                this.saveHistory();
                if (this.field_146212_n) {
                    this.setFocused(false);
                }
                result = true;
            } else if (keyCode == 256) {
                this.saveHistory();
                if (!this.field_146212_n) {
                    this.setFocused(false);
                    result = false;
                } else {
                    this.setFocused(false);
                    result = true;
                }
            }
        }
        if (BaseScreen.isKeyDown(RSKeyBindings.FOCUS_SEARCH_BAR) && this.field_146212_n) {
            this.setFocused(!this.isFocused());
            this.saveHistory();
            result = true;
        }
        return result;
    }

    private void updateHistory(int delta) {
        if (HISTORY.isEmpty()) {
            return;
        }
        if (this.historyIndex == -1) {
            this.historyIndex = HISTORY.size();
        }
        this.historyIndex += delta;
        if (this.historyIndex < 0) {
            this.historyIndex = 0;
        } else if (this.historyIndex > HISTORY.size() - 1) {
            this.historyIndex = HISTORY.size() - 1;
            if (delta == 1) {
                this.func_146180_a("");
                return;
            }
        }
        this.func_146180_a(HISTORY.get(this.historyIndex));
    }

    private void saveHistory() {
        if (!HISTORY.isEmpty() && HISTORY.get(HISTORY.size() - 1).equals(this.func_146179_b())) {
            return;
        }
        if (!this.func_146179_b().trim().isEmpty()) {
            HISTORY.add(this.func_146179_b());
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.func_146205_d(!IGrid.isSearchBoxModeWithAutoselection(mode));
        this.setFocused(IGrid.isSearchBoxModeWithAutoselection(mode));
    }
}

