/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.screen.grid.view;

import com.raoulvdberge.refinedstorage.screen.grid.GridScreen;
import com.raoulvdberge.refinedstorage.screen.grid.sorting.IGridSorter;
import com.raoulvdberge.refinedstorage.screen.grid.stack.FluidGridStack;
import com.raoulvdberge.refinedstorage.screen.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.screen.grid.view.BaseGridView;
import java.util.List;

public class FluidGridView
extends BaseGridView {
    public FluidGridView(GridScreen screen, IGridSorter defaultSorter, List<IGridSorter> sorters) {
        super(screen, defaultSorter, sorters);
    }

    @Override
    public void setStacks(List<IGridStack> stacks) {
        this.map.clear();
        for (IGridStack stack : stacks) {
            this.map.put(stack.getId(), stack);
        }
    }

    @Override
    public void postChange(IGridStack stack, int delta) {
        FluidGridStack existing;
        if (!(stack instanceof FluidGridStack)) {
            return;
        }
        if (!stack.isCraftable() && stack.getOtherId() != null && this.map.containsKey(stack.getOtherId())) {
            IGridStack craftingStack = (IGridStack)this.map.get(stack.getOtherId());
            craftingStack.updateOtherId(stack.getId());
            craftingStack.setTrackerEntry(stack.getTrackerEntry());
        }
        if ((existing = (FluidGridStack)this.map.get(stack.getId())) == null) {
            ((FluidGridStack)stack).getStack().setAmount(delta);
            this.map.put(stack.getId(), stack);
        } else {
            if (existing.getStack().getAmount() + delta <= 0) {
                existing.setZeroed(true);
                this.map.remove(existing.getId());
            } else {
                existing.getStack().grow(delta);
            }
            existing.setTrackerEntry(stack.getTrackerEntry());
        }
    }
}

