/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.screen.grid.stack;

import com.raoulvdberge.refinedstorage.api.storage.tracker.StorageTrackerEntry;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.render.FluidRenderer;
import com.raoulvdberge.refinedstorage.render.RenderSettings;
import com.raoulvdberge.refinedstorage.screen.BaseScreen;
import com.raoulvdberge.refinedstorage.screen.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.screen.grid.stack.ItemGridStack;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidGridStack
implements IGridStack {
    private Logger logger = LogManager.getLogger(this.getClass());
    private UUID id;
    @Nullable
    private UUID otherId;
    private FluidStack stack;
    @Nullable
    private StorageTrackerEntry entry;
    private boolean craftable;
    private boolean zeroed;
    private Set<String> cachedTags;
    private String cachedName;
    private String cachedTooltip;
    private String cachedModId;
    private String cachedModName;

    public FluidGridStack(UUID id, @Nullable UUID otherId, FluidStack stack, @Nullable StorageTrackerEntry entry, boolean craftable) {
        this.id = id;
        this.otherId = otherId;
        this.stack = stack;
        this.entry = entry;
        this.craftable = craftable;
    }

    public void setZeroed(boolean zeroed) {
        this.zeroed = zeroed;
    }

    public FluidStack getStack() {
        return this.stack;
    }

    @Override
    public boolean isCraftable() {
        return this.craftable;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    @Nullable
    public UUID getOtherId() {
        return this.otherId;
    }

    @Override
    public void updateOtherId(@Nullable UUID otherId) {
        this.otherId = otherId;
    }

    @Override
    public String getName() {
        if (this.cachedName == null) {
            try {
                this.cachedName = this.stack.getDisplayName().func_150254_d();
            }
            catch (Throwable t) {
                this.logger.warn("Could not retrieve fluid name of " + this.stack.getFluid().getRegistryName().toString(), t);
                this.cachedName = "<Error>";
            }
        }
        return this.cachedName;
    }

    @Override
    public String getModId() {
        if (this.cachedModId == null) {
            ResourceLocation registryName = this.stack.getFluid().getRegistryName();
            this.cachedModId = registryName != null ? registryName.func_110624_b() : "<Error>";
        }
        return this.cachedModId;
    }

    @Override
    public String getModName() {
        if (this.cachedModName == null) {
            this.cachedModName = ItemGridStack.getModNameByModId(this.getModId());
            if (this.cachedModName == null) {
                this.cachedModName = "<Error>";
            }
        }
        return this.cachedModName;
    }

    @Override
    public Set<String> getTags() {
        if (this.cachedTags == null) {
            this.cachedTags = new HashSet<String>();
            for (ResourceLocation owningTag : FluidTags.func_226157_a_().func_199913_a((Object)this.stack.getFluid())) {
                this.cachedTags.add(owningTag.func_110623_a());
            }
        }
        return this.cachedTags;
    }

    @Override
    public String getTooltip() {
        if (this.cachedTooltip == null) {
            try {
                this.cachedTooltip = this.stack.getDisplayName().func_150254_d();
            }
            catch (Throwable t) {
                this.cachedTooltip = "<Error>";
                this.logger.warn("Could not retrieve fluid tooltip of " + this.stack.getFluid().getRegistryName().toString(), t);
            }
        }
        return this.cachedTooltip;
    }

    @Override
    public int getQuantity() {
        return this.isCraftable() ? 0 : this.stack.getAmount();
    }

    @Override
    public String getFormattedFullQuantity() {
        if (this.zeroed) {
            return "0 mB";
        }
        return API.instance().getQuantityFormatter().format(this.getQuantity()) + " mB";
    }

    @Override
    public void draw(BaseScreen gui, int x, int y) {
        String text;
        FluidRenderer.INSTANCE.render(x, y, this.stack);
        int color = RenderSettings.INSTANCE.getSecondaryColor();
        if (this.zeroed) {
            text = "0";
            color = 0xFF5555;
        } else {
            text = this.isCraftable() ? I18n.func_135052_a((String)"gui.refinedstorage.grid.craft", (Object[])new Object[0]) : API.instance().getQuantityFormatter().formatInBucketFormWithOnlyTrailingDigitsIfZero(this.getQuantity());
        }
        gui.renderQuantity(x, y, text, color);
    }

    @Override
    public Object getIngredient() {
        return this.stack;
    }

    @Override
    @Nullable
    public StorageTrackerEntry getTrackerEntry() {
        return this.entry;
    }

    @Override
    public void setTrackerEntry(@Nullable StorageTrackerEntry entry) {
        this.entry = entry;
    }
}

