/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingRequestInfo;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridTab;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawer;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.render.CraftingMonitorElementDrawers;
import com.raoulvdberge.refinedstorage.apiimpl.render.ElementDrawers;
import com.raoulvdberge.refinedstorage.container.CraftingMonitorContainer;
import com.raoulvdberge.refinedstorage.network.craftingmonitor.CraftingMonitorCancelMessage;
import com.raoulvdberge.refinedstorage.screen.BaseScreen;
import com.raoulvdberge.refinedstorage.screen.widget.ScrollbarWidget;
import com.raoulvdberge.refinedstorage.screen.widget.TabListWidget;
import com.raoulvdberge.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.raoulvdberge.refinedstorage.tile.craftingmonitor.ICraftingMonitor;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public class CraftingMonitorScreen
extends BaseScreen<CraftingMonitorContainer> {
    private static final int ROWS = 5;
    private static final int ITEM_WIDTH = 73;
    private static final int ITEM_HEIGHT = 29;
    private Button cancelButton;
    private Button cancelAllButton;
    private ScrollbarWidget scrollbar;
    private ICraftingMonitor craftingMonitor;
    private List<IGridTab> tasks = Collections.emptyList();
    private TabListWidget tabs;
    private IElementDrawers drawers = new CraftingMonitorElementDrawers(this, this.font, 73, 29);

    public CraftingMonitorScreen(CraftingMonitorContainer container, PlayerInventory inventory, ITextComponent title) {
        super(container, 254, 201, inventory, title);
        this.craftingMonitor = container.getCraftingMonitor();
        this.tabs = new TabListWidget(this, new ElementDrawers(this, this.font), () -> this.tasks, () -> (int)Math.floor((float)Math.max(0, this.tasks.size() - 1) / 7.0f), this.craftingMonitor::getTabPage, () -> {
            IGridTab tab = this.getCurrentTab();
            if (tab == null) {
                return -1;
            }
            return this.tasks.indexOf(tab);
        }, 7);
        this.tabs.addListener(new TabListWidget.ITabListListener(){

            @Override
            public void onSelectionChanged(int tab) {
                CraftingMonitorScreen.this.craftingMonitor.onTabSelectionChanged(Optional.of(((Task)CraftingMonitorScreen.this.tasks.get(tab)).id));
                CraftingMonitorScreen.this.scrollbar.setOffset(0);
            }

            @Override
            public void onPageChanged(int page) {
                CraftingMonitorScreen.this.craftingMonitor.onTabPageChanged(page);
            }
        });
        this.scrollbar = new ScrollbarWidget(this, 235, 20, 12, 149);
    }

    public void setTasks(List<IGridTab> tasks) {
        this.tasks = tasks;
    }

    public List<ICraftingMonitorElement> getElements() {
        if (!this.craftingMonitor.isActiveOnClient()) {
            return Collections.emptyList();
        }
        IGridTab tab = this.getCurrentTab();
        if (tab == null) {
            return Collections.emptyList();
        }
        return ((Task)tab).elements;
    }

    @Override
    public void onPostInit(int x, int y) {
        this.tabs.init(this.field_146999_f);
        if (this.craftingMonitor.getRedstoneModeParameter() != null) {
            this.addSideButton(new RedstoneModeSideButton(this, this.craftingMonitor.getRedstoneModeParameter()));
        }
        String cancel = I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]);
        String cancelAll = I18n.func_135052_a((String)"misc.refinedstorage.cancel_all", (Object[])new Object[0]);
        int cancelButtonWidth = 14 + this.font.func_78256_a(cancel);
        int cancelAllButtonWidth = 14 + this.font.func_78256_a(cancelAll);
        this.cancelButton = this.addButton(x + 7, y + 201 - 20 - 7, cancelButtonWidth, 20, cancel, false, true, btn -> {
            if (this.hasValidTabSelected()) {
                RS.NETWORK_HANDLER.sendToServer(new CraftingMonitorCancelMessage(((Task)this.getCurrentTab()).id));
            }
        });
        this.cancelAllButton = this.addButton(x + 7 + cancelButtonWidth + 4, y + 201 - 20 - 7, cancelAllButtonWidth, 20, cancelAll, false, true, btn -> {
            if (!this.tasks.isEmpty()) {
                RS.NETWORK_HANDLER.sendToServer(new CraftingMonitorCancelMessage(null));
            }
        });
    }

    private void updateScrollbar() {
        if (this.scrollbar != null) {
            this.scrollbar.setEnabled(this.getRows() > 5);
            this.scrollbar.setMaxOffset(this.getRows() - 5);
        }
    }

    private int getRows() {
        return Math.max(0, (int)Math.ceil((float)this.getElements().size() / 3.0f));
    }

    @Override
    public void tick(int x, int y) {
        this.updateScrollbar();
        this.tabs.update();
        if (this.cancelButton != null) {
            this.cancelButton.active = this.hasValidTabSelected();
        }
        if (this.cancelAllButton != null) {
            this.cancelAllButton.active = this.tasks.size() > 0;
        }
    }

    private boolean hasValidTabSelected() {
        return this.getCurrentTab() != null;
    }

    @Nullable
    private IGridTab getCurrentTab() {
        IGridTab tab;
        Optional<UUID> currentTab = this.craftingMonitor.getTabSelected();
        if (currentTab.isPresent() && (tab = this.getTabById(currentTab.get())) != null) {
            return tab;
        }
        if (this.tasks.isEmpty()) {
            return null;
        }
        return this.tasks.get(0);
    }

    @Nullable
    private IGridTab getTabById(UUID id) {
        return this.tasks.stream().filter(t -> ((Task)t).id.equals(id)).findFirst().orElse(null);
    }

    @Override
    public void renderBackground(int x, int y, int mouseX, int mouseY) {
        if (this.craftingMonitor.isActiveOnClient()) {
            this.tabs.drawBackground(x, y - this.tabs.getHeight());
        }
        this.bindTexture("refinedstorage", "gui/crafting_preview.png");
        this.blit(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        this.scrollbar.render();
        this.tabs.drawForeground(x, y - this.tabs.getHeight(), mouseX, mouseY, this.craftingMonitor.isActiveOnClient());
    }

    @Override
    public void renderForeground(int mouseX, int mouseY) {
        this.renderString(7, 7, this.title.func_150254_d());
        int item = this.scrollbar != null ? this.scrollbar.getOffset() * 3 : 0;
        RenderSystem.setupGui3DDiffuseLighting();
        int x = 7;
        int y = 20;
        String itemSelectedTooltip = null;
        for (int i = 0; i < 15; ++i) {
            if (item < this.getElements().size()) {
                ICraftingMonitorElement element = this.getElements().get(item);
                element.draw(x, y, this.drawers);
                if (RenderUtils.inBounds(x, y, 73, 29, mouseX, mouseY)) {
                    itemSelectedTooltip = element.getTooltip();
                }
                if ((i + 1) % 3 == 0) {
                    x = 7;
                    y += 30;
                } else {
                    x += 74;
                }
            }
            ++item;
        }
        if (itemSelectedTooltip != null && !itemSelectedTooltip.isEmpty()) {
            this.renderTooltip(mouseX, mouseY, I18n.func_135052_a((String)itemSelectedTooltip, (Object[])new Object[0]));
        }
        this.tabs.drawTooltip(this.font, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        if (this.tabs.mouseClicked()) {
            return true;
        }
        if (this.scrollbar.mouseClicked(mouseX, mouseY, clickedButton)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, clickedButton);
    }

    public void func_212927_b(double mx, double my) {
        this.scrollbar.func_212927_b(mx, my);
        super.func_212927_b(mx, my);
    }

    public boolean mouseReleased(double mx, double my, int button) {
        return this.scrollbar.mouseReleased(mx, my, button) || super.mouseReleased(mx, my, button);
    }

    public boolean mouseScrolled(double x, double y, double delta) {
        return this.scrollbar.mouseScrolled(x, y, delta) || super.mouseScrolled(x, y, delta);
    }

    public static class Task
    implements IGridTab {
        private UUID id;
        private ICraftingRequestInfo requested;
        private int qty;
        private long executionStarted;
        private int completionPercentage;
        private List<ICraftingMonitorElement> elements;

        public Task(UUID id, ICraftingRequestInfo requested, int qty, long executionStarted, int completionPercentage, List<ICraftingMonitorElement> elements) {
            this.id = id;
            this.requested = requested;
            this.qty = qty;
            this.executionStarted = executionStarted;
            this.completionPercentage = completionPercentage;
            this.elements = elements;
        }

        @Override
        public void drawTooltip(int x, int y, int screenWidth, int screenHeight, FontRenderer fontRenderer) {
            ArrayList textLines = Lists.newArrayList((Object[])new String[]{this.requested.getItem() != null ? this.requested.getItem().func_200301_q().func_150254_d() : this.requested.getFluid().getDisplayName().func_150254_d()});
            ArrayList smallTextLines = Lists.newArrayList();
            int totalSecs = (int)(System.currentTimeMillis() - this.executionStarted) / 1000;
            int minutes = totalSecs % 3600 / 60;
            int seconds = totalSecs % 60;
            smallTextLines.add(I18n.func_135052_a((String)"gui.refinedstorage.crafting_monitor.tooltip.requested", (Object[])new Object[]{this.requested.getFluid() != null ? API.instance().getQuantityFormatter().formatInBucketForm(this.qty) : API.instance().getQuantityFormatter().format(this.qty)}));
            smallTextLines.add(String.format("%02d:%02d", minutes, seconds));
            smallTextLines.add(String.format("%d%%", this.completionPercentage));
            RenderUtils.drawTooltipWithSmallText(textLines, smallTextLines, true, ItemStack.field_190927_a, x, y, screenWidth, screenHeight, fontRenderer);
        }

        @Override
        public List<IFilter> getFilters() {
            return null;
        }

        @Override
        public void drawIcon(int x, int y, IElementDrawer<ItemStack> itemDrawer, IElementDrawer<FluidStack> fluidDrawer) {
            if (this.requested.getItem() != null) {
                RenderSystem.setupGui3DDiffuseLighting();
                itemDrawer.draw(x, y, this.requested.getItem());
            } else {
                fluidDrawer.draw(x, y, this.requested.getFluid());
                RenderSystem.enableAlphaTest();
            }
        }
    }
}

