/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.container.slot.filter.FilterSlot;
import com.raoulvdberge.refinedstorage.container.slot.filter.FluidFilterSlot;
import com.raoulvdberge.refinedstorage.integration.craftingtweaks.CraftingTweaksIntegration;
import com.raoulvdberge.refinedstorage.render.FluidRenderer;
import com.raoulvdberge.refinedstorage.render.RenderSettings;
import com.raoulvdberge.refinedstorage.screen.FluidAmountScreen;
import com.raoulvdberge.refinedstorage.screen.ItemAmountScreen;
import com.raoulvdberge.refinedstorage.screen.grid.AlternativesScreen;
import com.raoulvdberge.refinedstorage.screen.widget.CheckboxWidget;
import com.raoulvdberge.refinedstorage.screen.widget.sidebutton.SideButton;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public abstract class BaseScreen<T extends Container>
extends ContainerScreen<T> {
    public static final int Z_LEVEL_ITEMS = 100;
    public static final int Z_LEVEL_TOOLTIPS = 500;
    public static final int Z_LEVEL_QTY = 300;
    private static final Map<String, ResourceLocation> TEXTURE_CACHE = new HashMap<String, ResourceLocation>();
    private static final Map<Class, Queue<Consumer>> ACTIONS = new HashMap<Class, Queue<Consumer>>();
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private int sideButtonY;

    public BaseScreen(T container, int xSize, int ySize, PlayerInventory inventory, ITextComponent title) {
        super(container, inventory, title);
        this.field_146999_f = xSize;
        this.field_147000_g = ySize;
    }

    private void runActions() {
        this.runActions(((Object)((Object)this)).getClass());
        this.runActions(ContainerScreen.class);
    }

    private void runActions(Class clazz) {
        Queue<Consumer> queue = ACTIONS.get(clazz);
        if (queue != null && !queue.isEmpty()) {
            Consumer callback;
            while ((callback = queue.poll()) != null) {
                callback.accept(this);
            }
        }
    }

    public void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.onPreInit();
        super.init();
        if (CraftingTweaksIntegration.isLoaded()) {
            this.buttons.removeIf(b -> !CraftingTweaksIntegration.isCraftingTweaksClass(b.getClass()));
            this.children.removeIf(c -> !CraftingTweaksIntegration.isCraftingTweaksClass(c.getClass()));
        } else {
            this.buttons.clear();
            this.children.clear();
        }
        this.sideButtonY = 6;
        this.onPostInit(this.field_147003_i, this.field_147009_r);
        this.runActions();
    }

    public void onClose() {
        super.onClose();
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public void tick() {
        super.tick();
        this.runActions();
        this.tick(this.field_147003_i, this.field_147009_r);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float renderPartialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderBackground(this.field_147003_i, this.field_147009_r, mouseX, mouseY);
        for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            FluidStack stack;
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            if (!slot.func_111238_b() || !(slot instanceof FluidFilterSlot) || (stack = ((FluidFilterSlot)slot).getFluidInventory().getFluid(slot.getSlotIndex())).isEmpty()) continue;
            FluidRenderer.INSTANCE.render(this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, stack);
            if (!((FluidFilterSlot)slot).isSizeAllowed()) continue;
            this.renderQuantity(this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, API.instance().getQuantityFormatter().formatInBucketForm(stack.getAmount()), RenderSettings.INSTANCE.getSecondaryColor());
            GL11.glDisable((int)2896);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int i;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderForeground(mouseX -= this.field_147003_i, mouseY -= this.field_147009_r);
        for (i = 0; i < this.buttons.size(); ++i) {
            Widget button = (Widget)this.buttons.get(i);
            if (!(button instanceof SideButton) || !button.isHovered()) continue;
            this.renderTooltip(mouseX, mouseY, ((SideButton)button).getTooltip());
        }
        for (i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            FluidStack stack;
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            if (!slot.func_111238_b() || !(slot instanceof FluidFilterSlot) || (stack = ((FluidFilterSlot)slot).getFluidInventory().getFluid(slot.getSlotIndex())).isEmpty() || !RenderUtils.inBounds(slot.field_75223_e, slot.field_75221_f, 17, 17, mouseX, mouseY)) continue;
            this.renderTooltip(mouseX, mouseY, stack.getDisplayName().func_150254_d());
        }
    }

    protected void func_184098_a(Slot slot, int slotId, int mouseButton, ClickType type) {
        boolean valid;
        boolean bl = valid = type != ClickType.QUICK_MOVE && this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b();
        if (valid && slot instanceof FilterSlot && slot.func_111238_b() && ((FilterSlot)slot).isSizeAllowed()) {
            if (!slot.func_75211_c().func_190926_b()) {
                if (((FilterSlot)slot).isAlternativesAllowed() && BaseScreen.hasControlDown()) {
                    this.minecraft.func_147108_a((Screen)new AlternativesScreen((Screen)this, (PlayerEntity)this.minecraft.field_71439_g, (ITextComponent)new TranslationTextComponent("gui.refinedstorage.alternatives", new Object[0]), slot.func_75211_c(), slot.getSlotIndex()));
                } else {
                    this.minecraft.func_147108_a((Screen)new ItemAmountScreen(this, (PlayerEntity)this.minecraft.field_71439_g, slot.field_75222_d, slot.func_75211_c(), slot.func_75219_a(), ((FilterSlot)slot).isAlternativesAllowed() ? parent -> new AlternativesScreen((Screen)parent, (PlayerEntity)this.minecraft.field_71439_g, (ITextComponent)new TranslationTextComponent("gui.refinedstorage.alternatives", new Object[0]), slot.func_75211_c(), slot.getSlotIndex()) : null));
                }
            }
        } else if (valid && slot instanceof FluidFilterSlot && slot.func_111238_b() && ((FluidFilterSlot)slot).isSizeAllowed()) {
            FluidStack stack = ((FluidFilterSlot)slot).getFluidInventory().getFluid(slot.getSlotIndex());
            if (!stack.isEmpty()) {
                if (((FluidFilterSlot)slot).isAlternativesAllowed() && BaseScreen.hasControlDown()) {
                    this.minecraft.func_147108_a((Screen)new AlternativesScreen((Screen)this, (PlayerEntity)this.minecraft.field_71439_g, (ITextComponent)new TranslationTextComponent("gui.refinedstorage.alternatives", new Object[0]), stack, slot.getSlotIndex()));
                } else {
                    this.minecraft.func_147108_a((Screen)new FluidAmountScreen(this, (PlayerEntity)this.minecraft.field_71439_g, slot.field_75222_d, stack, ((FluidFilterSlot)slot).getFluidInventory().getMaxAmount(), ((FluidFilterSlot)slot).isAlternativesAllowed() ? parent -> new AlternativesScreen((Screen)this, (PlayerEntity)this.minecraft.field_71439_g, (ITextComponent)new TranslationTextComponent("gui.refinedstorage.alternatives", new Object[0]), stack, slot.getSlotIndex()) : null));
                }
            } else {
                super.func_184098_a(slot, slotId, mouseButton, type);
            }
        } else {
            super.func_184098_a(slot, slotId, mouseButton, type);
        }
    }

    public CheckboxWidget addCheckBox(int x, int y, String text, boolean checked, Consumer<CheckboxButton> onPress) {
        CheckboxWidget checkBox = new CheckboxWidget(x, y, text, checked, onPress);
        this.addButton((Widget)checkBox);
        return checkBox;
    }

    public Button addButton(int x, int y, int w, int h, String text, boolean enabled, boolean visible, Button.IPressable onPress) {
        Button button = new Button(x, y, w, h, text, onPress);
        button.active = enabled;
        button.visible = visible;
        this.addButton((Widget)button);
        return button;
    }

    public SideButton addSideButton(SideButton button) {
        button.x = this.field_147003_i + -18 - 2;
        button.y = this.field_147009_r + this.sideButtonY;
        this.sideButtonY += 20;
        this.addButton((Widget)button);
        return button;
    }

    public void bindTexture(String namespace, String filenameInTexturesFolder) {
        this.minecraft.func_110434_K().func_110577_a(TEXTURE_CACHE.computeIfAbsent(namespace + ":" + filenameInTexturesFolder, newId -> new ResourceLocation(namespace, "textures/" + filenameInTexturesFolder)));
    }

    public void renderItem(int x, int y, ItemStack stack) {
        this.renderItem(x, y, stack, false, null, 0);
    }

    public void renderItem(int x, int y, ItemStack stack, boolean overlay, @Nullable String text, int textColor) {
        try {
            this.setBlitOffset(100);
            this.itemRenderer.field_77023_b = 100.0f;
            this.itemRenderer.func_175042_a(stack, x, y);
            if (overlay) {
                this.itemRenderer.func_180453_a(this.font, stack, x, y, "");
            }
            this.setBlitOffset(0);
            this.itemRenderer.field_77023_b = 0.0f;
            if (text != null) {
                this.renderQuantity(x, y, text, textColor);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Couldn't render stack: " + stack.func_77973_b().toString(), t);
        }
    }

    public void renderQuantity(int x, int y, String qty, int color) {
        boolean large = this.minecraft.func_211821_e() || RS.CLIENT_CONFIG.getGrid().getLargeFont();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)300.0f);
        if (!large) {
            RenderSystem.scalef((float)0.5f, (float)0.5f, (float)1.0f);
        }
        this.font.func_175063_a(qty, (float)((large ? 16 : 30) - this.font.func_78256_a(qty)), large ? 8.0f : 22.0f, color);
        RenderSystem.popMatrix();
    }

    public void renderString(int x, int y, String message) {
        this.renderString(x, y, message, RenderSettings.INSTANCE.getPrimaryColor());
    }

    public void renderString(int x, int y, String message, int color) {
        this.font.func_211126_b(message, (float)x, (float)y, color);
    }

    public void renderTooltip(int x, int y, String lines) {
        this.renderTooltip(ItemStack.field_190927_a, x, y, lines);
    }

    public void renderTooltip(@Nonnull ItemStack stack, int x, int y, String lines) {
        this.renderTooltip(stack, x, y, Arrays.asList(lines.split("\n")));
    }

    public void renderTooltip(@Nonnull ItemStack stack, int x, int y, List<String> lines) {
        GuiUtils.drawHoveringText((ItemStack)stack, lines, (int)x, (int)y, (int)this.width, (int)this.height, (int)-1, (FontRenderer)this.font);
    }

    protected void onPreInit() {
    }

    public static boolean isKeyDown(KeyBinding keybinding) {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)keybinding.getKey().func_197937_c()) && keybinding.getKeyConflictContext().isActive() && keybinding.getKeyModifier().isActive(keybinding.getKeyConflictContext());
    }

    public abstract void onPostInit(int var1, int var2);

    public abstract void tick(int var1, int var2);

    public abstract void renderBackground(int var1, int var2, int var3, int var4);

    public abstract void renderForeground(int var1, int var2);

    public static <T> void executeLater(Class<T> clazz, Consumer<T> callback) {
        Queue<Consumer> queue = ACTIONS.get(clazz);
        if (queue == null) {
            queue = new ArrayDeque<Consumer>();
            ACTIONS.put(clazz, queue);
        }
        queue.add(callback);
    }

    public static void executeLater(Consumer<ContainerScreen> callback) {
        BaseScreen.executeLater(ContainerScreen.class, callback);
    }
}

