/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render.tesr;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.block.StorageMonitorBlock;
import com.raoulvdberge.refinedstorage.tile.StorageMonitorTile;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.common.model.TransformationHelper;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class StorageMonitorTileRenderer
extends TileEntityRenderer<StorageMonitorTile> {
    public StorageMonitorTileRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(StorageMonitorTile tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int i, int i1) {
        Direction direction = Direction.NORTH;
        BlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (state.func_177230_c() instanceof StorageMonitorBlock) {
            direction = (Direction)state.func_177229_b((IProperty)RSBlocks.STORAGE_MONITOR.getDirection().getProperty());
        }
        int light = WorldRenderer.func_228421_a_((ILightReader)tile.func_145831_w(), (BlockPos)tile.func_174877_v().func_177971_a(direction.func_176730_m()));
        float rotation = (float)(Math.PI * (double)(360 - direction.func_176734_d().func_176736_b() * 90) / 180.0);
        int type = tile.getStackType();
        ItemStack itemStack = tile.getItemStack();
        FluidStack fluidStack = tile.getFluidStack();
        if (type == 0 && itemStack != null && !itemStack.func_190926_b()) {
            this.renderItem(matrixStack, renderTypeBuffer, direction, rotation, light, itemStack);
            String amount = API.instance().getQuantityFormatter().formatWithUnits(tile.getAmount());
            this.renderText(matrixStack, renderTypeBuffer, direction, rotation, light, amount);
        } else if (type == 1 && fluidStack != null && !fluidStack.isEmpty()) {
            this.renderFluid(matrixStack, renderTypeBuffer, direction, rotation, light, fluidStack);
            String amount = API.instance().getQuantityFormatter().formatInBucketFormWithOnlyTrailingDigitsIfZero(tile.getAmount());
            this.renderText(matrixStack, renderTypeBuffer, direction, rotation, light, amount);
        }
    }

    private void renderText(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, Direction direction, float rotation, int light, String amount) {
        matrixStack.func_227860_a_();
        float stringOffset = -((float)Minecraft.func_71410_x().field_71466_p.func_78256_a(amount) * 0.01f) / 2.0f;
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227861_a_((double)((float)direction.func_82601_c() * 0.5f + (float)direction.func_82599_e() * stringOffset), -0.275, (double)((float)direction.func_82599_e() * 0.5f - (float)direction.func_82601_c() * stringOffset));
        matrixStack.func_227863_a_(TransformationHelper.quatFromXYZ((Vector3f)new Vector3f((float)(direction.func_82601_c() * 180), 0.0f, (float)(direction.func_82599_e() * 180)), (boolean)true));
        matrixStack.func_227863_a_(TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(0.0f, rotation, 0.0f), (boolean)false));
        matrixStack.func_227862_a_(0.01f, 0.01f, 0.01f);
        Minecraft.func_71410_x().field_71466_p.func_228079_a_(amount, 0.0f, 0.0f, -1, false, matrixStack.func_227866_c_().func_227870_a_(), renderTypeBuffer, false, 0, light);
        matrixStack.func_227865_b_();
    }

    private void renderItem(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, Direction direction, float rotation, int light, ItemStack itemStack) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227861_a_((double)((float)direction.func_82601_c() * 0.5f), 0.0, (double)((float)direction.func_82599_e() * 0.5f));
        matrixStack.func_227863_a_(TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(0.0f, rotation, 0.0f), (boolean)false));
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(itemStack, ItemCameraTransforms.TransformType.FIXED, light, OverlayTexture.field_229196_a_, matrixStack, renderTypeBuffer);
        matrixStack.func_227865_b_();
    }

    private void renderFluid(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, Direction direction, float rotation, int light, FluidStack fluidStack) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227861_a_((double)((float)direction.func_82601_c() * 0.51f), 0.5, (double)((float)direction.func_82599_e() * 0.51f));
        matrixStack.func_227863_a_(TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(0.0f, rotation, 0.0f), (boolean)false));
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        Fluid fluid = fluidStack.getFluid();
        FluidAttributes attributes = fluid.getAttributes();
        ResourceLocation fluidStill = attributes.getStillTexture(fluidStack);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidStill);
        int fluidColor = attributes.getColor(fluidStack);
        IVertexBuilder buffer = renderTypeBuffer.getBuffer(RenderType.func_228658_l_((ResourceLocation)sprite.func_229241_m_().func_229223_g_()));
        int colorRed = fluidColor >> 16 & 0xFF;
        int colorGreen = fluidColor >> 8 & 0xFF;
        int colorBlue = fluidColor & 0xFF;
        int colorAlpha = fluidColor >> 24 & 0xFF;
        buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), -0.5f, -0.5f, 0.0f).func_225586_a_(colorRed, colorGreen, colorBlue, colorAlpha).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), 0.5f, -0.5f, 0.0f).func_225586_a_(colorRed, colorGreen, colorBlue, colorAlpha).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), 0.5f, -1.5f, 0.0f).func_225586_a_(colorRed, colorGreen, colorBlue, colorAlpha).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), -0.5f, -1.5f, 0.0f).func_225586_a_(colorRed, colorGreen, colorBlue, colorAlpha).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_227886_a_(light).func_181675_d();
        matrixStack.func_227865_b_();
    }
}

