/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network.grid;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.container.GridContainer;
import com.raoulvdberge.refinedstorage.tile.grid.WirelessGrid;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class WirelessGridSettingsUpdateMessage {
    private int viewType;
    private int sortingDirection;
    private int sortingType;
    private int searchBoxMode;
    private int size;
    private int tabSelected;
    private int tabPage;

    public WirelessGridSettingsUpdateMessage(int viewType, int sortingDirection, int sortingType, int searchBoxMode, int size, int tabSelected, int tabPage) {
        this.viewType = viewType;
        this.sortingDirection = sortingDirection;
        this.sortingType = sortingType;
        this.searchBoxMode = searchBoxMode;
        this.size = size;
        this.tabSelected = tabSelected;
        this.tabPage = tabPage;
    }

    public static WirelessGridSettingsUpdateMessage decode(PacketBuffer buf) {
        return new WirelessGridSettingsUpdateMessage(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void encode(WirelessGridSettingsUpdateMessage message, PacketBuffer buf) {
        buf.writeInt(message.viewType);
        buf.writeInt(message.sortingDirection);
        buf.writeInt(message.sortingType);
        buf.writeInt(message.searchBoxMode);
        buf.writeInt(message.size);
        buf.writeInt(message.tabSelected);
        buf.writeInt(message.tabPage);
    }

    public static void handle(WirelessGridSettingsUpdateMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> WirelessGridSettingsUpdateMessage.lambda$handle$0((PlayerEntity)player, message));
        }
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$0(PlayerEntity player, WirelessGridSettingsUpdateMessage message) {
        IGrid grid;
        if (player.field_71070_bA instanceof GridContainer && (grid = ((GridContainer)player.field_71070_bA).getGrid()) instanceof WirelessGrid) {
            ItemStack stack = ((WirelessGrid)grid).getStack();
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new CompoundNBT());
            }
            if (IGrid.isValidViewType(message.viewType)) {
                stack.func_77978_p().func_74768_a("ViewType", message.viewType);
            }
            if (IGrid.isValidSortingDirection(message.sortingDirection)) {
                stack.func_77978_p().func_74768_a("SortingDirection", message.sortingDirection);
            }
            if (IGrid.isValidSortingType(message.sortingType)) {
                stack.func_77978_p().func_74768_a("SortingType", message.sortingType);
            }
            if (IGrid.isValidSearchBoxMode(message.searchBoxMode)) {
                stack.func_77978_p().func_74768_a("SearchBoxMode", message.searchBoxMode);
            }
            if (IGrid.isValidSize(message.size)) {
                stack.func_77978_p().func_74768_a("Size", message.size);
            }
            stack.func_77978_p().func_74768_a("TabSelected", message.tabSelected);
            stack.func_77978_p().func_74768_a("TabPage", message.tabPage);
        }
    }
}

