/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network.grid;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.container.GridContainer;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class GridCraftingStartRequestMessage {
    private UUID id;
    private int quantity;
    private boolean fluids;

    public GridCraftingStartRequestMessage(UUID id, int quantity, boolean fluids) {
        this.id = id;
        this.quantity = quantity;
        this.fluids = fluids;
    }

    public static GridCraftingStartRequestMessage decode(PacketBuffer buf) {
        return new GridCraftingStartRequestMessage(buf.func_179253_g(), buf.readInt(), buf.readBoolean());
    }

    public static void encode(GridCraftingStartRequestMessage message, PacketBuffer buf) {
        buf.func_179252_a(message.id);
        buf.writeInt(message.quantity);
        buf.writeBoolean(message.fluids);
    }

    public static void handle(GridCraftingStartRequestMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> {
                Container container = player.field_71070_bA;
                if (container instanceof GridContainer) {
                    IGrid grid = ((GridContainer)container).getGrid();
                    if (message.fluids) {
                        if (grid.getFluidHandler() != null) {
                            grid.getFluidHandler().onCraftingRequested(player, message.id, message.quantity);
                        }
                    } else if (grid.getItemHandler() != null) {
                        grid.getItemHandler().onCraftingRequested(player, message.id, message.quantity);
                    }
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

