/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.inventory.item;

import com.raoulvdberge.refinedstorage.inventory.listener.InventoryListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.items.ItemStackHandler;

public class BaseItemHandler
extends ItemStackHandler {
    private final List<InventoryListener<BaseItemHandler>> listeners = new ArrayList<InventoryListener<BaseItemHandler>>();
    private final List<Predicate<ItemStack>> validators = new ArrayList<Predicate<ItemStack>>();
    private boolean empty = true;
    private boolean reading;

    public BaseItemHandler(int size) {
        super(size);
    }

    public BaseItemHandler addValidator(Predicate<ItemStack> validator) {
        this.validators.add(validator);
        return this;
    }

    public BaseItemHandler addListener(InventoryListener<BaseItemHandler> listener) {
        this.listeners.add(listener);
        return this;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.validators.isEmpty()) {
            for (Predicate<ItemStack> validator : this.validators) {
                if (!validator.test(stack)) continue;
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.empty = this.stacks.stream().allMatch(ItemStack::func_190926_b);
        this.listeners.forEach(l -> l.onChanged(this, slot, this.reading));
    }

    public void deserializeNBT(CompoundNBT tag) {
        super.deserializeNBT(tag);
        this.empty = this.stacks.stream().allMatch(ItemStack::func_190926_b);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setReading(boolean reading) {
        this.reading = reading;
    }
}

