/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.inventory.fluid;

import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class ProxyFluidHandler
implements IFluidHandler {
    private FluidTank insertHandler;
    private FluidTank extractHandler;

    public ProxyFluidHandler(FluidTank insertHandler, FluidTank extractHandler) {
        this.insertHandler = insertHandler;
        this.extractHandler = extractHandler;
    }

    public int getTanks() {
        return 2;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return tank == 0 ? this.insertHandler.getFluidInTank(0) : this.extractHandler.getFluidInTank(0);
    }

    public int getTankCapacity(int tank) {
        return tank == 0 ? this.insertHandler.getTankCapacity(0) : this.extractHandler.getTankCapacity(0);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return tank == 0 ? this.insertHandler.isFluidValid(0, stack) : this.extractHandler.isFluidValid(0, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.insertHandler.fill(resource, action);
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.extractHandler.drain(resource, action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.extractHandler.drain(maxDrain, action);
    }
}

