/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.block.BaseBlock;
import com.raoulvdberge.refinedstorage.tile.NetworkNodeTile;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public abstract class NetworkNodeBlock
extends BaseBlock {
    public static final BooleanProperty CONNECTED = BooleanProperty.func_177716_a((String)"connected");

    public NetworkNodeBlock(Block.Properties props) {
        super(props);
        if (this.hasConnectedState()) {
            this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        IItemHandler handler;
        TileEntity tile;
        if (state.func_177230_c() != newState.func_177230_c() && (tile = worldIn.func_175625_s(pos)) instanceof NetworkNodeTile && (handler = ((NetworkNode)((NetworkNodeTile)tile).getNode()).getDrops()) != null) {
            NonNullList drops = NonNullList.func_191196_a();
            for (int i = 0; i < handler.getSlots(); ++i) {
                drops.add((Object)handler.getStackInSlot(i));
            }
            InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, (NonNullList)drops);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    @Override
    protected void onDirectionChanged(World world, BlockPos pos, Direction newDirection) {
        Object node;
        super.onDirectionChanged(world, pos, newDirection);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof INetworkNodeProxy && (node = ((INetworkNodeProxy)tile).getNode()) instanceof NetworkNode) {
            ((NetworkNode)node).onDirectionChanged(newDirection);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        if (this.hasConnectedState()) {
            builder.func_206894_a(new IProperty[]{CONNECTED});
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean hasConnectedState() {
        return false;
    }
}

