/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.block.BlockDirection;
import com.raoulvdberge.refinedstorage.block.CableBlock;
import com.raoulvdberge.refinedstorage.container.DestructorContainer;
import com.raoulvdberge.refinedstorage.container.factory.PositionalTileContainerProvider;
import com.raoulvdberge.refinedstorage.tile.DestructorTile;
import com.raoulvdberge.refinedstorage.util.BlockUtils;
import com.raoulvdberge.refinedstorage.util.CollisionUtils;
import com.raoulvdberge.refinedstorage.util.NetworkUtils;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class DestructorBlock
extends CableBlock {
    private static final VoxelShape HEAD_NORTH = VoxelShapes.func_197872_a((VoxelShape)DestructorBlock.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0), (VoxelShape)HOLDER_NORTH);
    private static final VoxelShape HEAD_EAST = VoxelShapes.func_197872_a((VoxelShape)DestructorBlock.func_208617_a((double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (VoxelShape)HOLDER_EAST);
    private static final VoxelShape HEAD_SOUTH = VoxelShapes.func_197872_a((VoxelShape)DestructorBlock.func_208617_a((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0), (VoxelShape)HOLDER_SOUTH);
    private static final VoxelShape HEAD_WEST = VoxelShapes.func_197872_a((VoxelShape)DestructorBlock.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0), (VoxelShape)HOLDER_WEST);
    private static final VoxelShape HEAD_DOWN = VoxelShapes.func_197872_a((VoxelShape)DestructorBlock.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), (VoxelShape)HOLDER_DOWN);
    private static final VoxelShape HEAD_UP = VoxelShapes.func_197872_a((VoxelShape)DestructorBlock.func_208617_a((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)HOLDER_UP);

    public DestructorBlock() {
        super(BlockUtils.DEFAULT_GLASS_PROPERTIES);
        this.setRegistryName("refinedstorage", "destructor");
    }

    @Override
    public BlockDirection getDirection() {
        return BlockDirection.ANY;
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new DestructorTile();
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        VoxelShape shape = super.func_220053_a(state, world, pos, ctx);
        shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)this.getHeadShape(state));
        return shape;
    }

    private VoxelShape getHeadShape(BlockState state) {
        Direction direction = (Direction)state.func_177229_b((IProperty)this.getDirection().getProperty());
        if (direction == Direction.NORTH) {
            return HEAD_NORTH;
        }
        if (direction == Direction.EAST) {
            return HEAD_EAST;
        }
        if (direction == Direction.SOUTH) {
            return HEAD_SOUTH;
        }
        if (direction == Direction.WEST) {
            return HEAD_WEST;
        }
        if (direction == Direction.UP) {
            return HEAD_UP;
        }
        if (direction == Direction.DOWN) {
            return HEAD_DOWN;
        }
        return VoxelShapes.func_197880_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!world.field_72995_K && CollisionUtils.isInBounds(this.getHeadShape(state), pos, hit.func_216347_e())) {
            return NetworkUtils.attemptModify(world, pos, hit.func_216354_b(), player, () -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), new PositionalTileContainerProvider<DestructorTile>((ITextComponent)new TranslationTextComponent("gui.refinedstorage.destructor", new Object[0]), (tile, windowId, inventory, p) -> new DestructorContainer((DestructorTile)tile, player, windowId), pos), (BlockPos)pos));
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public boolean hasConnectedState() {
        return true;
    }
}

