/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.cache.listener;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.network.grid.PortableGridItemDeltaMessage;
import com.raoulvdberge.refinedstorage.network.grid.PortableGridItemUpdateMessage;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;

public class PortableItemGridStorageCacheListener
implements IStorageCacheListener<ItemStack> {
    private IPortableGrid portableGrid;
    private ServerPlayerEntity player;

    public PortableItemGridStorageCacheListener(IPortableGrid portableGrid, ServerPlayerEntity player) {
        this.portableGrid = portableGrid;
        this.player = player;
    }

    @Override
    public void onAttached() {
        RS.NETWORK_HANDLER.sendTo(this.player, new PortableGridItemUpdateMessage(this.portableGrid));
    }

    @Override
    public void onInvalidated() {
    }

    @Override
    public void onChanged(StackListResult<ItemStack> delta) {
        ArrayList<StackListResult<ItemStack>> deltas = new ArrayList<StackListResult<ItemStack>>();
        deltas.add(delta);
        this.onChangedBulk((List<StackListResult<ItemStack>>)deltas);
    }

    @Override
    public void onChangedBulk(List<StackListResult<ItemStack>> storageCacheDeltas) {
        RS.NETWORK_HANDLER.sendTo(this.player, new PortableGridItemDeltaMessage(this.portableGrid, storageCacheDeltas));
    }
}

