/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.cache.listener;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.network.grid.GridItemDeltaMessage;
import com.raoulvdberge.refinedstorage.network.grid.GridItemUpdateMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;

public class ItemGridStorageCacheListener
implements IStorageCacheListener<ItemStack> {
    private ServerPlayerEntity player;
    private INetwork network;

    public ItemGridStorageCacheListener(ServerPlayerEntity player, INetwork network) {
        this.player = player;
        this.network = network;
    }

    @Override
    public void onAttached() {
        RS.NETWORK_HANDLER.sendTo(this.player, new GridItemUpdateMessage(this.network, this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (PlayerEntity)this.player)));
    }

    @Override
    public void onInvalidated() {
    }

    @Override
    public void onChanged(StackListResult<ItemStack> delta) {
        ArrayList<StackListResult<ItemStack>> deltas = new ArrayList<StackListResult<ItemStack>>();
        deltas.add(delta);
        this.onChangedBulk((List<StackListResult<ItemStack>>)deltas);
    }

    @Override
    public void onChangedBulk(List<StackListResult<ItemStack>> deltas) {
        RS.NETWORK_HANDLER.sendTo(this.player, new GridItemDeltaMessage(this.network, deltas));
    }
}

