/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeVisitor;
import com.raoulvdberge.refinedstorage.api.network.IWirelessTransmitter;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.inventory.item.BaseItemHandler;
import com.raoulvdberge.refinedstorage.inventory.item.UpgradeItemHandler;
import com.raoulvdberge.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.raoulvdberge.refinedstorage.item.UpgradeItem;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.items.IItemHandler;

public class WirelessTransmitterNetworkNode
extends NetworkNode
implements IWirelessTransmitter {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "wireless_transmitter");
    private UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, UpgradeItem.Type.RANGE).addListener(new NetworkNodeInventoryListener(this));

    public WirelessTransmitterNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getWirelessTransmitter().getUsage() + this.upgrades.getEnergyUsage();
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        StackUtils.readItems(this.upgrades, 0, tag);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 0, tag);
        return tag;
    }

    @Override
    public int getRange() {
        return RS.SERVER_CONFIG.getWirelessTransmitter().getBaseRange() + this.upgrades.getUpgradeCount(UpgradeItem.Type.RANGE) * RS.SERVER_CONFIG.getWirelessTransmitter().getRangePerUpgrade();
    }

    @Override
    public BlockPos getOrigin() {
        return this.pos;
    }

    @Override
    public DimensionType getDimension() {
        return this.world.func_201675_m().func_186058_p();
    }

    public BaseItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return this.upgrades;
    }

    @Override
    public boolean canConduct(@Nullable Direction direction) {
        return Direction.DOWN.equals((Object)direction);
    }

    @Override
    public void visit(INetworkNodeVisitor.Operator operator) {
        operator.apply(this.world, this.pos.func_177972_a(Direction.DOWN), Direction.UP);
    }
}

