/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.inventory.fluid.FluidInventory;
import com.raoulvdberge.refinedstorage.inventory.item.BaseItemHandler;
import com.raoulvdberge.refinedstorage.inventory.item.UpgradeItemHandler;
import com.raoulvdberge.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.raoulvdberge.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.raoulvdberge.refinedstorage.item.UpgradeItem;
import com.raoulvdberge.refinedstorage.tile.ConstructorTile;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.Position;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ConstructorNetworkNode
extends NetworkNode
implements IComparable,
IType {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "constructor");
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_DROP = "Drop";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private static final int BASE_SPEED = 20;
    private BaseItemHandler itemFilters = new BaseItemHandler(1).addListener(new NetworkNodeInventoryListener(this));
    private FluidInventory fluidFilters = new FluidInventory(1).addListener(new NetworkNodeFluidInventoryListener(this));
    private UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, UpgradeItem.Type.SPEED, UpgradeItem.Type.CRAFTING, UpgradeItem.Type.STACK).addListener(new NetworkNodeInventoryListener(this));
    private int compare = 1;
    private int type = 0;
    private boolean drop = false;

    public ConstructorNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getConstructor().getUsage() + this.upgrades.getEnergyUsage();
    }

    @Override
    public void update() {
        super.update();
        if (this.canUpdate() && this.ticks % this.upgrades.getSpeed(20, 4) == 0) {
            if (this.type == 0 && !this.itemFilters.getStackInSlot(0).func_190926_b()) {
                ItemStack stack = this.itemFilters.getStackInSlot(0);
                if (this.drop) {
                    this.extractAndDropItem(stack);
                } else if (stack.func_77973_b() == Items.field_196152_dE) {
                    this.extractAndSpawnFireworks(stack);
                } else if (stack.func_77973_b() instanceof BlockItem) {
                    this.extractAndPlaceBlock(stack);
                }
            } else if (this.type == 1 && !this.fluidFilters.getFluid(0).isEmpty()) {
                this.extractAndPlaceFluid(this.fluidFilters.getFluid(0));
            }
        }
    }

    private void extractAndPlaceFluid(FluidStack stack) {
        BlockPos front = this.pos.func_177972_a(this.getDirection());
        if (this.network.extractFluid(stack, 1000, this.compare, Action.SIMULATE).getAmount() < 1000) {
            if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
                this.network.getCraftingManager().request((Object)this, stack, 1000);
            }
        } else if (this.world.func_175623_d(front) && FluidUtil.tryPlaceFluid((PlayerEntity)WorldUtils.getFakePlayer((ServerWorld)this.world, this.getOwner()), (World)this.world, (Hand)Hand.MAIN_HAND, (BlockPos)front, (IFluidHandler)new NetworkFluidHandler(StackUtils.copy(stack, 1000)), (FluidStack)stack)) {
            this.network.extractFluid(stack, 1000, Action.PERFORM);
        }
    }

    private void extractAndPlaceBlock(ItemStack stack) {
        if (!this.network.extractItem(stack, 1, this.compare, Action.SIMULATE).func_190926_b()) {
            ConstructorBlockItemUseContext ctx = new ConstructorBlockItemUseContext(this.world, (PlayerEntity)WorldUtils.getFakePlayer((ServerWorld)this.world, this.getOwner()), Hand.MAIN_HAND, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1), new BlockRayTraceResult(Vec3d.field_186680_a, this.getDirection(), this.pos, false));
            ActionResultType result = ForgeHooks.onPlaceItemIntoWorld((ItemUseContext)ctx);
            if (result == ActionResultType.SUCCESS) {
                this.network.extractItem(stack, 1, Action.PERFORM);
            }
        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
            ItemStack craft = this.itemFilters.getStackInSlot(0);
            this.network.getCraftingManager().request((Object)this, craft, 1);
        }
    }

    private void extractAndDropItem(ItemStack stack) {
        ItemStack took = this.network.extractItem(stack, this.upgrades.getStackInteractCount(), Action.PERFORM);
        if (!took.func_190926_b()) {
            DefaultDispenseItemBehavior.func_82486_a((World)this.world, (ItemStack)took, (int)6, (Direction)this.getDirection(), (IPosition)new Position(this.getDispensePositionX(), this.getDispensePositionY(), this.getDispensePositionZ()));
        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
            this.network.getCraftingManager().request((Object)this, stack, 1);
        }
    }

    private void extractAndSpawnFireworks(ItemStack stack) {
        ItemStack took = this.network.extractItem(stack, 1, Action.PERFORM);
        if (!took.func_190926_b()) {
            this.world.func_217376_c((Entity)new FireworkRocketEntity(this.world, this.getDispensePositionX(), this.getDispensePositionY(), this.getDispensePositionZ(), took));
        }
    }

    private double getDispensePositionX() {
        return (double)this.pos.func_177958_n() + 0.5 + 0.8 * (double)this.getDirection().func_82601_c();
    }

    private double getDispensePositionY() {
        return (double)this.pos.func_177956_o() + (this.getDirection() == Direction.DOWN ? 0.45 : 0.5) + 0.8 * (double)this.getDirection().func_96559_d();
    }

    private double getDispensePositionZ() {
        return (double)this.pos.func_177952_p() + 0.5 + 0.8 * (double)this.getDirection().func_82599_e();
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        StackUtils.readItems(this.upgrades, 1, tag);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        return tag;
    }

    @Override
    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_TYPE, this.type);
        tag.func_74757_a(NBT_DROP, this.drop);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        tag.func_218657_a(NBT_FLUID_FILTERS, (INBT)this.fluidFilters.writeToNbt());
        return tag;
    }

    @Override
    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        if (tag.func_74764_b(NBT_DROP)) {
            this.drop = tag.func_74767_n(NBT_DROP);
        }
        StackUtils.readItems(this.itemFilters, 0, tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
    }

    public boolean isDrop() {
        return this.drop;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return this.upgrades;
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? ConstructorTile.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    @Override
    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    private class ConstructorBlockItemUseContext
    extends BlockItemUseContext {
        public ConstructorBlockItemUseContext(@Nullable World worldIn, PlayerEntity playerIn, Hand handIn, ItemStack stackIn, BlockRayTraceResult rayTraceResultIn) {
            super(worldIn, playerIn, handIn, stackIn, rayTraceResultIn);
        }
    }

    private class NetworkFluidHandler
    implements IFluidHandler {
        private FluidStack resource;

        public NetworkFluidHandler(FluidStack resource) {
            this.resource = resource;
        }

        public int getTanks() {
            throw new RuntimeException("Cannot be called");
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            throw new RuntimeException("Cannot be called");
        }

        public int getTankCapacity(int tank) {
            throw new RuntimeException("Cannot be called");
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            throw new RuntimeException("Cannot be called");
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            throw new RuntimeException("Cannot be called");
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return ConstructorNetworkNode.this.network.extractFluid(resource, resource.getAmount(), action == IFluidHandler.FluidAction.SIMULATE ? Action.SIMULATE : Action.PERFORM);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return ConstructorNetworkNode.this.network.extractFluid(this.resource, this.resource.getAmount(), action == IFluidHandler.FluidAction.SIMULATE ? Action.SIMULATE : Action.PERFORM);
        }
    }
}

