/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTaskError;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.ErrorCraftingPreviewElement;
import com.raoulvdberge.refinedstorage.network.grid.GridCraftingPreviewResponseMessage;
import com.raoulvdberge.refinedstorage.network.grid.GridCraftingStartResponseMessage;
import com.raoulvdberge.refinedstorage.util.NetworkUtils;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;

public class FluidGridHandler
implements IFluidGridHandler {
    private INetwork network;

    public FluidGridHandler(INetwork network) {
        this.network = network;
    }

    @Override
    public void onExtract(ServerPlayerEntity player, UUID id, boolean shift) {
        FluidStack stack = this.network.getFluidStorageCache().getList().get(id);
        if (stack == null || stack.getAmount() < 1000 || !this.network.getSecurityManager().hasPermission(Permission.EXTRACT, (PlayerEntity)player)) {
            return;
        }
        NetworkUtils.extractBucketFromPlayerInventoryOrNetwork((PlayerEntity)player, this.network, bucket -> bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(fluidHandler -> {
            this.network.getFluidStorageTracker().changed((PlayerEntity)player, stack.copy());
            FluidStack extracted = this.network.extractFluid(stack, 1000, Action.PERFORM);
            fluidHandler.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
            if (shift) {
                if (!player.field_71071_by.func_70441_a(fluidHandler.getContainer().func_77946_l())) {
                    InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)fluidHandler.getContainer());
                }
            } else {
                player.field_71071_by.func_70437_b(fluidHandler.getContainer());
                player.func_71113_k();
            }
            this.network.getNetworkItemManager().drainEnergy((PlayerEntity)player, RS.SERVER_CONFIG.getWirelessFluidGrid().getExtractUsage());
        }));
    }

    @Override
    @Nonnull
    public ItemStack onInsert(ServerPlayerEntity player, ItemStack container) {
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, (PlayerEntity)player)) {
            return container;
        }
        Pair<ItemStack, FluidStack> result = StackUtils.getFluid(container, true);
        if (!((FluidStack)result.getValue()).isEmpty() && this.network.insertFluid((FluidStack)result.getValue(), ((FluidStack)result.getValue()).getAmount(), Action.SIMULATE).isEmpty()) {
            this.network.getFluidStorageTracker().changed((PlayerEntity)player, ((FluidStack)result.getValue()).copy());
            result = StackUtils.getFluid(container, false);
            this.network.insertFluid((FluidStack)result.getValue(), ((FluidStack)result.getValue()).getAmount(), Action.PERFORM);
            this.network.getNetworkItemManager().drainEnergy((PlayerEntity)player, RS.SERVER_CONFIG.getWirelessFluidGrid().getInsertUsage());
            return (ItemStack)result.getLeft();
        }
        return container;
    }

    @Override
    public void onInsertHeldContainer(ServerPlayerEntity player) {
        player.field_71071_by.func_70437_b(this.onInsert(player, player.field_71071_by.func_70445_o()));
        player.func_71113_k();
    }

    @Override
    public void onCraftingPreviewRequested(ServerPlayerEntity player, UUID id, int quantity, boolean noPreview) {
        if (!this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (PlayerEntity)player)) {
            return;
        }
        FluidStack stack = this.network.getFluidStorageCache().getCraftablesList().get(id);
        if (stack != null) {
            Thread calculationThread = new Thread(() -> {
                ICraftingTask task = this.network.getCraftingManager().create(stack, quantity);
                if (task == null) {
                    return;
                }
                ICraftingTaskError error = task.calculate();
                ResourceLocation factoryId = task.getPattern().getCraftingTaskFactoryId();
                if (error != null) {
                    RS.NETWORK_HANDLER.sendTo(player, new GridCraftingPreviewResponseMessage(factoryId, Collections.singletonList(new ErrorCraftingPreviewElement(error.getType(), error.getRecursedPattern() == null ? ItemStack.field_190927_a : error.getRecursedPattern().getStack())), id, quantity, true));
                } else if (noPreview && !task.hasMissing()) {
                    this.network.getCraftingManager().add(task);
                    RS.NETWORK_HANDLER.sendTo(player, new GridCraftingStartResponseMessage());
                } else {
                    RS.NETWORK_HANDLER.sendTo(player, new GridCraftingPreviewResponseMessage(factoryId, task.getPreviewStacks(), id, quantity, true));
                }
            }, "RS crafting preview calculation");
            calculationThread.start();
        }
    }

    @Override
    public void onCraftingRequested(ServerPlayerEntity player, UUID id, int quantity) {
        if (quantity <= 0 || !this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (PlayerEntity)player)) {
            return;
        }
        FluidStack stack = this.network.getFluidStorageCache().getCraftablesList().get(id);
        if (stack != null) {
            ICraftingTask task = this.network.getCraftingManager().create(stack, quantity);
            if (task == null) {
                return;
            }
            ICraftingTaskError error = task.calculate();
            if (error == null && !task.hasMissing()) {
                this.network.getCraftingManager().add(task);
            }
        }
    }
}

