/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v5;

import com.google.common.collect.Maps;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternChain;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternChainList;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElementList;
import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskErrorType;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingRequestInfo;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTaskError;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.ErrorCraftingMonitorElement;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.FluidCraftingMonitorElement;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.ItemCraftingMonitorElement;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.FluidCraftingPreviewElement;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.ItemCraftingPreviewElement;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v5.Crafting;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v5.CraftingTaskError;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v5.Processing;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v5.ProcessingState;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.FluidStorageDisk;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.ItemStorageDisk;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.factory.FluidStorageDiskFactory;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.factory.ItemStorageDiskFactory;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftingTask
implements ICraftingTask {
    private static final String NBT_REQUESTED = "Requested";
    private static final String NBT_QUANTITY = "Quantity";
    private static final String NBT_PATTERN = "Pattern";
    private static final String NBT_TICKS = "Ticks";
    private static final String NBT_ID = "Id";
    private static final String NBT_EXECUTION_STARTED = "ExecutionStarted";
    private static final String NBT_INTERNAL_STORAGE = "InternalStorage";
    private static final String NBT_INTERNAL_FLUID_STORAGE = "InternalFluidStorage";
    private static final String NBT_TO_EXTRACT_INITIAL = "ToExtractInitial";
    private static final String NBT_TO_EXTRACT_INITIAL_FLUIDS = "ToExtractInitialFluids";
    private static final String NBT_CRAFTING = "Crafting";
    private static final String NBT_PROCESSING = "Processing";
    private static final String NBT_MISSING = "Missing";
    private static final String NBT_MISSING_FLUIDS = "MissingFluids";
    private static final String NBT_TOTAL_STEPS = "TotalSteps";
    private static final String NBT_PATTERN_STACK = "Stack";
    private static final String NBT_PATTERN_CONTAINER_POS = "ContainerPos";
    private static final int DEFAULT_EXTRACT_FLAGS = 1;
    private static final Logger LOGGER = LogManager.getLogger(CraftingTask.class);
    private INetwork network;
    private ICraftingRequestInfo requested;
    private int quantity;
    private ICraftingPattern pattern;
    private UUID id = UUID.randomUUID();
    private int ticks;
    private long calculationStarted = -1L;
    private long executionStarted = -1L;
    private int totalSteps;
    private Set<ICraftingPattern> patternsUsed = new HashSet<ICraftingPattern>();
    private IStorageDisk<ItemStack> internalStorage;
    private IStorageDisk<FluidStack> internalFluidStorage;
    private IStackList<ItemStack> toExtractInitial = API.instance().createItemStackList();
    private IStackList<FluidStack> toExtractInitialFluids = API.instance().createFluidStackList();
    private List<Crafting> crafting = new ArrayList<Crafting>();
    private List<Processing> processing = new ArrayList<Processing>();
    private IStackList<ItemStack> missing = API.instance().createItemStackList();
    private IStackList<FluidStack> missingFluids = API.instance().createFluidStackList();
    private IStackList<ItemStack> toTake = API.instance().createItemStackList();
    private IStackList<FluidStack> toTakeFluids = API.instance().createFluidStackList();
    private IStackList<ItemStack> toCraft = API.instance().createItemStackList();
    private IStackList<FluidStack> toCraftFluids = API.instance().createFluidStackList();

    public CraftingTask(INetwork network, ICraftingRequestInfo requested, int quantity, ICraftingPattern pattern) {
        this.network = network;
        this.requested = requested;
        this.quantity = quantity;
        this.pattern = pattern;
        this.internalStorage = new ItemStorageDisk(null, -1);
        this.internalFluidStorage = new FluidStorageDisk(null, -1);
    }

    public CraftingTask(INetwork network, CompoundNBT tag) throws CraftingTaskReadException {
        this.network = network;
        this.requested = API.instance().createCraftingRequestInfo(tag.func_74775_l(NBT_REQUESTED));
        this.quantity = tag.func_74762_e(NBT_QUANTITY);
        this.pattern = CraftingTask.readPatternFromNbt(tag.func_74775_l(NBT_PATTERN), network.getWorld());
        this.ticks = tag.func_74762_e(NBT_TICKS);
        this.id = tag.func_186857_a(NBT_ID);
        this.executionStarted = tag.func_74763_f(NBT_EXECUTION_STARTED);
        if (tag.func_74764_b(NBT_TOTAL_STEPS)) {
            this.totalSteps = tag.func_74762_e(NBT_TOTAL_STEPS);
        }
        ItemStorageDiskFactory factoryItem = new ItemStorageDiskFactory();
        FluidStorageDiskFactory factoryFluid = new FluidStorageDiskFactory();
        this.internalStorage = factoryItem.createFromNbt(null, tag.func_74775_l(NBT_INTERNAL_STORAGE));
        this.internalFluidStorage = factoryFluid.createFromNbt(null, tag.func_74775_l(NBT_INTERNAL_FLUID_STORAGE));
        this.toExtractInitial = CraftingTask.readItemStackList(tag.func_150295_c(NBT_TO_EXTRACT_INITIAL, 10));
        this.toExtractInitialFluids = CraftingTask.readFluidStackList(tag.func_150295_c(NBT_TO_EXTRACT_INITIAL_FLUIDS, 10));
        ListNBT craftingList = tag.func_150295_c(NBT_CRAFTING, 10);
        for (int i = 0; i < craftingList.size(); ++i) {
            this.crafting.add(new Crafting(network, craftingList.func_150305_b(i)));
        }
        ListNBT processingList = tag.func_150295_c(NBT_PROCESSING, 10);
        for (int i = 0; i < processingList.size(); ++i) {
            this.processing.add(new Processing(network, processingList.func_150305_b(i)));
        }
        this.missing = CraftingTask.readItemStackList(tag.func_150295_c(NBT_MISSING, 10));
        this.missingFluids = CraftingTask.readFluidStackList(tag.func_150295_c(NBT_MISSING_FLUIDS, 10));
    }

    @Override
    public CompoundNBT writeToNbt(CompoundNBT tag) {
        tag.func_218657_a(NBT_REQUESTED, (INBT)this.requested.writeToNbt());
        tag.func_74768_a(NBT_QUANTITY, this.quantity);
        tag.func_218657_a(NBT_PATTERN, (INBT)CraftingTask.writePatternToNbt(this.pattern));
        tag.func_74768_a(NBT_TICKS, this.ticks);
        tag.func_186854_a(NBT_ID, this.id);
        tag.func_74772_a(NBT_EXECUTION_STARTED, this.executionStarted);
        tag.func_218657_a(NBT_INTERNAL_STORAGE, (INBT)this.internalStorage.writeToNbt());
        tag.func_218657_a(NBT_INTERNAL_FLUID_STORAGE, (INBT)this.internalFluidStorage.writeToNbt());
        tag.func_218657_a(NBT_TO_EXTRACT_INITIAL, (INBT)CraftingTask.writeItemStackList(this.toExtractInitial));
        tag.func_218657_a(NBT_TO_EXTRACT_INITIAL_FLUIDS, (INBT)CraftingTask.writeFluidStackList(this.toExtractInitialFluids));
        tag.func_74768_a(NBT_TOTAL_STEPS, this.totalSteps);
        ListNBT craftingList = new ListNBT();
        for (Crafting crafting : this.crafting) {
            craftingList.add((Object)crafting.writeToNbt());
        }
        tag.func_218657_a(NBT_CRAFTING, (INBT)craftingList);
        ListNBT processingList = new ListNBT();
        for (Processing processing : this.processing) {
            processingList.add((Object)processing.writeToNbt());
        }
        tag.func_218657_a(NBT_PROCESSING, (INBT)processingList);
        tag.func_218657_a(NBT_MISSING, (INBT)CraftingTask.writeItemStackList(this.missing));
        tag.func_218657_a(NBT_MISSING_FLUIDS, (INBT)CraftingTask.writeFluidStackList(this.missingFluids));
        return tag;
    }

    static ListNBT writeItemStackList(IStackList<ItemStack> stacks) {
        ListNBT list = new ListNBT();
        for (StackListEntry<ItemStack> entry : stacks.getStacks()) {
            list.add((Object)StackUtils.serializeStackToNbt(entry.getStack()));
        }
        return list;
    }

    static IStackList<ItemStack> readItemStackList(ListNBT list) throws CraftingTaskReadException {
        IStackList<ItemStack> stacks = API.instance().createItemStackList();
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = StackUtils.deserializeStackFromNbt(list.func_150305_b(i));
            if (stack.func_190926_b()) {
                throw new CraftingTaskReadException("Empty stack!");
            }
            stacks.add(stack);
        }
        return stacks;
    }

    static ListNBT writeFluidStackList(IStackList<FluidStack> stacks) {
        ListNBT list = new ListNBT();
        for (StackListEntry<FluidStack> entry : stacks.getStacks()) {
            list.add((Object)entry.getStack().writeToNBT(new CompoundNBT()));
        }
        return list;
    }

    static IStackList<FluidStack> readFluidStackList(ListNBT list) throws CraftingTaskReadException {
        IStackList<FluidStack> stacks = API.instance().createFluidStackList();
        for (int i = 0; i < list.size(); ++i) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)list.func_150305_b(i));
            if (stack.isEmpty()) {
                throw new CraftingTaskReadException("Empty stack!");
            }
            stacks.add(stack);
        }
        return stacks;
    }

    @Override
    @Nullable
    public ICraftingTaskError calculate() {
        if (this.calculationStarted != -1L) {
            throw new IllegalStateException("Task already calculated!");
        }
        if (this.executionStarted != -1L) {
            throw new IllegalStateException("Task already started!");
        }
        this.calculationStarted = System.currentTimeMillis();
        int qty = this.quantity;
        int qtyPerCraft = this.getQuantityPerCraft();
        int crafted = 0;
        IStackList<ItemStack> results = API.instance().createItemStackList();
        IStackList<FluidStack> fluidResults = API.instance().createFluidStackList();
        IStackList<ItemStack> storage = this.network.getItemStorageCache().getList().copy();
        IStackList<FluidStack> fluidStorage = this.network.getFluidStorageCache().getList().copy();
        ICraftingPatternChainList patternChainList = this.network.getCraftingManager().createPatternChainList();
        ICraftingPatternChain patternChain = patternChainList.getChain(this.pattern);
        while (qty > 0) {
            ICraftingTaskError result = this.calculateInternal(storage, fluidStorage, results, fluidResults, patternChainList, patternChain.current(), true);
            if (result != null) {
                return result;
            }
            qty -= qtyPerCraft;
            crafted += qtyPerCraft;
            patternChain.cycle();
        }
        if (this.requested.getItem() != null) {
            this.toCraft.add(this.requested.getItem(), crafted);
        } else {
            this.toCraftFluids.add(this.requested.getFluid(), crafted);
        }
        return null;
    }

    @Nullable
    private ICraftingTaskError calculateInternal(IStackList<ItemStack> mutatedStorage, IStackList<FluidStack> mutatedFluidStorage, IStackList<ItemStack> results, IStackList<FluidStack> fluidResults, ICraftingPatternChainList patternChainList, ICraftingPattern pattern, boolean root) {
        ICraftingTaskError result;
        ICraftingPatternChain subPatternChain;
        int remaining;
        ItemStack fromNetwork;
        ItemStack fromSelf;
        ItemStack possibleInput;
        Object possibleInputs;
        if (System.currentTimeMillis() - this.calculationStarted > (long)RS.SERVER_CONFIG.getAutocrafting().getCalculationTimeoutMs()) {
            return new CraftingTaskError(CraftingTaskErrorType.TOO_COMPLEX);
        }
        if (!this.patternsUsed.add(pattern)) {
            return new CraftingTaskError(CraftingTaskErrorType.RECURSIVE, pattern);
        }
        IStackList<ItemStack> itemsToExtract = API.instance().createItemStackList();
        IStackList<FluidStack> fluidsToExtract = API.instance().createFluidStackList();
        NonNullList took = NonNullList.func_191196_a();
        for (NonNullList<ItemStack> nonNullList : pattern.getInputs()) {
            if (nonNullList.isEmpty()) {
                took.add((Object)ItemStack.field_190927_a);
                continue;
            }
            possibleInputs = new PossibleInputs(new ArrayList<ItemStack>((Collection<ItemStack>)nonNullList));
            ((PossibleInputs)possibleInputs).sort(mutatedStorage, results);
            possibleInput = ((PossibleInputs)possibleInputs).get();
            fromSelf = results.get(possibleInput);
            fromNetwork = mutatedStorage.get(possibleInput);
            took.add((Object)possibleInput);
            remaining = possibleInput.func_190916_E();
            while (remaining > 0) {
                if (fromSelf != null) {
                    int toTake = Math.min(remaining, fromSelf.func_190916_E());
                    itemsToExtract.add(possibleInput, toTake);
                    results.remove(fromSelf, toTake);
                    remaining -= toTake;
                    fromSelf = results.get(possibleInput);
                    continue;
                }
                if (fromNetwork != null) {
                    int toTake = Math.min(remaining, fromNetwork.func_190916_E());
                    this.toTake.add(possibleInput, toTake);
                    itemsToExtract.add(possibleInput, toTake);
                    mutatedStorage.remove(fromNetwork, toTake);
                    remaining -= toTake;
                    fromNetwork = mutatedStorage.get(possibleInput);
                    this.toExtractInitial.add((ItemStack)took.get(took.size() - 1));
                    continue;
                }
                ICraftingPattern subPattern = this.network.getCraftingManager().getPattern(possibleInput);
                if (subPattern != null) {
                    subPatternChain = patternChainList.getChain(subPattern);
                    while ((fromSelf == null ? 0 : fromSelf.func_190916_E()) < remaining) {
                        result = this.calculateInternal(mutatedStorage, mutatedFluidStorage, results, fluidResults, patternChainList, subPatternChain.current(), false);
                        if (result != null) {
                            return result;
                        }
                        fromSelf = results.get(possibleInput);
                        if (fromSelf == null) {
                            throw new IllegalStateException("Recursive calculation didn't yield anything");
                        }
                        fromNetwork = mutatedStorage.get(possibleInput);
                        subPatternChain.cycle();
                    }
                    this.toCraft.add(possibleInput, fromSelf.func_190916_E());
                    continue;
                }
                if (!((PossibleInputs)possibleInputs).cycle()) {
                    possibleInput = ((PossibleInputs)possibleInputs).get();
                    this.missing.add(possibleInput, remaining);
                    itemsToExtract.add(possibleInput, remaining);
                    remaining = 0;
                    continue;
                }
                possibleInput = ((PossibleInputs)possibleInputs).get();
                fromSelf = results.get(possibleInput);
                fromNetwork = mutatedStorage.get(possibleInput);
            }
        }
        for (NonNullList<ItemStack> nonNullList : pattern.getFluidInputs()) {
            if (nonNullList.isEmpty()) continue;
            possibleInputs = new PossibleFluidInputs(new ArrayList<ItemStack>((Collection<ItemStack>)nonNullList));
            ((PossibleFluidInputs)possibleInputs).sort(mutatedFluidStorage, fluidResults);
            possibleInput = ((PossibleFluidInputs)possibleInputs).get();
            fromSelf = fluidResults.get((FluidStack)possibleInput, 1);
            fromNetwork = mutatedFluidStorage.get((FluidStack)possibleInput, 1);
            remaining = possibleInput.getAmount();
            while (remaining > 0) {
                if (fromSelf != null) {
                    int toTake = Math.min(remaining, fromSelf.getAmount());
                    fluidsToExtract.add((FluidStack)possibleInput, toTake);
                    fluidResults.remove((FluidStack)possibleInput, toTake);
                    remaining -= toTake;
                    fromSelf = fluidResults.get((FluidStack)possibleInput, 1);
                    continue;
                }
                if (fromNetwork != null) {
                    int toTake = Math.min(remaining, fromNetwork.getAmount());
                    this.toTakeFluids.add((FluidStack)possibleInput, toTake);
                    fluidsToExtract.add((FluidStack)possibleInput, toTake);
                    mutatedFluidStorage.remove((FluidStack)fromNetwork, toTake);
                    remaining -= toTake;
                    fromNetwork = mutatedFluidStorage.get((FluidStack)possibleInput, 1);
                    this.toExtractInitialFluids.add((FluidStack)possibleInput);
                    continue;
                }
                ICraftingPattern subPattern = this.network.getCraftingManager().getPattern((FluidStack)possibleInput);
                if (subPattern != null) {
                    subPatternChain = patternChainList.getChain(subPattern);
                    while ((fromSelf == null ? 0 : fromSelf.getAmount()) < remaining) {
                        result = this.calculateInternal(mutatedStorage, mutatedFluidStorage, results, fluidResults, patternChainList, subPatternChain.current(), false);
                        if (result != null) {
                            return result;
                        }
                        fromSelf = fluidResults.get((FluidStack)possibleInput, 1);
                        if (fromSelf == null) {
                            throw new IllegalStateException("Recursive fluid calculation didn't yield anything");
                        }
                        fromNetwork = mutatedFluidStorage.get((FluidStack)possibleInput, 1);
                        subPatternChain.cycle();
                    }
                    this.toCraftFluids.add((FluidStack)possibleInput, fromSelf.getAmount());
                    continue;
                }
                this.missingFluids.add((FluidStack)possibleInput, remaining);
                fluidsToExtract.add((FluidStack)possibleInput, remaining);
                remaining = 0;
            }
        }
        this.patternsUsed.remove(pattern);
        if (pattern.isProcessing()) {
            IStackList<ItemStack> itemsToReceive = API.instance().createItemStackList();
            IStackList<FluidStack> iStackList = API.instance().createFluidStackList();
            for (ItemStack output : pattern.getOutputs()) {
                results.add(output);
                itemsToReceive.add(output);
            }
            for (ItemStack output : pattern.getFluidOutputs()) {
                fluidResults.add((FluidStack)output);
                iStackList.add((FluidStack)output);
            }
            this.processing.add(new Processing(pattern, itemsToReceive, iStackList, itemsToExtract, fluidsToExtract, root));
        } else {
            if (!fluidsToExtract.isEmpty()) {
                throw new IllegalStateException("Cannot extract fluids in normal pattern!");
            }
            this.crafting.add(new Crafting(pattern, (NonNullList<ItemStack>)took, itemsToExtract, root));
            results.add(pattern.getOutput((NonNullList<ItemStack>)took));
            for (ItemStack itemStack : pattern.getByproducts((NonNullList<ItemStack>)took)) {
                results.add(itemStack);
            }
        }
        return null;
    }

    private void extractInitial() {
        ItemStack result;
        ArrayList<ItemStack> toRemove;
        if (!this.toExtractInitial.isEmpty()) {
            toRemove = new ArrayList<ItemStack>();
            for (StackListEntry<ItemStack> stackListEntry : this.toExtractInitial.getStacks()) {
                result = this.network.extractItem(stackListEntry.getStack(), stackListEntry.getStack().func_190916_E(), Action.PERFORM);
                if (result.func_190926_b()) continue;
                this.internalStorage.insert(stackListEntry.getStack(), result.func_190916_E(), Action.PERFORM);
                toRemove.add(result);
            }
            for (ItemStack itemStack : toRemove) {
                this.toExtractInitial.remove(itemStack);
            }
            if (!toRemove.isEmpty()) {
                this.network.getCraftingManager().onTaskChanged();
            }
        }
        if (!this.toExtractInitialFluids.isEmpty()) {
            toRemove = new ArrayList();
            for (StackListEntry<Object> stackListEntry : this.toExtractInitialFluids.getStacks()) {
                result = this.network.extractFluid((FluidStack)stackListEntry.getStack(), ((FluidStack)stackListEntry.getStack()).getAmount(), Action.PERFORM);
                if (result.isEmpty()) continue;
                this.internalFluidStorage.insert((FluidStack)stackListEntry.getStack(), result.getAmount(), Action.PERFORM);
                toRemove.add(result);
            }
            for (FluidStack fluidStack : toRemove) {
                this.toExtractInitialFluids.remove(fluidStack);
            }
            if (!toRemove.isEmpty()) {
                this.network.getCraftingManager().onTaskChanged();
            }
        }
    }

    private void updateCrafting() {
        Iterator<Crafting> it = this.crafting.iterator();
        HashMap counter = Maps.newHashMap();
        while (it.hasNext()) {
            ItemStack result;
            Crafting c = it.next();
            ICraftingPatternContainer container = c.getPattern().getContainer();
            int interval = container.getUpdateInterval();
            if (interval < 0) {
                throw new IllegalStateException(c.getPattern().getContainer() + " has an update interval of < 0");
            }
            if (interval != 0 && this.ticks % interval != 0 || counter.getOrDefault(container, 0).intValue() == container.getMaximumSuccessfulCraftingUpdates()) continue;
            boolean hasAll = true;
            for (StackListEntry<ItemStack> need : c.getToExtract().getStacks()) {
                result = this.internalStorage.extract(need.getStack(), need.getStack().func_190916_E(), 1, Action.SIMULATE);
                if (result.func_190916_E() == need.getStack().func_190916_E()) continue;
                hasAll = false;
                break;
            }
            if (!hasAll) continue;
            for (StackListEntry<ItemStack> need : c.getToExtract().getStacks()) {
                result = this.internalStorage.extract(need.getStack(), need.getStack().func_190916_E(), 1, Action.PERFORM);
                if (result.func_190916_E() == need.getStack().func_190916_E()) continue;
                throw new IllegalStateException("Extractor check lied");
            }
            ItemStack output = c.getPattern().getOutput(c.getTook());
            if (!c.isRoot()) {
                this.internalStorage.insert(output, output.func_190916_E(), Action.PERFORM);
            } else {
                ItemStack remainder = this.network.insertItem(output, output.func_190916_E(), Action.PERFORM);
                this.internalStorage.insert(remainder, remainder.func_190916_E(), Action.PERFORM);
            }
            for (ItemStack byp : c.getPattern().getByproducts(c.getTook())) {
                this.internalStorage.insert(byp, byp.func_190916_E(), Action.PERFORM);
            }
            it.remove();
            this.network.getCraftingManager().onTaskChanged();
            counter.merge(container, 1, (a, b) -> a + b);
        }
    }

    private void updateProcessing() {
        Iterator<Processing> it = this.processing.iterator();
        HashMap counter = Maps.newHashMap();
        while (it.hasNext()) {
            Processing p = it.next();
            ICraftingPatternContainer container = p.getPattern().getContainer();
            if (p.getState() == ProcessingState.PROCESSED) {
                it.remove();
                this.network.getCraftingManager().onTaskChanged();
                continue;
            }
            if (p.getState() == ProcessingState.EXTRACTED_ALL) continue;
            int interval = p.getPattern().getContainer().getUpdateInterval();
            if (interval < 0) {
                throw new IllegalStateException(p.getPattern().getContainer() + " has an update interval of < 0");
            }
            if (interval != 0 && this.ticks % interval != 0 || counter.getOrDefault(container, 0).intValue() == container.getMaximumSuccessfulCraftingUpdates()) continue;
            ProcessingState originalState = p.getState();
            if (p.getPattern().getContainer().isLocked()) {
                p.setState(ProcessingState.LOCKED);
            } else {
                boolean hasAll = true;
                for (StackListEntry<ItemStack> stackListEntry : p.getItemsToPut().getStacks()) {
                    if (p.getPattern().getContainer().getConnectedInventory() == null) {
                        p.setState(ProcessingState.MACHINE_NONE);
                        continue;
                    }
                    ItemStack itemStack = this.internalStorage.extract(stackListEntry.getStack(), stackListEntry.getStack().func_190916_E(), 1, Action.SIMULATE);
                    if (itemStack.func_190916_E() != stackListEntry.getStack().func_190916_E()) {
                        hasAll = false;
                        break;
                    }
                    p.setState(ProcessingState.READY);
                }
                if (hasAll && p.getState() == ProcessingState.READY && !CraftingTask.insertIntoInventory(p.getPattern().getContainer().getConnectedInventory(), new ArrayDeque<StackListEntry<ItemStack>>(p.getItemsToPut().getStacks()), Action.SIMULATE)) {
                    p.setState(ProcessingState.MACHINE_DOES_NOT_ACCEPT);
                }
                for (StackListEntry<ItemStack> stackListEntry : p.getFluidsToPut().getStacks()) {
                    if (p.getPattern().getContainer().getConnectedFluidInventory() == null) {
                        p.setState(ProcessingState.MACHINE_NONE);
                        continue;
                    }
                    FluidStack fluidStack = this.internalFluidStorage.extract((FluidStack)stackListEntry.getStack(), ((FluidStack)stackListEntry.getStack()).getAmount(), 1, Action.SIMULATE);
                    if (fluidStack.getAmount() != ((FluidStack)stackListEntry.getStack()).getAmount()) {
                        hasAll = false;
                        break;
                    }
                    if (p.getPattern().getContainer().getConnectedFluidInventory().fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) != fluidStack.getAmount()) {
                        p.setState(ProcessingState.MACHINE_DOES_NOT_ACCEPT);
                        break;
                    }
                    if (p.getState() != ProcessingState.READY && !p.getItemsToPut().isEmpty()) continue;
                    p.setState(ProcessingState.READY);
                }
                if (p.getState() == ProcessingState.READY && hasAll) {
                    ArrayDeque<StackListEntry<ItemStack>> toInsert = new ArrayDeque<StackListEntry<ItemStack>>();
                    for (StackListEntry<ItemStack> stackListEntry : p.getItemsToPut().getStacks()) {
                        ItemStack result2 = this.internalStorage.extract(stackListEntry.getStack(), stackListEntry.getStack().func_190916_E(), 1, Action.PERFORM);
                        if (result2.func_190916_E() != stackListEntry.getStack().func_190916_E()) {
                            throw new IllegalStateException("The internal crafting inventory reported that " + stackListEntry.getStack() + " was available but we got " + result2);
                        }
                        toInsert.add(stackListEntry);
                    }
                    if (!CraftingTask.insertIntoInventory(p.getPattern().getContainer().getConnectedInventory(), toInsert, Action.PERFORM)) {
                        LOGGER.warn(p.getPattern().getContainer().getConnectedInventory() + " unexpectedly didn't accept items, the remainder has been voided!");
                    }
                    for (StackListEntry<FluidStack> stackListEntry : p.getFluidsToPut().getStacks()) {
                        FluidStack result = this.internalFluidStorage.extract(stackListEntry.getStack(), stackListEntry.getStack().getAmount(), 1, Action.PERFORM);
                        if (result.getAmount() != stackListEntry.getStack().getAmount()) {
                            throw new IllegalStateException("The internal crafting inventory reported that " + stackListEntry + " was available but we got " + result);
                        }
                        int filled = p.getPattern().getContainer().getConnectedFluidInventory().fill(result, IFluidHandler.FluidAction.EXECUTE);
                        if (filled == result.getAmount()) continue;
                        LOGGER.warn(p.getPattern().getContainer().getConnectedFluidInventory() + " unexpectedly didn't accept fluids, the remainder has been voided!");
                    }
                    p.setState(ProcessingState.EXTRACTED_ALL);
                    p.getPattern().getContainer().onUsedForProcessing();
                    counter.merge(container, 1, (a, b) -> a + b);
                }
            }
            if (originalState == p.getState()) continue;
            this.network.getCraftingManager().onTaskChanged();
        }
    }

    private static boolean insertIntoInventory(@Nullable IItemHandler dest, Deque<StackListEntry<ItemStack>> stacks, Action action) {
        if (dest == null) {
            return false;
        }
        StackListEntry<ItemStack> currentEntry = stacks.poll();
        ItemStack current = currentEntry != null ? currentEntry.getStack() : null;
        List availableSlots = IntStream.range(0, dest.getSlots()).boxed().collect(Collectors.toList());
        while (current != null && !availableSlots.isEmpty()) {
            ItemStack remainder = ItemStack.field_190927_a;
            for (int i = 0; i < availableSlots.size(); ++i) {
                int slot = (Integer)availableSlots.get(i);
                remainder = dest.insertItem(slot, current.func_77946_l(), action == Action.SIMULATE);
                if (!remainder.func_190926_b() && current.func_190916_E() == remainder.func_190916_E()) continue;
                availableSlots.remove(i);
                break;
            }
            if (remainder.func_190926_b()) {
                currentEntry = stacks.poll();
                current = currentEntry != null ? currentEntry.getStack() : null;
                continue;
            }
            if (current.func_190916_E() == remainder.func_190916_E()) break;
            current = remainder;
        }
        return current == null && stacks.isEmpty();
    }

    @Override
    public int getCompletionPercentage() {
        if (this.totalSteps == 0) {
            return 0;
        }
        return 100 - (int)((float)(this.crafting.size() + this.processing.size()) / (float)this.totalSteps * 100.0f);
    }

    @Override
    public boolean update() {
        if (this.hasMissing()) {
            LOGGER.warn("Crafting task with missing items or fluids cannot execute, cancelling...");
            return true;
        }
        if (this.executionStarted == -1L) {
            this.executionStarted = System.currentTimeMillis();
            this.totalSteps = this.crafting.size() + this.processing.size();
        }
        ++this.ticks;
        this.extractInitial();
        if (this.crafting.isEmpty() && this.processing.isEmpty()) {
            ItemStack remainder;
            ArrayList<Runnable> toPerform = new ArrayList<Runnable>();
            for (ItemStack stack : this.internalStorage.getStacks()) {
                remainder = this.network.insertItem(stack, stack.func_190916_E(), Action.PERFORM);
                toPerform.add(() -> this.internalStorage.extract(stack, stack.func_190916_E() - remainder.func_190916_E(), 1, Action.PERFORM));
            }
            for (ItemStack stack : this.internalFluidStorage.getStacks()) {
                remainder = this.network.insertFluid((FluidStack)stack, stack.getAmount(), Action.PERFORM);
                toPerform.add(() -> this.lambda$update$3((FluidStack)stack, (FluidStack)remainder));
            }
            toPerform.forEach(Runnable::run);
            return this.internalStorage.getStacks().isEmpty() && this.internalFluidStorage.getStacks().isEmpty();
        }
        this.updateCrafting();
        this.updateProcessing();
        return false;
    }

    @Override
    public void onCancelled() {
        for (ItemStack remainder : this.internalStorage.getStacks()) {
            this.network.insertItem(remainder, remainder.func_190916_E(), Action.PERFORM);
        }
        for (ItemStack remainder : this.internalFluidStorage.getStacks()) {
            this.network.insertFluid((FluidStack)remainder, remainder.getAmount(), Action.PERFORM);
        }
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    public int getQuantityPerCraft() {
        int qty = 0;
        if (this.requested.getItem() != null) {
            for (ItemStack output : this.pattern.getOutputs()) {
                if (!API.instance().getComparer().isEqualNoQuantity(output, this.requested.getItem())) continue;
                qty += output.func_190916_E();
                if (this.pattern.isProcessing()) continue;
                break;
            }
        } else {
            for (FluidStack output : this.pattern.getFluidOutputs()) {
                if (!API.instance().getComparer().isEqual(output, this.requested.getFluid(), 1)) continue;
                qty += output.getAmount();
            }
        }
        return qty;
    }

    @Override
    public ICraftingRequestInfo getRequested() {
        return this.requested;
    }

    @Override
    public int onTrackedInsert(ItemStack stack, int size) {
        for (Processing p : this.processing) {
            ItemStack content;
            if (p.getState() != ProcessingState.EXTRACTED_ALL || (content = p.getItemsToReceive().get(stack)) == null) continue;
            int needed = content.func_190916_E();
            if (needed > size) {
                needed = size;
            }
            p.getItemsToReceive().remove(stack, needed);
            size -= needed;
            if (p.getItemsToReceive().isEmpty() && p.getFluidsToReceive().isEmpty()) {
                p.setState(ProcessingState.PROCESSED);
            }
            if (!p.isRoot()) {
                this.internalStorage.insert(stack, needed, Action.PERFORM);
            } else {
                ItemStack remainder = this.network.insertItem(stack, needed, Action.PERFORM);
                this.internalStorage.insert(remainder, remainder.func_190916_E(), Action.PERFORM);
            }
            if (size != 0) continue;
            return 0;
        }
        return size;
    }

    @Override
    public int onTrackedInsert(FluidStack stack, int size) {
        for (Processing p : this.processing) {
            FluidStack content;
            if (p.getState() != ProcessingState.EXTRACTED_ALL || (content = p.getFluidsToReceive().get(stack)) == null) continue;
            int needed = content.getAmount();
            if (needed > size) {
                needed = size;
            }
            p.getFluidsToReceive().remove(stack, needed);
            size -= needed;
            if (p.getItemsToReceive().isEmpty() && p.getFluidsToReceive().isEmpty()) {
                p.setState(ProcessingState.PROCESSED);
            }
            if (!p.isRoot()) {
                this.internalFluidStorage.insert(stack, needed, Action.PERFORM);
            } else {
                FluidStack remainder = this.network.insertFluid(stack, needed, Action.PERFORM);
                this.internalFluidStorage.insert(remainder, remainder.getAmount(), Action.PERFORM);
            }
            if (size != 0) continue;
            return 0;
        }
        return size;
    }

    static CompoundNBT writePatternToNbt(ICraftingPattern pattern) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a(NBT_PATTERN_STACK, (INBT)pattern.getStack().serializeNBT());
        tag.func_74772_a(NBT_PATTERN_CONTAINER_POS, pattern.getContainer().getPosition().func_218275_a());
        return tag;
    }

    static ICraftingPattern readPatternFromNbt(CompoundNBT tag, World world) throws CraftingTaskReadException {
        BlockPos containerPos = BlockPos.func_218283_e((long)tag.func_74763_f(NBT_PATTERN_CONTAINER_POS));
        INetworkNode node = API.instance().getNetworkNodeManager((ServerWorld)world).getNode(containerPos);
        if (node instanceof ICraftingPatternContainer) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(NBT_PATTERN_STACK));
            if (stack.func_77973_b() instanceof ICraftingPatternProvider) {
                return ((ICraftingPatternProvider)stack.func_77973_b()).create(world, stack, (ICraftingPatternContainer)((Object)node));
            }
            throw new CraftingTaskReadException("Pattern stack is not a crafting pattern provider");
        }
        throw new CraftingTaskReadException("Crafting pattern container doesn't exist anymore");
    }

    @Override
    public List<ICraftingMonitorElement> getCraftingMonitorElements() {
        ICraftingMonitorElement element;
        ICraftingMonitorElementList elements = API.instance().createCraftingMonitorElementList();
        for (ItemStack itemStack : this.internalStorage.getStacks()) {
            elements.add(new ItemCraftingMonitorElement(itemStack, itemStack.func_190916_E(), 0, 0, 0, 0));
        }
        for (StackListEntry stackListEntry : this.missing.getStacks()) {
            elements.add(new ItemCraftingMonitorElement((ItemStack)stackListEntry.getStack(), 0, ((ItemStack)stackListEntry.getStack()).func_190916_E(), 0, 0, 0));
        }
        for (Crafting crafting : this.crafting) {
            for (Object receive : crafting.getPattern().getOutputs()) {
                elements.add(new ItemCraftingMonitorElement((ItemStack)receive, 0, 0, 0, 0, receive.func_190916_E()));
            }
        }
        for (Processing processing : this.processing) {
            if (processing.getState() == ProcessingState.PROCESSED) continue;
            if (processing.getState() == ProcessingState.EXTRACTED_ALL) {
                for (StackListEntry<ItemStack> put : processing.getItemsToPut().getStacks()) {
                    elements.add(new ItemCraftingMonitorElement(put.getStack(), 0, 0, put.getStack().func_190916_E(), 0, 0));
                }
                continue;
            }
            if (processing.getState() != ProcessingState.READY && processing.getState() != ProcessingState.MACHINE_DOES_NOT_ACCEPT && processing.getState() != ProcessingState.MACHINE_NONE && processing.getState() != ProcessingState.LOCKED) continue;
            for (Object receive : processing.getItemsToReceive().getStacks()) {
                element = new ItemCraftingMonitorElement((ItemStack)((StackListEntry)receive).getStack(), 0, 0, 0, ((ItemStack)((StackListEntry)receive).getStack()).func_190916_E(), 0);
                if (processing.getState() == ProcessingState.MACHINE_DOES_NOT_ACCEPT) {
                    element = new ErrorCraftingMonitorElement(element, "gui.refinedstorage.crafting_monitor.machine_does_not_accept_item");
                } else if (processing.getState() == ProcessingState.MACHINE_NONE) {
                    element = new ErrorCraftingMonitorElement(element, "gui.refinedstorage.crafting_monitor.machine_none");
                } else if (processing.getState() == ProcessingState.LOCKED) {
                    element = new ErrorCraftingMonitorElement(element, "gui.refinedstorage.crafting_monitor.crafter_is_locked");
                }
                elements.add(element);
            }
        }
        elements.commit();
        for (FluidStack fluidStack : this.internalFluidStorage.getStacks()) {
            elements.add(new FluidCraftingMonitorElement(fluidStack, fluidStack.getAmount(), 0, 0, 0, 0));
        }
        for (StackListEntry stackListEntry : this.missingFluids.getStacks()) {
            elements.add(new FluidCraftingMonitorElement((FluidStack)stackListEntry.getStack(), 0, ((FluidStack)stackListEntry.getStack()).getAmount(), 0, 0, 0));
        }
        for (Processing processing : this.processing) {
            if (processing.getState() == ProcessingState.PROCESSED) continue;
            if (processing.getState() == ProcessingState.EXTRACTED_ALL) {
                for (StackListEntry<ItemStack> put : processing.getFluidsToPut().getStacks()) {
                    elements.add(new FluidCraftingMonitorElement((FluidStack)put.getStack(), 0, 0, ((FluidStack)put.getStack()).getAmount(), 0, 0));
                }
                continue;
            }
            if (processing.getState() != ProcessingState.READY && processing.getState() != ProcessingState.MACHINE_DOES_NOT_ACCEPT && processing.getState() != ProcessingState.MACHINE_NONE) continue;
            for (Object receive : processing.getFluidsToReceive().getStacks()) {
                element = new FluidCraftingMonitorElement((FluidStack)((StackListEntry)receive).getStack(), 0, 0, 0, ((FluidStack)((StackListEntry)receive).getStack()).getAmount(), 0);
                if (processing.getState() == ProcessingState.MACHINE_DOES_NOT_ACCEPT) {
                    element = new ErrorCraftingMonitorElement(element, "gui.refinedstorage.crafting_monitor.machine_does_not_accept_fluid");
                } else if (processing.getState() == ProcessingState.MACHINE_NONE) {
                    element = new ErrorCraftingMonitorElement(element, "gui.refinedstorage.crafting_monitor.machine_none");
                } else if (processing.getState() == ProcessingState.LOCKED) {
                    element = new ErrorCraftingMonitorElement(element, "gui.refinedstorage.crafting_monitor.crafter_is_locked");
                }
                elements.add(element);
            }
        }
        elements.commit();
        return elements.getElements();
    }

    @Override
    public List<ICraftingPreviewElement> getPreviewStacks() {
        ICraftingPreviewElement<ItemStack> previewStack;
        int hash;
        LinkedHashMap<Integer, ICraftingPreviewElement<ItemStack>> map = new LinkedHashMap<Integer, ICraftingPreviewElement<ItemStack>>();
        LinkedHashMap<Integer, ICraftingPreviewElement<ItemStack>> mapFluids = new LinkedHashMap<Integer, ICraftingPreviewElement<ItemStack>>();
        for (StackListEntry<ItemStack> stackListEntry : this.toCraft.getStacks()) {
            hash = API.instance().getItemStackHashCode(stackListEntry.getStack());
            previewStack = (ItemCraftingPreviewElement)map.get(hash);
            if (previewStack == null) {
                previewStack = new ItemCraftingPreviewElement(stackListEntry.getStack());
            }
            ((ItemCraftingPreviewElement)previewStack).addToCraft(stackListEntry.getStack().func_190916_E());
            map.put(hash, previewStack);
        }
        for (StackListEntry<ItemStack> stackListEntry : this.toCraftFluids.getStacks()) {
            hash = API.instance().getFluidStackHashCode((FluidStack)stackListEntry.getStack());
            previewStack = (FluidCraftingPreviewElement)mapFluids.get(hash);
            if (previewStack == null) {
                previewStack = new FluidCraftingPreviewElement((FluidStack)stackListEntry.getStack());
            }
            ((FluidCraftingPreviewElement)previewStack).addToCraft(((FluidStack)stackListEntry.getStack()).getAmount());
            mapFluids.put(hash, previewStack);
        }
        for (StackListEntry<ItemStack> stackListEntry : this.missing.getStacks()) {
            hash = API.instance().getItemStackHashCode(stackListEntry.getStack());
            previewStack = (ItemCraftingPreviewElement)map.get(hash);
            if (previewStack == null) {
                previewStack = new ItemCraftingPreviewElement(stackListEntry.getStack());
            }
            ((ItemCraftingPreviewElement)previewStack).setMissing(true);
            ((ItemCraftingPreviewElement)previewStack).addToCraft(stackListEntry.getStack().func_190916_E());
            map.put(hash, previewStack);
        }
        for (StackListEntry<ItemStack> stackListEntry : this.missingFluids.getStacks()) {
            hash = API.instance().getFluidStackHashCode((FluidStack)stackListEntry.getStack());
            previewStack = (FluidCraftingPreviewElement)mapFluids.get(hash);
            if (previewStack == null) {
                previewStack = new FluidCraftingPreviewElement((FluidStack)stackListEntry.getStack());
            }
            ((FluidCraftingPreviewElement)previewStack).setMissing(true);
            ((FluidCraftingPreviewElement)previewStack).addToCraft(((FluidStack)stackListEntry.getStack()).getAmount());
            mapFluids.put(hash, previewStack);
        }
        for (StackListEntry<ItemStack> stackListEntry : this.toTake.getStacks()) {
            hash = API.instance().getItemStackHashCode(stackListEntry.getStack());
            previewStack = (ItemCraftingPreviewElement)map.get(hash);
            if (previewStack == null) {
                previewStack = new ItemCraftingPreviewElement(stackListEntry.getStack());
            }
            ((ItemCraftingPreviewElement)previewStack).addAvailable(stackListEntry.getStack().func_190916_E());
            map.put(hash, previewStack);
        }
        for (StackListEntry<ItemStack> stackListEntry : this.toTakeFluids.getStacks()) {
            hash = API.instance().getFluidStackHashCode((FluidStack)stackListEntry.getStack());
            previewStack = (FluidCraftingPreviewElement)mapFluids.get(hash);
            if (previewStack == null) {
                previewStack = new FluidCraftingPreviewElement((FluidStack)stackListEntry.getStack());
            }
            ((FluidCraftingPreviewElement)previewStack).addAvailable(((FluidStack)stackListEntry.getStack()).getAmount());
            mapFluids.put(hash, previewStack);
        }
        ArrayList<ICraftingPreviewElement> elements = new ArrayList<ICraftingPreviewElement>();
        elements.addAll(map.values());
        elements.addAll(mapFluids.values());
        return elements;
    }

    @Override
    public ICraftingPattern getPattern() {
        return this.pattern;
    }

    @Override
    public long getExecutionStarted() {
        return this.executionStarted;
    }

    @Override
    public IStackList<ItemStack> getMissing() {
        return this.missing;
    }

    @Override
    public IStackList<FluidStack> getMissingFluids() {
        return this.missingFluids;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    private /* synthetic */ void lambda$update$3(FluidStack stack, FluidStack remainder) {
        this.internalFluidStorage.extract(stack, stack.getAmount() - remainder.getAmount(), 1, Action.PERFORM);
    }

    static class PossibleFluidInputs {
        private List<FluidStack> possibilities;
        private int pos;

        PossibleFluidInputs(List<FluidStack> possibilities) {
            this.possibilities = possibilities;
        }

        FluidStack get() {
            return this.possibilities.get(this.pos);
        }

        boolean cycle() {
            if (this.pos + 1 >= this.possibilities.size()) {
                this.pos = 0;
                return false;
            }
            ++this.pos;
            return true;
        }

        void sort(IStackList<FluidStack> mutatedStorage, IStackList<FluidStack> results) {
            this.possibilities.sort((a, b) -> {
                FluidStack ar = mutatedStorage.get((FluidStack)a);
                FluidStack br = mutatedStorage.get((FluidStack)b);
                return (br == null ? 0 : br.getAmount()) - (ar == null ? 0 : ar.getAmount());
            });
            this.possibilities.sort((a, b) -> {
                FluidStack ar = results.get((FluidStack)a);
                FluidStack br = results.get((FluidStack)b);
                return (br == null ? 0 : br.getAmount()) - (ar == null ? 0 : ar.getAmount());
            });
        }
    }

    static class PossibleInputs {
        private List<ItemStack> possibilities;
        private int pos;

        PossibleInputs(List<ItemStack> possibilities) {
            this.possibilities = possibilities;
        }

        ItemStack get() {
            return this.possibilities.get(this.pos);
        }

        boolean cycle() {
            if (this.pos + 1 >= this.possibilities.size()) {
                this.pos = 0;
                return false;
            }
            ++this.pos;
            return true;
        }

        void sort(IStackList<ItemStack> mutatedStorage, IStackList<ItemStack> results) {
            this.possibilities.sort((a, b) -> {
                ItemStack ar = mutatedStorage.get((ItemStack)a);
                ItemStack br = mutatedStorage.get((ItemStack)b);
                return (br == null ? 0 : br.func_190916_E()) - (ar == null ? 0 : ar.func_190916_E());
            });
            this.possibilities.sort((a, b) -> {
                ItemStack ar = results.get((ItemStack)a);
                ItemStack br = results.get((ItemStack)b);
                return (br == null ? 0 : br.func_190916_E()) - (ar == null ? 0 : ar.func_190916_E());
            });
        }
    }
}

