/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;

public class AllowedTagList {
    private static final String NBT_ALLOWED_ITEM_TAGS = "AllowedItemTags";
    private static final String NBT_ALLOWED_FLUID_TAGS = "AllowedFluidTags";
    private List<Set<ResourceLocation>> allowedItemTags = new ArrayList<Set<ResourceLocation>>();
    private List<Set<ResourceLocation>> allowedFluidTags = new ArrayList<Set<ResourceLocation>>();
    @Nullable
    private final Runnable listener;

    public AllowedTagList(@Nullable Runnable listener) {
        for (int i = 0; i < 9; ++i) {
            this.allowedItemTags.add(new HashSet());
            this.allowedFluidTags.add(new HashSet());
        }
        this.listener = listener;
    }

    public CompoundNBT writeToNbt() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a(NBT_ALLOWED_ITEM_TAGS, (INBT)this.getList(this.allowedItemTags));
        tag.func_218657_a(NBT_ALLOWED_FLUID_TAGS, (INBT)this.getList(this.allowedFluidTags));
        return tag;
    }

    public void readFromNbt(CompoundNBT tag) {
        if (tag.func_74764_b(NBT_ALLOWED_ITEM_TAGS)) {
            this.applyList(this.allowedItemTags, tag.func_150295_c(NBT_ALLOWED_ITEM_TAGS, 9));
        }
        if (tag.func_74764_b(NBT_ALLOWED_FLUID_TAGS)) {
            this.applyList(this.allowedFluidTags, tag.func_150295_c(NBT_ALLOWED_FLUID_TAGS, 9));
        }
    }

    private ListNBT getList(List<Set<ResourceLocation>> tagsPerSlot) {
        ListNBT list = new ListNBT();
        for (Set<ResourceLocation> tags : tagsPerSlot) {
            ListNBT subList = new ListNBT();
            tags.forEach(t -> subList.add((Object)StringNBT.func_229705_a_((String)t.toString())));
            list.add((Object)subList);
        }
        return list;
    }

    private void applyList(List<Set<ResourceLocation>> list, ListNBT tagList) {
        for (int i = 0; i < tagList.size(); ++i) {
            ListNBT subList = tagList.func_202169_e(i);
            for (int j = 0; j < subList.size(); ++j) {
                list.get(i).add(new ResourceLocation(subList.func_150307_f(j)));
            }
        }
    }

    public List<Set<ResourceLocation>> getAllowedItemTags() {
        return this.allowedItemTags;
    }

    public List<Set<ResourceLocation>> getAllowedFluidTags() {
        return this.allowedFluidTags;
    }

    public void setAllowedItemTags(List<Set<ResourceLocation>> allowedItemTags) {
        this.allowedItemTags = allowedItemTags;
        this.notifyListener();
    }

    public void setAllowedFluidTags(List<Set<ResourceLocation>> allowedFluidTags) {
        this.allowedFluidTags = allowedFluidTags;
        this.notifyListener();
    }

    public void clearItemTags(int slot) {
        this.allowedItemTags.get(slot).clear();
        this.notifyListener();
    }

    public void clearFluidTags(int slot) {
        this.allowedFluidTags.get(slot).clear();
        this.notifyListener();
    }

    private void notifyListener() {
        if (this.listener != null) {
            this.listener.run();
        }
    }
}

