/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl;

import com.raoulvdberge.refinedstorage.api.IRSAPI;
import com.raoulvdberge.refinedstorage.api.RSAPIInject;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternRenderHandler;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElementList;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElementRegistry;
import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElementRegistry;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingRequestInfo;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTaskRegistry;
import com.raoulvdberge.refinedstorage.api.network.INetworkManager;
import com.raoulvdberge.refinedstorage.api.network.grid.ICraftingGridBehavior;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridManager;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeManager;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeRegistry;
import com.raoulvdberge.refinedstorage.api.storage.StorageType;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskManager;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskRegistry;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskSync;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IExternalStorageProvider;
import com.raoulvdberge.refinedstorage.api.util.IComparer;
import com.raoulvdberge.refinedstorage.api.util.IQuantityFormatter;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementList;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementRegistry;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementRegistry;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingRequestInfo;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingTaskRegistry;
import com.raoulvdberge.refinedstorage.apiimpl.network.NetworkManager;
import com.raoulvdberge.refinedstorage.apiimpl.network.NetworkNodeManager;
import com.raoulvdberge.refinedstorage.apiimpl.network.NetworkNodeRegistry;
import com.raoulvdberge.refinedstorage.apiimpl.network.grid.CraftingGridBehavior;
import com.raoulvdberge.refinedstorage.apiimpl.network.grid.GridManager;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.FluidStorageDisk;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.ItemStorageDisk;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.StorageDiskManager;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.StorageDiskRegistry;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.StorageDiskSync;
import com.raoulvdberge.refinedstorage.apiimpl.util.Comparer;
import com.raoulvdberge.refinedstorage.apiimpl.util.FluidStackList;
import com.raoulvdberge.refinedstorage.apiimpl.util.ItemStackList;
import com.raoulvdberge.refinedstorage.apiimpl.util.QuantityFormatter;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class API
implements IRSAPI {
    private static final Logger LOGGER = LogManager.getLogger(API.class);
    private static final IRSAPI INSTANCE = new API();
    private final IComparer comparer = new Comparer();
    private final IQuantityFormatter quantityFormatter = new QuantityFormatter();
    private final INetworkNodeRegistry networkNodeRegistry = new NetworkNodeRegistry();
    private final ICraftingTaskRegistry craftingTaskRegistry = new CraftingTaskRegistry();
    private final ICraftingMonitorElementRegistry craftingMonitorElementRegistry = new CraftingMonitorElementRegistry();
    private final ICraftingPreviewElementRegistry craftingPreviewElementRegistry = new CraftingPreviewElementRegistry();
    private final IGridManager gridManager = new GridManager();
    private final ICraftingGridBehavior craftingGridBehavior = new CraftingGridBehavior();
    private final IStorageDiskRegistry storageDiskRegistry = new StorageDiskRegistry();
    private final IStorageDiskSync storageDiskSync = new StorageDiskSync();
    private final Map<StorageType, TreeSet<IExternalStorageProvider>> externalStorageProviders = new HashMap<StorageType, TreeSet<IExternalStorageProvider>>();
    private final List<ICraftingPatternRenderHandler> patternRenderHandlers = new LinkedList<ICraftingPatternRenderHandler>();

    public static IRSAPI instance() {
        return INSTANCE;
    }

    public static void deliver() {
        Type annotationType = Type.getType(RSAPIInject.class);
        List annotations = ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> annotationType.equals((Object)a.getAnnotationType())).collect(Collectors.toList());
        LOGGER.info("Found {} RS API injection {}", (Object)annotations.size(), (Object)(annotations.size() == 1 ? "point" : "points"));
        for (ModFileScanData.AnnotationData annotation : annotations) {
            try {
                Class<?> clazz = Class.forName(annotation.getClassType().getClassName());
                Field field = clazz.getField(annotation.getMemberName());
                if (field.getType() == IRSAPI.class) {
                    field.set(null, INSTANCE);
                }
                LOGGER.info("Injected RS API in {} {}", (Object)annotation.getClassType().getClassName(), (Object)annotation.getMemberName());
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                LOGGER.error("Could not inject RS API in {} {}", (Object)annotation.getClassType().getClassName(), (Object)annotation.getMemberName(), (Object)e);
            }
        }
    }

    @Override
    @Nonnull
    public IComparer getComparer() {
        return this.comparer;
    }

    @Override
    @Nonnull
    public IQuantityFormatter getQuantityFormatter() {
        return this.quantityFormatter;
    }

    @Override
    @Nonnull
    public INetworkNodeRegistry getNetworkNodeRegistry() {
        return this.networkNodeRegistry;
    }

    @Override
    public INetworkNodeManager getNetworkNodeManager(ServerWorld world) {
        String name = world.func_201675_m().func_186058_p().getRegistryName().func_110624_b() + "_" + world.func_201675_m().func_186058_p().getRegistryName().func_110623_a() + "_" + "refinedstorage_nodes";
        return (INetworkNodeManager)world.func_217481_x().func_215752_a(() -> new NetworkNodeManager(name, (World)world), name);
    }

    @Override
    public INetworkManager getNetworkManager(ServerWorld world) {
        String name = world.func_201675_m().func_186058_p().getRegistryName().func_110624_b() + "_" + world.func_201675_m().func_186058_p().getRegistryName().func_110623_a() + "_" + "refinedstorage_networks";
        return (INetworkManager)world.func_217481_x().func_215752_a(() -> new NetworkManager(name, (World)world), name);
    }

    @Override
    @Nonnull
    public ICraftingTaskRegistry getCraftingTaskRegistry() {
        return this.craftingTaskRegistry;
    }

    @Override
    @Nonnull
    public ICraftingMonitorElementRegistry getCraftingMonitorElementRegistry() {
        return this.craftingMonitorElementRegistry;
    }

    @Override
    @Nonnull
    public ICraftingPreviewElementRegistry getCraftingPreviewElementRegistry() {
        return this.craftingPreviewElementRegistry;
    }

    @Override
    @Nonnull
    public IStackList<ItemStack> createItemStackList() {
        return new ItemStackList();
    }

    @Override
    @Nonnull
    public IStackList<FluidStack> createFluidStackList() {
        return new FluidStackList();
    }

    @Override
    @Nonnull
    public ICraftingMonitorElementList createCraftingMonitorElementList() {
        return new CraftingMonitorElementList();
    }

    @Override
    @Nonnull
    public IGridManager getGridManager() {
        return this.gridManager;
    }

    @Override
    @Nonnull
    public ICraftingGridBehavior getCraftingGridBehavior() {
        return this.craftingGridBehavior;
    }

    @Override
    @Nonnull
    public IStorageDiskRegistry getStorageDiskRegistry() {
        return this.storageDiskRegistry;
    }

    @Override
    @Nonnull
    public IStorageDiskManager getStorageDiskManager(ServerWorld anyWorld) {
        ServerWorld world = anyWorld.func_73046_m().func_71218_a(DimensionType.field_223227_a_);
        return (IStorageDiskManager)world.func_217481_x().func_215752_a(() -> new StorageDiskManager("refinedstorage_disks", world), "refinedstorage_disks");
    }

    @Override
    @Nonnull
    public IStorageDiskSync getStorageDiskSync() {
        return this.storageDiskSync;
    }

    @Override
    public void addExternalStorageProvider(StorageType type, IExternalStorageProvider provider) {
        this.externalStorageProviders.computeIfAbsent(type, k -> new TreeSet((a, b) -> Integer.compare(b.getPriority(), a.getPriority()))).add(provider);
    }

    @Override
    public Set<IExternalStorageProvider> getExternalStorageProviders(StorageType type) {
        TreeSet<IExternalStorageProvider> providers = this.externalStorageProviders.get((Object)type);
        return providers == null ? Collections.emptySet() : providers;
    }

    @Override
    @Nonnull
    public IStorageDisk<ItemStack> createDefaultItemDisk(ServerWorld world, int capacity) {
        if (world == null) {
            throw new IllegalArgumentException("World cannot be null");
        }
        return new ItemStorageDisk(world, capacity);
    }

    @Override
    @Nonnull
    public IStorageDisk<FluidStack> createDefaultFluidDisk(ServerWorld world, int capacity) {
        if (world == null) {
            throw new IllegalArgumentException("World cannot be null");
        }
        return new FluidStorageDisk(world, capacity);
    }

    @Override
    public ICraftingRequestInfo createCraftingRequestInfo(ItemStack stack) {
        return new CraftingRequestInfo(stack);
    }

    @Override
    public ICraftingRequestInfo createCraftingRequestInfo(FluidStack stack) {
        return new CraftingRequestInfo(stack);
    }

    @Override
    public ICraftingRequestInfo createCraftingRequestInfo(CompoundNBT tag) throws CraftingTaskReadException {
        return new CraftingRequestInfo(tag);
    }

    @Override
    public void addPatternRenderHandler(ICraftingPatternRenderHandler renderHandler) {
        this.patternRenderHandlers.add(renderHandler);
    }

    @Override
    public List<ICraftingPatternRenderHandler> getPatternRenderHandlers() {
        return this.patternRenderHandlers;
    }

    @Override
    public int getItemStackHashCode(ItemStack stack) {
        int result = stack.func_77973_b().hashCode();
        if (stack.func_77942_o()) {
            result = this.getHashCode(stack.func_77978_p(), result);
        }
        return result;
    }

    private int getHashCode(INBT tag, int result) {
        result = tag instanceof CompoundNBT ? this.getHashCode((CompoundNBT)tag, result) : (tag instanceof ListNBT ? this.getHashCode((ListNBT)tag, result) : 31 * result + tag.hashCode());
        return result;
    }

    private int getHashCode(CompoundNBT tag, int result) {
        for (String key : tag.func_150296_c()) {
            result = 31 * result + key.hashCode();
            result = this.getHashCode(tag.func_74781_a(key), result);
        }
        return result;
    }

    private int getHashCode(ListNBT tag, int result) {
        for (int i = 0; i < tag.size(); ++i) {
            result = this.getHashCode(tag.get(i), result);
        }
        return result;
    }

    @Override
    public int getFluidStackHashCode(FluidStack stack) {
        int result = stack.getFluid().hashCode();
        if (stack.getTag() != null) {
            result = this.getHashCode(stack.getTag(), result);
        }
        return result;
    }

    @Override
    public int getNetworkNodeHashCode(INetworkNode node) {
        int result = node.getPos().hashCode();
        result = 31 * result + node.getWorld().func_201675_m().func_186058_p().func_186068_a();
        return result;
    }

    @Override
    public boolean isNetworkNodeEqual(INetworkNode left, Object right) {
        if (!(right instanceof INetworkNode)) {
            return false;
        }
        if (left == right) {
            return true;
        }
        INetworkNode rightNode = (INetworkNode)right;
        if (left.getWorld().func_201675_m().func_186058_p().func_186068_a() != rightNode.getWorld().func_201675_m().func_186058_p().func_186068_a()) {
            return false;
        }
        return left.getPos().equals((Object)rightNode.getPos());
    }
}

