/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.recipe;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModRecipes;
import me.desht.modularrouters.item.module.IPickaxeUser;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.crafting.StackList;

public abstract class PickaxeModuleRecipe
extends ShapelessRecipe {
    PickaxeModuleRecipe(ResourceLocation resourceLocation, ItemStack result, NonNullList<Ingredient> ingredients) {
        super(resourceLocation, "", result, ingredients);
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        if (!super.func_77569_a(inv, worldIn)) {
            return false;
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!stack.func_77973_b().getToolTypes(stack).contains(ToolType.PICKAXE) && !(stack.func_77973_b() instanceof IPickaxeUser)) continue;
            return true;
        }
        return false;
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        ItemStack pick = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b().getToolTypes(stack).contains(ToolType.PICKAXE)) {
                pick = inv.func_70301_a(i);
                break;
            }
            if (!(stack.func_77973_b() instanceof IPickaxeUser)) continue;
            pick = ((IPickaxeUser)stack.func_77973_b()).getPickaxe(stack);
            break;
        }
        if (!pick.func_190926_b()) {
            ItemStack result = super.func_77572_b(inv);
            return ((IPickaxeUser)result.func_77973_b()).setPickaxe(result, pick);
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    private static class PickaxeIngredient
    extends Ingredient {
        PickaxeIngredient() {
            super(Stream.of(new StackList((Collection)ImmutableList.of((Object)new ItemStack((IItemProvider)Items.field_151039_o), (Object)new ItemStack((IItemProvider)Items.field_151050_s), (Object)new ItemStack((IItemProvider)Items.field_151035_b), (Object)new ItemStack((IItemProvider)Items.field_151046_w)))));
        }

        public boolean test(@Nullable ItemStack stack) {
            return stack != null && stack.func_77973_b().getToolTypes(stack).contains(ToolType.PICKAXE) && stack.func_77952_i() == 0;
        }
    }

    public static class ExtruderModule1Recipe
    extends PickaxeModuleRecipe {
        public ExtruderModule1Recipe(ResourceLocation resourceLocation) {
            super(resourceLocation, new ItemStack((IItemProvider)ModItems.EXTRUDER_MODULE_1.get()), ExtruderModule1Recipe.ingredients());
        }

        private static NonNullList<Ingredient> ingredients() {
            return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.BLANK_MODULE.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.PLACER_MODULE.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.BREAKER_MODULE.get()})});
        }

        public IRecipeSerializer<?> func_199559_b() {
            return (IRecipeSerializer)ModRecipes.EXTRUDER_MODULE_1.get();
        }
    }

    public static class BreakerModuleRecipe
    extends PickaxeModuleRecipe {
        public BreakerModuleRecipe(ResourceLocation resourceLocation) {
            super(resourceLocation, new ItemStack((IItemProvider)ModItems.BREAKER_MODULE.get()), BreakerModuleRecipe.ingredients());
        }

        private static NonNullList<Ingredient> ingredients() {
            return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.BLANK_MODULE.get()}), new PickaxeIngredient()});
        }

        public IRecipeSerializer<?> func_199559_b() {
            return (IRecipeSerializer)ModRecipes.BREAKER_MODULE.get();
        }
    }
}

