/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.client.gui.filter.GuiModFilter;
import me.desht.modularrouters.container.ContainerModFilter;
import me.desht.modularrouters.container.ContainerSmartFilter;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.ModMatcher;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.GuiSyncMessage;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.ModNameCache;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModFilter
extends ItemSmartFilter {
    private static final String NBT_MODS = "Mods";
    public static final int MAX_SIZE = 6;

    @Override
    public IItemMatcher compile(ItemStack filterStack, ItemStack moduleStack) {
        return new ModMatcher(ModFilter.getModList(filterStack));
    }

    public static List<String> getModList(ItemStack filterStack) {
        CompoundNBT tag = filterStack.func_179543_a("modularrouters");
        if (tag != null) {
            ListNBT items = tag.func_150295_c(NBT_MODS, 8);
            ArrayList res = Lists.newArrayListWithExpectedSize((int)items.size());
            for (int i = 0; i < items.size(); ++i) {
                res.add(items.func_150307_f(i));
            }
            return res;
        }
        return Lists.newArrayList();
    }

    private static void setModList(ItemStack filterStack, List<String> mods) {
        ListNBT list = mods.stream().map(StringNBT::func_229705_a_).collect(Collectors.toCollection(ListNBT::new));
        filterStack.func_190925_c("modularrouters").func_218657_a(NBT_MODS, (INBT)list);
    }

    @Override
    public void addExtraInformation(ItemStack stack, List<ITextComponent> list) {
        super.addExtraInformation(stack, list);
        if (stack.func_179543_a("modularrouters") != null) {
            List<String> l = ModFilter.getModList(stack);
            list.add((ITextComponent)new TranslationTextComponent("itemText.misc.modFilter.count", new Object[]{l.size()}));
            list.addAll(l.stream().map(ModNameCache::getModName).map(s -> " \u2022 " + TextFormatting.AQUA + s).map(StringTextComponent::new).collect(Collectors.toList()));
        } else {
            list.add((ITextComponent)new TranslationTextComponent("itemText.misc.modFilter.count", new Object[]{0}));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Class<? extends Screen> getGuiClass() {
        return GuiModFilter.class;
    }

    @Override
    public boolean hasContainer() {
        return true;
    }

    @Override
    public ContainerSmartFilter createContainer(int windowId, PlayerInventory invPlayer, MFLocator loc) {
        return new ContainerModFilter(windowId, invPlayer, loc);
    }

    @Override
    public GuiSyncMessage onReceiveSettingsMessage(PlayerEntity player, FilterSettingsMessage message, ItemStack filterStack, ItemStack moduleStack) {
        switch (message.getOp()) {
            case ADD_STRING: {
                String modId = message.getPayload().func_74779_i("ModId");
                List<String> l = ModFilter.getModList(filterStack);
                if (l.size() >= 6 || l.contains(modId)) break;
                l.add(modId);
                ModFilter.setModList(filterStack, l);
                return new GuiSyncMessage(filterStack);
            }
            case REMOVE_AT: {
                int pos = message.getPayload().func_74762_e("Pos");
                List<String> l = ModFilter.getModList(filterStack);
                if (pos < 0 || pos >= l.size()) break;
                l.remove(pos);
                ModFilter.setModList(filterStack, l);
                return new GuiSyncMessage(filterStack);
            }
            default: {
                ModularRouters.LOGGER.warn("received unexpected message type " + (Object)((Object)message.getOp()) + " for " + filterStack);
            }
        }
        return null;
    }

    @Override
    public int getSize(ItemStack filterStack) {
        CompoundNBT tag = filterStack.func_179543_a("modularrouters");
        return tag != null ? tag.func_150295_c(NBT_MODS, 8).size() : 0;
    }
}

