/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.modularrouters.client.gui.filter.GuiInspectionFilter;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.InspectionMatcher;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.GuiSyncMessage;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class InspectionFilter
extends ItemSmartFilter {
    private static final String NBT_MATCH_ALL = "MatchAll";
    private static final String NBT_ITEMS = "Items";
    public static final int MAX_SIZE = 6;

    @Override
    public IItemMatcher compile(ItemStack filterStack, ItemStack moduleStack) {
        return new InspectionMatcher(InspectionFilter.getComparisonList(filterStack));
    }

    @Override
    public void addExtraInformation(ItemStack itemstack, List<ITextComponent> list) {
        super.addExtraInformation(itemstack, list);
        InspectionMatcher.ComparisonList comparisonList = InspectionFilter.getComparisonList(itemstack);
        if (!comparisonList.items.isEmpty()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + I18n.func_135052_a((String)("guiText.label.matchAll." + comparisonList.isMatchAll()), (Object[])new Object[0]) + ":"));
            for (InspectionMatcher.Comparison c : comparisonList.items) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.AQUA + "\u2022 " + c.asLocalizedText()));
            }
        }
    }

    public static InspectionMatcher.ComparisonList getComparisonList(ItemStack filterStack) {
        CompoundNBT compound = filterStack.func_179543_a("modularrouters");
        if (compound != null) {
            boolean matchAll = compound.func_74767_n(NBT_MATCH_ALL);
            ArrayList l = Lists.newArrayList();
            ListNBT items = compound.func_150295_c(NBT_ITEMS, 8);
            for (int i = 0; i < items.size(); ++i) {
                l.add(InspectionMatcher.Comparison.fromString(items.func_150307_f(i)));
            }
            return new InspectionMatcher.ComparisonList(l, matchAll);
        }
        return new InspectionMatcher.ComparisonList(Lists.newArrayList(), false);
    }

    private void setComparisonList(ItemStack filterStack, InspectionMatcher.ComparisonList comparisonList) {
        ListNBT l = comparisonList.items.stream().map(comp -> StringNBT.func_229705_a_((String)comp.toString())).collect(Collectors.toCollection(ListNBT::new));
        CompoundNBT compound = filterStack.func_190925_c("modularrouters");
        compound.func_74757_a(NBT_MATCH_ALL, comparisonList.isMatchAll());
        compound.func_218657_a(NBT_ITEMS, (INBT)l);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Class<? extends Screen> getGuiClass() {
        return GuiInspectionFilter.class;
    }

    @Override
    public GuiSyncMessage onReceiveSettingsMessage(PlayerEntity player, FilterSettingsMessage message, ItemStack filterStack, ItemStack moduleStack) {
        InspectionMatcher.ComparisonList comparisonList = InspectionFilter.getComparisonList(filterStack);
        switch (message.getOp()) {
            case ADD_STRING: {
                if (comparisonList.items.size() >= 6) break;
                InspectionMatcher.Comparison c = InspectionMatcher.Comparison.fromString(message.getPayload().func_74779_i("Comparison"));
                comparisonList.items.add(c);
                this.setComparisonList(filterStack, comparisonList);
                return new GuiSyncMessage(filterStack);
            }
            case REMOVE_AT: {
                int pos = message.getPayload().func_74762_e("Pos");
                if (pos < 0 || pos >= comparisonList.items.size()) break;
                comparisonList.items.remove(pos);
                this.setComparisonList(filterStack, comparisonList);
                return new GuiSyncMessage(filterStack);
            }
            case ANY_ALL_FLAG: {
                comparisonList.setMatchAll(message.getPayload().func_74767_n(NBT_MATCH_ALL));
                this.setComparisonList(filterStack, comparisonList);
                return new GuiSyncMessage(filterStack);
            }
        }
        return null;
    }

    @Override
    public int getSize(ItemStack filterStack) {
        return 0;
    }
}

