/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.augment;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.desht.modularrouters.container.handler.AugmentHandler;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.ItemBase;
import me.desht.modularrouters.item.module.ItemModule;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.Validate;

public abstract class ItemAugment
extends ItemBase {
    public static final int SLOTS = 4;

    public ItemAugment() {
        super(ModItems.defaultProps());
    }

    @Override
    protected void addExtraInformation(ItemStack stack, List<ITextComponent> list) {
    }

    public abstract int getMaxAugments(ItemModule var1);

    public String getExtraInfo(int c, ItemStack moduleStack) {
        return "";
    }

    public static class AugmentCounter {
        private final Map<ResourceLocation, Integer> counts = new HashMap<ResourceLocation, Integer>();

        public AugmentCounter(ItemStack moduleStack) {
            this.refresh(moduleStack);
        }

        public void refresh(ItemStack moduleStack) {
            Validate.isTrue((boolean)(moduleStack.func_77973_b() instanceof ItemModule), (String)("item is not a ItemModule: " + moduleStack), (Object[])new Object[0]);
            AugmentHandler h = new AugmentHandler(moduleStack, null);
            this.counts.clear();
            for (int i = 0; i < h.getSlots(); ++i) {
                ItemStack augmentStack = h.getStackInSlot(i);
                if (!(augmentStack.func_77973_b() instanceof ItemAugment)) continue;
                ResourceLocation k = augmentStack.func_77973_b().getRegistryName();
                this.counts.put(k, this.counts.getOrDefault(k, 0) + augmentStack.func_190916_E());
            }
        }

        public Collection<ItemAugment> getAugments() {
            return this.counts.keySet().stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).map(i -> (ItemAugment)((Object)i)).collect(Collectors.toList());
        }

        public int getAugmentCount(Item type) {
            if (type == null) {
                return 0;
            }
            return this.counts.getOrDefault(type.getRegistryName(), 0);
        }
    }
}

