/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.render.area;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.desht.modularrouters.client.render.ModRenderTypes;
import me.desht.modularrouters.client.render.area.IPositionProvider;
import me.desht.modularrouters.logic.ModuleTarget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ModuleTargetRenderer {
    private static final float BOX_SIZE = 0.5f;
    private static ItemStack lastStack = ItemStack.field_190927_a;
    private static CompiledPosition compiledPos = null;

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        ItemStack curItem;
        if (event.phase == TickEvent.Phase.START && Minecraft.func_71410_x().field_71439_g != null && !ItemStack.func_77989_b((ItemStack)(curItem = Minecraft.func_71410_x().field_71439_g.func_184614_ca()), (ItemStack)lastStack)) {
            lastStack = curItem.func_77946_l();
            IPositionProvider positionProvider = ModuleTargetRenderer.getPositionProvider(curItem);
            compiledPos = positionProvider != null ? new CompiledPosition(curItem, positionProvider) : null;
        }
    }

    @SubscribeEvent
    public static void renderWorldLastEvent(RenderWorldLastEvent event) {
        if (compiledPos != null) {
            IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            MatrixStack matrixStack = event.getMatrixStack();
            matrixStack.func_227860_a_();
            Vec3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
            matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
            ModuleTargetRenderer.render(buffer, matrixStack, compiledPos);
            matrixStack.func_227865_b_();
        }
    }

    private static IPositionProvider getPositionProvider(ItemStack stack) {
        if (stack.func_77973_b() instanceof IPositionProvider) {
            return (IPositionProvider)stack.func_77973_b();
        }
        return null;
    }

    private static void render(IRenderTypeBuffer.Impl buffer, MatrixStack matrixStack, CompiledPosition cp) {
        float start = 0.25f;
        for (BlockPos pos : cp.getPositions()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)((float)pos.func_177958_n() + start), (double)((float)pos.func_177956_o() + start), (double)((float)pos.func_177952_p() + start));
            Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
            int color = cp.getColour(pos);
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            IVertexBuilder faceBuilder = buffer.getBuffer(ModRenderTypes.BLOCK_HILIGHT_FACE);
            int alpha = ModuleTargetRenderer.getFaceAlpha(cp, pos, Direction.NORTH);
            faceBuilder.func_227888_a_(posMat, 0.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, alpha).func_181675_d();
            faceBuilder.func_227888_a_(posMat, 0.0f, 0.5f, 0.0f).func_225586_a_(r, g, b, alpha).func_181675_d();
            faceBuilder.func_227888_a_(posMat, 0.5f, 0.5f, 0.0f).func_225586_a_(r, g, b, alpha).func_181675_d();
            faceBuilder.func_227888_a_(posMat, 0.5f, 0.0f, 0.0f).func_225586_a_(r, g, b, alpha).func_181675_d();
            alpha = ModuleTargetRenderer.getFaceAlpha(cp, pos, Direction.SOUTH);
            faceBuilder.func_227888_a_(posMat, 0.5f, 0.0f, 0.5f).func_225586_a_(r, g, b, alpha).func_181675_d();
            faceBuilder.func_227888_a_(posMat, 0.5f, 0.5f, 0.5f).func_225586_a_(r, g, b, alpha).func_181675_d();
            faceBuilder.func_227888_a_(posMat, 0.0f, 0.5f, 0.5f).func_225586_a_(r, g, b, alpha).func_181675_d();
            faceBuilder.func_227888_a_(posMat, 0.0f, 0.0f, 0.5f).func_225586_a_(r, g, b, alpha).func_181675_d();
            alpha = ModuleTargetRenderer.getFaceAlpha(cp, pos, Direction.WEST);
            faceBuilder.func_227888_a_(posMat, 0.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, alpha).func_181675_d();
            faceBuilder.func_227888_a_(posMat, 0.0f, 0.0f, 0.5f).func_225586_a_(r, g, b, alpha).func_181675_d();
            faceBuilder.func_227888_a_(posMat, 0.0f, 0.5f, 0.5f).func_225586_a_(r, g, b, alpha).func_181675_d();
            faceBuilder.func_227888_a_(posMat, 0.0f, 0.5f, 0.0f).func_225586_a_(r, g, b, alpha).func_181675_d();
            alpha = ModuleTargetRenderer.getFaceAlpha(cp, pos, Direction.EAST);
            faceBuilder.func_227888_a_(posMat, 0.5f, 0.5f, 0.0f).func_225586_a_(r, g, b, alpha).func_181675_d();
            faceBuilder.func_227888_a_(posMat, 0.5f, 0.5f, 0.5f).func_225586_a_(r, g, b, alpha).func_181675_d();
            faceBuilder.func_227888_a_(posMat, 0.5f, 0.0f, 0.5f).func_225586_a_(r, g, b, alpha).func_181675_d();
            faceBuilder.func_227888_a_(posMat, 0.5f, 0.0f, 0.0f).func_225586_a_(r, g, b, alpha).func_181675_d();
            alpha = ModuleTargetRenderer.getFaceAlpha(cp, pos, Direction.DOWN);
            faceBuilder.func_227888_a_(posMat, 0.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, alpha).func_181675_d();
            faceBuilder.func_227888_a_(posMat, 0.5f, 0.0f, 0.0f).func_225586_a_(r, g, b, alpha).func_181675_d();
            faceBuilder.func_227888_a_(posMat, 0.5f, 0.0f, 0.5f).func_225586_a_(r, g, b, alpha).func_181675_d();
            faceBuilder.func_227888_a_(posMat, 0.0f, 0.0f, 0.5f).func_225586_a_(r, g, b, alpha).func_181675_d();
            alpha = ModuleTargetRenderer.getFaceAlpha(cp, pos, Direction.UP);
            faceBuilder.func_227888_a_(posMat, 0.0f, 0.5f, 0.5f).func_225586_a_(r, g, b, alpha).func_181675_d();
            faceBuilder.func_227888_a_(posMat, 0.5f, 0.5f, 0.5f).func_225586_a_(r, g, b, alpha).func_181675_d();
            faceBuilder.func_227888_a_(posMat, 0.5f, 0.5f, 0.0f).func_225586_a_(r, g, b, alpha).func_181675_d();
            faceBuilder.func_227888_a_(posMat, 0.0f, 0.5f, 0.0f).func_225586_a_(r, g, b, alpha).func_181675_d();
            RenderSystem.disableDepthTest();
            buffer.func_228462_a_(ModRenderTypes.BLOCK_HILIGHT_FACE);
            IVertexBuilder lineBuilder = buffer.getBuffer(ModRenderTypes.BLOCK_HILIGHT_LINE);
            lineBuilder.func_227888_a_(posMat, 0.0f, 0.0f, 0.0f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.0f, 0.5f, 0.0f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.5f, 0.5f, 0.0f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.5f, 0.0f, 0.0f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.5f, 0.0f, 0.5f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.5f, 0.5f, 0.5f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.0f, 0.5f, 0.5f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.0f, 0.0f, 0.5f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.0f, 0.0f, 0.0f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.0f, 0.0f, 0.5f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.0f, 0.5f, 0.5f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.0f, 0.5f, 0.0f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.5f, 0.5f, 0.0f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.5f, 0.5f, 0.5f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.5f, 0.0f, 0.5f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.5f, 0.0f, 0.0f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.0f, 0.0f, 0.0f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.5f, 0.0f, 0.0f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.5f, 0.0f, 0.5f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.0f, 0.0f, 0.5f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.0f, 0.5f, 0.5f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.5f, 0.5f, 0.5f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.5f, 0.5f, 0.0f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            lineBuilder.func_227888_a_(posMat, 0.0f, 0.5f, 0.0f).func_225586_a_(64, 64, 64, 80).func_181675_d();
            RenderSystem.disableDepthTest();
            buffer.func_228462_a_(ModRenderTypes.BLOCK_HILIGHT_LINE);
            matrixStack.func_227865_b_();
        }
    }

    private static int getFaceAlpha(CompiledPosition cp, BlockPos pos, Direction face) {
        return cp.checkFace(pos, face) ? 160 : 64;
    }

    static class CompiledPosition {
        Map<BlockPos, FaceAndColour> positions = new HashMap<BlockPos, FaceAndColour>();

        CompiledPosition(ItemStack stack, IPositionProvider provider) {
            List<ModuleTarget> targets = provider.getStoredPositions(stack);
            for (int i = 0; i < targets.size(); ++i) {
                ModuleTarget target = targets.get(i);
                if (!target.isSameWorld((World)Minecraft.func_71410_x().field_71441_e)) continue;
                BlockPos pos = target.gPos.func_218180_b();
                if (this.positions.containsKey(pos)) {
                    this.positions.get((Object)pos).faces.set(target.face.ordinal());
                    continue;
                }
                FaceAndColour fc = new FaceAndColour(new BitSet(6), provider.getRenderColor(i));
                fc.faces.set(target.face.ordinal());
                this.positions.put(pos, fc);
            }
        }

        Set<BlockPos> getPositions() {
            return this.positions.keySet();
        }

        boolean checkFace(BlockPos pos, Direction face) {
            return this.positions.containsKey(pos) && this.positions.get((Object)pos).faces.get(face.func_176745_a());
        }

        int getColour(BlockPos pos) {
            return this.positions.containsKey(pos) ? this.positions.get((Object)pos).colour : 0;
        }

        static class FaceAndColour {
            final BitSet faces;
            final int colour;

            FaceAndColour(BitSet faces, int colour) {
                this.faces = faces;
                this.colour = colour;
            }
        }
    }
}

