/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math;

import java.util.EnumSet;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.dispenser.IPosition;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3i;

public class Vec3d
implements IPosition {
    public static final Vec3d field_186680_a = new Vec3d(0.0, 0.0, 0.0);
    public final double field_72450_a;
    public final double field_72448_b;
    public final double field_72449_c;

    public Vec3d(double xIn, double yIn, double zIn) {
        this.field_72450_a = xIn;
        this.field_72448_b = yIn;
        this.field_72449_c = zIn;
    }

    public Vec3d(Vector3f p_i225900_1_) {
        this(p_i225900_1_.func_195899_a(), p_i225900_1_.func_195900_b(), p_i225900_1_.func_195902_c());
    }

    public Vec3d(Vec3i vector) {
        this(vector.func_177958_n(), vector.func_177956_o(), vector.func_177952_p());
    }

    public Vec3d func_72444_a(Vec3d vec) {
        return new Vec3d(vec.field_72450_a - this.field_72450_a, vec.field_72448_b - this.field_72448_b, vec.field_72449_c - this.field_72449_c);
    }

    public Vec3d func_72432_b() {
        double d0 = MathHelper.func_76133_a((double)(this.field_72450_a * this.field_72450_a + this.field_72448_b * this.field_72448_b + this.field_72449_c * this.field_72449_c));
        return d0 < 1.0E-4 ? field_186680_a : new Vec3d(this.field_72450_a / d0, this.field_72448_b / d0, this.field_72449_c / d0);
    }

    public double func_72430_b(Vec3d vec) {
        return this.field_72450_a * vec.field_72450_a + this.field_72448_b * vec.field_72448_b + this.field_72449_c * vec.field_72449_c;
    }

    public Vec3d func_72431_c(Vec3d vec) {
        return new Vec3d(this.field_72448_b * vec.field_72449_c - this.field_72449_c * vec.field_72448_b, this.field_72449_c * vec.field_72450_a - this.field_72450_a * vec.field_72449_c, this.field_72450_a * vec.field_72448_b - this.field_72448_b * vec.field_72450_a);
    }

    public Vec3d func_178788_d(Vec3d vec) {
        return this.func_178786_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Vec3d func_178786_a(double x, double y, double z) {
        return this.func_72441_c(-x, -y, -z);
    }

    public Vec3d func_178787_e(Vec3d vec) {
        return this.func_72441_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Vec3d func_72441_c(double x, double y, double z) {
        return new Vec3d(this.field_72450_a + x, this.field_72448_b + y, this.field_72449_c + z);
    }

    public double func_72438_d(Vec3d vec) {
        double d0 = vec.field_72450_a - this.field_72450_a;
        double d1 = vec.field_72448_b - this.field_72448_b;
        double d2 = vec.field_72449_c - this.field_72449_c;
        return MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
    }

    public double func_72436_e(Vec3d vec) {
        double d0 = vec.field_72450_a - this.field_72450_a;
        double d1 = vec.field_72448_b - this.field_72448_b;
        double d2 = vec.field_72449_c - this.field_72449_c;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double func_186679_c(double xIn, double yIn, double zIn) {
        double d0 = xIn - this.field_72450_a;
        double d1 = yIn - this.field_72448_b;
        double d2 = zIn - this.field_72449_c;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public Vec3d func_186678_a(double factor) {
        return this.func_216372_d(factor, factor, factor);
    }

    public Vec3d func_216371_e() {
        return this.func_186678_a(-1.0);
    }

    public Vec3d func_216369_h(Vec3d p_216369_1_) {
        return this.func_216372_d(p_216369_1_.field_72450_a, p_216369_1_.field_72448_b, p_216369_1_.field_72449_c);
    }

    public Vec3d func_216372_d(double factorX, double factorY, double factorZ) {
        return new Vec3d(this.field_72450_a * factorX, this.field_72448_b * factorY, this.field_72449_c * factorZ);
    }

    public double func_72433_c() {
        return MathHelper.func_76133_a((double)(this.field_72450_a * this.field_72450_a + this.field_72448_b * this.field_72448_b + this.field_72449_c * this.field_72449_c));
    }

    public double func_189985_c() {
        return this.field_72450_a * this.field_72450_a + this.field_72448_b * this.field_72448_b + this.field_72449_c * this.field_72449_c;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof Vec3d)) {
            return false;
        }
        Vec3d vec3d = (Vec3d)p_equals_1_;
        if (Double.compare(vec3d.field_72450_a, this.field_72450_a) != 0) {
            return false;
        }
        if (Double.compare(vec3d.field_72448_b, this.field_72448_b) != 0) {
            return false;
        }
        return Double.compare(vec3d.field_72449_c, this.field_72449_c) == 0;
    }

    public int hashCode() {
        long j = Double.doubleToLongBits(this.field_72450_a);
        int i = (int)(j ^ j >>> 32);
        j = Double.doubleToLongBits(this.field_72448_b);
        i = 31 * i + (int)(j ^ j >>> 32);
        j = Double.doubleToLongBits(this.field_72449_c);
        i = 31 * i + (int)(j ^ j >>> 32);
        return i;
    }

    public String toString() {
        return "(" + this.field_72450_a + ", " + this.field_72448_b + ", " + this.field_72449_c + ")";
    }

    public Vec3d func_178789_a(float pitch) {
        float f = MathHelper.func_76134_b((float)pitch);
        float f1 = MathHelper.func_76126_a((float)pitch);
        double d0 = this.field_72450_a;
        double d1 = this.field_72448_b * (double)f + this.field_72449_c * (double)f1;
        double d2 = this.field_72449_c * (double)f - this.field_72448_b * (double)f1;
        return new Vec3d(d0, d1, d2);
    }

    public Vec3d func_178785_b(float yaw) {
        float f = MathHelper.func_76134_b((float)yaw);
        float f1 = MathHelper.func_76126_a((float)yaw);
        double d0 = this.field_72450_a * (double)f + this.field_72449_c * (double)f1;
        double d1 = this.field_72448_b;
        double d2 = this.field_72449_c * (double)f - this.field_72450_a * (double)f1;
        return new Vec3d(d0, d1, d2);
    }

    public static Vec3d func_189984_a(Vec2f p_189984_0_) {
        return Vec3d.func_189986_a(p_189984_0_.field_189982_i, p_189984_0_.field_189983_j);
    }

    public static Vec3d func_189986_a(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d(f1 * f2, f3, f * f2);
    }

    public Vec3d func_197746_a(EnumSet<Direction.Axis> axes) {
        double d0 = axes.contains(Direction.Axis.X) ? (double)MathHelper.func_76128_c((double)this.field_72450_a) : this.field_72450_a;
        double d1 = axes.contains(Direction.Axis.Y) ? (double)MathHelper.func_76128_c((double)this.field_72448_b) : this.field_72448_b;
        double d2 = axes.contains(Direction.Axis.Z) ? (double)MathHelper.func_76128_c((double)this.field_72449_c) : this.field_72449_c;
        return new Vec3d(d0, d1, d2);
    }

    public double func_216370_a(Direction.Axis axis) {
        return axis.func_196051_a(this.field_72450_a, this.field_72448_b, this.field_72449_c);
    }

    public final double func_82615_a() {
        return this.field_72450_a;
    }

    public final double func_82617_b() {
        return this.field_72448_b;
    }

    public final double func_82616_c() {
        return this.field_72449_c;
    }
}

