/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.pathfinding.FlaggedPathPoint;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.Region;

public class WalkNodeProcessor
extends NodeProcessor {
    protected float field_176183_h;

    public void func_225578_a_(Region p_225578_1_, MobEntity p_225578_2_) {
        super.func_225578_a_(p_225578_1_, p_225578_2_);
        this.field_176183_h = p_225578_2_.func_184643_a(PathNodeType.WATER);
    }

    public void func_176163_a() {
        this.field_186326_b.func_184644_a(PathNodeType.WATER, this.field_176183_h);
        super.func_176163_a();
    }

    public PathPoint func_186318_b() {
        int i;
        if (this.func_186322_e() && this.field_186326_b.func_70090_H()) {
            i = MathHelper.func_76128_c((double)this.field_186326_b.func_226278_cu_());
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(this.field_186326_b.func_226277_ct_(), (double)i, this.field_186326_b.func_226281_cx_());
            BlockState blockstate = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutable);
            while (blockstate.func_177230_c() == Blocks.field_150355_j || blockstate.func_204520_s() == Fluids.field_204546_a.func_207204_a(false)) {
                blockpos$mutable.func_189532_c(this.field_186326_b.func_226277_ct_(), (double)(++i), this.field_186326_b.func_226281_cx_());
                blockstate = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutable);
            }
            --i;
        } else if (this.field_186326_b.field_70122_E) {
            i = MathHelper.func_76128_c((double)(this.field_186326_b.func_226278_cu_() + 0.5));
        } else {
            BlockPos blockpos = new BlockPos((Entity)this.field_186326_b);
            while ((this.field_176169_a.func_180495_p(blockpos).func_196958_f() || this.field_176169_a.func_180495_p(blockpos).func_196957_g((IBlockReader)this.field_176169_a, blockpos, PathType.LAND)) && blockpos.func_177956_o() > 0) {
                blockpos = blockpos.func_177977_b();
            }
            i = blockpos.func_177984_a().func_177956_o();
        }
        BlockPos blockpos2 = new BlockPos((Entity)this.field_186326_b);
        PathNodeType pathnodetype1 = this.func_186331_a(this.field_186326_b, blockpos2.func_177958_n(), i, blockpos2.func_177952_p());
        if (this.field_186326_b.func_184643_a(pathnodetype1) < 0.0f) {
            HashSet set = Sets.newHashSet();
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)i, this.field_186326_b.func_174813_aQ().field_72339_c));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)i, this.field_186326_b.func_174813_aQ().field_72334_f));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)i, this.field_186326_b.func_174813_aQ().field_72339_c));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)i, this.field_186326_b.func_174813_aQ().field_72334_f));
            for (BlockPos blockpos1 : set) {
                PathNodeType pathnodetype = this.func_186329_a(this.field_186326_b, blockpos1);
                if (!(this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f)) continue;
                return this.func_176159_a(blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p());
            }
        }
        return this.func_176159_a(blockpos2.func_177958_n(), i, blockpos2.func_177952_p());
    }

    public FlaggedPathPoint func_224768_a(double p_224768_1_, double p_224768_3_, double p_224768_5_) {
        return new FlaggedPathPoint(this.func_176159_a(MathHelper.func_76128_c((double)p_224768_1_), MathHelper.func_76128_c((double)p_224768_3_), MathHelper.func_76128_c((double)p_224768_5_)));
    }

    public int func_222859_a(PathPoint[] p_222859_1_, PathPoint p_222859_2_) {
        PathPoint pathpoint7;
        PathPoint pathpoint6;
        PathPoint pathpoint5;
        PathPoint pathpoint4;
        PathPoint pathpoint3;
        PathPoint pathpoint2;
        PathPoint pathpoint1;
        double d0;
        PathPoint pathpoint;
        int i = 0;
        int j = 0;
        PathNodeType pathnodetype = this.func_186331_a(this.field_186326_b, p_222859_2_.field_75839_a, p_222859_2_.field_75837_b + 1, p_222859_2_.field_75838_c);
        if (this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f) {
            PathNodeType pathnodetype1 = this.func_186331_a(this.field_186326_b, p_222859_2_.field_75839_a, p_222859_2_.field_75837_b, p_222859_2_.field_75838_c);
            j = pathnodetype1 == PathNodeType.STICKY_HONEY ? 0 : MathHelper.func_76141_d((float)Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        if ((pathpoint = this.func_186332_a(p_222859_2_.field_75839_a, p_222859_2_.field_75837_b, p_222859_2_.field_75838_c + 1, j, d0 = WalkNodeProcessor.func_197682_a((IBlockReader)this.field_176169_a, new BlockPos(p_222859_2_.field_75839_a, p_222859_2_.field_75837_b, p_222859_2_.field_75838_c)), Direction.SOUTH)) != null && !pathpoint.field_75842_i && pathpoint.field_186286_l >= 0.0f) {
            p_222859_1_[i++] = pathpoint;
        }
        if ((pathpoint1 = this.func_186332_a(p_222859_2_.field_75839_a - 1, p_222859_2_.field_75837_b, p_222859_2_.field_75838_c, j, d0, Direction.WEST)) != null && !pathpoint1.field_75842_i && pathpoint1.field_186286_l >= 0.0f) {
            p_222859_1_[i++] = pathpoint1;
        }
        if ((pathpoint2 = this.func_186332_a(p_222859_2_.field_75839_a + 1, p_222859_2_.field_75837_b, p_222859_2_.field_75838_c, j, d0, Direction.EAST)) != null && !pathpoint2.field_75842_i && pathpoint2.field_186286_l >= 0.0f) {
            p_222859_1_[i++] = pathpoint2;
        }
        if ((pathpoint3 = this.func_186332_a(p_222859_2_.field_75839_a, p_222859_2_.field_75837_b, p_222859_2_.field_75838_c - 1, j, d0, Direction.NORTH)) != null && !pathpoint3.field_75842_i && pathpoint3.field_186286_l >= 0.0f) {
            p_222859_1_[i++] = pathpoint3;
        }
        if (this.func_222860_a(p_222859_2_, pathpoint1, pathpoint3, pathpoint4 = this.func_186332_a(p_222859_2_.field_75839_a - 1, p_222859_2_.field_75837_b, p_222859_2_.field_75838_c - 1, j, d0, Direction.NORTH))) {
            p_222859_1_[i++] = pathpoint4;
        }
        if (this.func_222860_a(p_222859_2_, pathpoint2, pathpoint3, pathpoint5 = this.func_186332_a(p_222859_2_.field_75839_a + 1, p_222859_2_.field_75837_b, p_222859_2_.field_75838_c - 1, j, d0, Direction.NORTH))) {
            p_222859_1_[i++] = pathpoint5;
        }
        if (this.func_222860_a(p_222859_2_, pathpoint1, pathpoint, pathpoint6 = this.func_186332_a(p_222859_2_.field_75839_a - 1, p_222859_2_.field_75837_b, p_222859_2_.field_75838_c + 1, j, d0, Direction.SOUTH))) {
            p_222859_1_[i++] = pathpoint6;
        }
        if (this.func_222860_a(p_222859_2_, pathpoint2, pathpoint, pathpoint7 = this.func_186332_a(p_222859_2_.field_75839_a + 1, p_222859_2_.field_75837_b, p_222859_2_.field_75838_c + 1, j, d0, Direction.SOUTH))) {
            p_222859_1_[i++] = pathpoint7;
        }
        return i;
    }

    private boolean func_222860_a(PathPoint p_222860_1_, @Nullable PathPoint p_222860_2_, @Nullable PathPoint p_222860_3_, @Nullable PathPoint p_222860_4_) {
        if (p_222860_4_ != null && p_222860_3_ != null && p_222860_2_ != null) {
            if (p_222860_4_.field_75842_i) {
                return false;
            }
            if (p_222860_3_.field_75837_b <= p_222860_1_.field_75837_b && p_222860_2_.field_75837_b <= p_222860_1_.field_75837_b) {
                return p_222860_4_.field_186286_l >= 0.0f && (p_222860_3_.field_75837_b < p_222860_1_.field_75837_b || p_222860_3_.field_186286_l >= 0.0f) && (p_222860_2_.field_75837_b < p_222860_1_.field_75837_b || p_222860_2_.field_186286_l >= 0.0f);
            }
            return false;
        }
        return false;
    }

    public static double func_197682_a(IBlockReader p_197682_0_, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        VoxelShape voxelshape = p_197682_0_.func_180495_p(blockpos).func_196952_d(p_197682_0_, blockpos);
        return (double)blockpos.func_177956_o() + (voxelshape.func_197766_b() ? 0.0 : voxelshape.func_197758_c(Direction.Axis.Y));
    }

    @Nullable
    private PathPoint func_186332_a(int x, int y, int z, int stepHeight, double groundYIn, Direction facing) {
        double d3;
        double d2;
        AxisAlignedBB axisalignedbb;
        PathPoint pathpoint = null;
        BlockPos blockpos = new BlockPos(x, y, z);
        double d0 = WalkNodeProcessor.func_197682_a((IBlockReader)this.field_176169_a, blockpos);
        if (d0 - groundYIn > 1.125) {
            return null;
        }
        PathNodeType pathnodetype = this.func_186331_a(this.field_186326_b, x, y, z);
        float f = this.field_186326_b.func_184643_a(pathnodetype);
        double d1 = (double)this.field_186326_b.func_213311_cf() / 2.0;
        if (f >= 0.0f) {
            pathpoint = this.func_176159_a(x, y, z);
            pathpoint.field_186287_m = pathnodetype;
            pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
        }
        if (pathnodetype == PathNodeType.WALKABLE) {
            return pathpoint;
        }
        if (!(pathpoint != null && !(pathpoint.field_186286_l < 0.0f) || stepHeight <= 0 || pathnodetype == PathNodeType.FENCE || pathnodetype == PathNodeType.TRAPDOOR || (pathpoint = this.func_186332_a(x, y + 1, z, stepHeight - 1, groundYIn, facing)) == null || pathpoint.field_186287_m != PathNodeType.OPEN && pathpoint.field_186287_m != PathNodeType.WALKABLE || !(this.field_186326_b.func_213311_cf() < 1.0f) || this.field_176169_a.func_226665_a__((Entity)this.field_186326_b, axisalignedbb = new AxisAlignedBB((d2 = (double)(x - facing.func_82601_c()) + 0.5) - d1, WalkNodeProcessor.func_197682_a((IBlockReader)this.field_176169_a, new BlockPos(d2, (double)(y + 1), d3 = (double)(z - facing.func_82599_e()) + 0.5)) + 0.001, d3 - d1, d2 + d1, (double)this.field_186326_b.func_213302_cg() + WalkNodeProcessor.func_197682_a((IBlockReader)this.field_176169_a, new BlockPos(pathpoint.field_75839_a, pathpoint.field_75837_b, pathpoint.field_75838_c)) - 0.002, d3 + d1)))) {
            pathpoint = null;
        }
        if (pathnodetype == PathNodeType.WATER && !this.func_186322_e()) {
            if (this.func_186331_a(this.field_186326_b, x, y - 1, z) != PathNodeType.WATER) {
                return pathpoint;
            }
            while (y > 0) {
                if ((pathnodetype = this.func_186331_a(this.field_186326_b, x, --y, z)) != PathNodeType.WATER) {
                    return pathpoint;
                }
                pathpoint = this.func_176159_a(x, y, z);
                pathpoint.field_186287_m = pathnodetype;
                pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, this.field_186326_b.func_184643_a(pathnodetype));
            }
        }
        if (pathnodetype == PathNodeType.OPEN) {
            PathNodeType pathnodetype1;
            AxisAlignedBB axisalignedbb1 = new AxisAlignedBB((double)x - d1 + 0.5, (double)y + 0.001, (double)z - d1 + 0.5, (double)x + d1 + 0.5, (double)((float)y + this.field_186326_b.func_213302_cg()), (double)z + d1 + 0.5);
            if (!this.field_176169_a.func_226665_a__((Entity)this.field_186326_b, axisalignedbb1)) {
                return null;
            }
            if (this.field_186326_b.func_213311_cf() >= 1.0f && (pathnodetype1 = this.func_186331_a(this.field_186326_b, x, y - 1, z)) == PathNodeType.BLOCKED) {
                pathpoint = this.func_176159_a(x, y, z);
                pathpoint.field_186287_m = PathNodeType.WALKABLE;
                pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
                return pathpoint;
            }
            int i = 0;
            int j = y;
            while (pathnodetype == PathNodeType.OPEN) {
                if (--y < 0) {
                    PathPoint pathpoint2 = this.func_176159_a(x, j, z);
                    pathpoint2.field_186287_m = PathNodeType.BLOCKED;
                    pathpoint2.field_186286_l = -1.0f;
                    return pathpoint2;
                }
                PathPoint pathpoint1 = this.func_176159_a(x, y, z);
                if (i++ >= this.field_186326_b.func_82143_as()) {
                    pathpoint1.field_186287_m = PathNodeType.BLOCKED;
                    pathpoint1.field_186286_l = -1.0f;
                    return pathpoint1;
                }
                pathnodetype = this.func_186331_a(this.field_186326_b, x, y, z);
                f = this.field_186326_b.func_184643_a(pathnodetype);
                if (pathnodetype != PathNodeType.OPEN && f >= 0.0f) {
                    pathpoint = pathpoint1;
                    pathpoint1.field_186287_m = pathnodetype;
                    pathpoint1.field_186286_l = Math.max(pathpoint1.field_186286_l, f);
                    break;
                }
                if (!(f < 0.0f)) continue;
                pathpoint1.field_186287_m = PathNodeType.BLOCKED;
                pathpoint1.field_186286_l = -1.0f;
                return pathpoint1;
            }
        }
        return pathpoint;
    }

    public PathNodeType func_186319_a(IBlockReader blockaccessIn, int x, int y, int z, MobEntity entitylivingIn, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        EnumSet<PathNodeType> enumset = EnumSet.noneOf(PathNodeType.class);
        PathNodeType pathnodetype = PathNodeType.BLOCKED;
        double d0 = (double)entitylivingIn.func_213311_cf() / 2.0;
        BlockPos blockpos = new BlockPos((Entity)entitylivingIn);
        pathnodetype = this.func_193577_a(blockaccessIn, x, y, z, xSize, ySize, zSize, canBreakDoorsIn, canEnterDoorsIn, enumset, pathnodetype, blockpos);
        if (enumset.contains(PathNodeType.FENCE)) {
            return PathNodeType.FENCE;
        }
        PathNodeType pathnodetype1 = PathNodeType.BLOCKED;
        for (PathNodeType pathnodetype2 : enumset) {
            if (entitylivingIn.func_184643_a(pathnodetype2) < 0.0f) {
                return pathnodetype2;
            }
            if (!(entitylivingIn.func_184643_a(pathnodetype2) >= entitylivingIn.func_184643_a(pathnodetype1))) continue;
            pathnodetype1 = pathnodetype2;
        }
        return pathnodetype == PathNodeType.OPEN && entitylivingIn.func_184643_a(pathnodetype1) == 0.0f ? PathNodeType.OPEN : pathnodetype1;
    }

    public PathNodeType func_193577_a(IBlockReader p_193577_1_, int x, int y, int z, int xSize, int ySize, int zSize, boolean canOpenDoorsIn, boolean canEnterDoorsIn, EnumSet<PathNodeType> nodeTypeEnum, PathNodeType nodeType, BlockPos pos) {
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int l = i + x;
                    int i1 = j + y;
                    int j1 = k + z;
                    PathNodeType pathnodetype = this.func_186330_a(p_193577_1_, l, i1, j1);
                    pathnodetype = this.func_215744_a(p_193577_1_, canOpenDoorsIn, canEnterDoorsIn, pos, pathnodetype);
                    if (i == 0 && j == 0 && k == 0) {
                        nodeType = pathnodetype;
                    }
                    nodeTypeEnum.add(pathnodetype);
                }
            }
        }
        return nodeType;
    }

    protected PathNodeType func_215744_a(IBlockReader p_215744_1_, boolean p_215744_2_, boolean p_215744_3_, BlockPos p_215744_4_, PathNodeType p_215744_5_) {
        if (p_215744_5_ == PathNodeType.DOOR_WOOD_CLOSED && p_215744_2_ && p_215744_3_) {
            p_215744_5_ = PathNodeType.WALKABLE;
        }
        if (p_215744_5_ == PathNodeType.DOOR_OPEN && !p_215744_3_) {
            p_215744_5_ = PathNodeType.BLOCKED;
        }
        if (p_215744_5_ == PathNodeType.RAIL && !(p_215744_1_.func_180495_p(p_215744_4_).func_177230_c() instanceof AbstractRailBlock) && !(p_215744_1_.func_180495_p(p_215744_4_.func_177977_b()).func_177230_c() instanceof AbstractRailBlock)) {
            p_215744_5_ = PathNodeType.FENCE;
        }
        if (p_215744_5_ == PathNodeType.LEAVES) {
            p_215744_5_ = PathNodeType.BLOCKED;
        }
        return p_215744_5_;
    }

    private PathNodeType func_186329_a(MobEntity entitylivingIn, BlockPos pos) {
        return this.func_186331_a(entitylivingIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private PathNodeType func_186331_a(MobEntity entitylivingIn, int x, int y, int z) {
        return this.func_186319_a((IBlockReader)this.field_176169_a, x, y, z, entitylivingIn, this.field_176168_c, this.field_176165_d, this.field_176166_e, this.func_186324_d(), this.func_186323_c());
    }

    public PathNodeType func_186330_a(IBlockReader blockaccessIn, int x, int y, int z) {
        return WalkNodeProcessor.func_227480_b_(blockaccessIn, x, y, z);
    }

    public static PathNodeType func_227480_b_(IBlockReader p_227480_0_, int p_227480_1_, int p_227480_2_, int p_227480_3_) {
        PathNodeType pathnodetype = WalkNodeProcessor.func_189553_b(p_227480_0_, p_227480_1_, p_227480_2_, p_227480_3_);
        if (pathnodetype == PathNodeType.OPEN && p_227480_2_ >= 1) {
            Block block = p_227480_0_.func_180495_p(new BlockPos(p_227480_1_, p_227480_2_ - 1, p_227480_3_)).func_177230_c();
            PathNodeType pathnodetype1 = WalkNodeProcessor.func_189553_b(p_227480_0_, p_227480_1_, p_227480_2_ - 1, p_227480_3_);
            PathNodeType pathNodeType = pathnodetype = pathnodetype1 != PathNodeType.WALKABLE && pathnodetype1 != PathNodeType.OPEN && pathnodetype1 != PathNodeType.WATER && pathnodetype1 != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
            if (pathnodetype1 == PathNodeType.DAMAGE_FIRE || block == Blocks.field_196814_hQ || block == Blocks.field_222433_lV) {
                pathnodetype = PathNodeType.DAMAGE_FIRE;
            }
            if (pathnodetype1 == PathNodeType.DAMAGE_CACTUS) {
                pathnodetype = PathNodeType.DAMAGE_CACTUS;
            }
            if (pathnodetype1 == PathNodeType.DAMAGE_OTHER) {
                pathnodetype = PathNodeType.DAMAGE_OTHER;
            }
            if (pathnodetype1 == PathNodeType.STICKY_HONEY) {
                pathnodetype = PathNodeType.STICKY_HONEY;
            }
        }
        if (pathnodetype == PathNodeType.WALKABLE) {
            pathnodetype = WalkNodeProcessor.func_193578_a(p_227480_0_, p_227480_1_, p_227480_2_, p_227480_3_, pathnodetype);
        }
        return pathnodetype;
    }

    public static PathNodeType func_193578_a(IBlockReader p_193578_0_, int blockaccessIn, int x, int y, PathNodeType z) {
        try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        PathNodeType type;
                        if (i == 0 && k == 0 || (type = WalkNodeProcessor.func_189553_b(p_193578_0_, blockaccessIn, x, y)) != PathNodeType.DANGER_CACTUS && type != PathNodeType.DANGER_FIRE && type != PathNodeType.DANGER_OTHER) continue;
                        z = type;
                    }
                }
            }
        }
        return z;
    }

    protected static PathNodeType func_189553_b(IBlockReader p_189553_0_, int blockaccessIn, int x, int y) {
        BlockPos blockpos = new BlockPos(blockaccessIn, x, y);
        BlockState blockstate = p_189553_0_.func_180495_p(blockpos);
        PathNodeType type = blockstate.getAiPathNodeType(p_189553_0_, blockpos);
        if (type != null) {
            return type;
        }
        Block block = blockstate.func_177230_c();
        Material material = blockstate.func_185904_a();
        if (blockstate.isAir(p_189553_0_, blockpos)) {
            return PathNodeType.OPEN;
        }
        if (!block.func_203417_a(BlockTags.field_212185_E) && block != Blocks.field_196651_dG) {
            if (block == Blocks.field_150480_ab) {
                return PathNodeType.DAMAGE_FIRE;
            }
            if (block == Blocks.field_150434_aF) {
                return PathNodeType.DAMAGE_CACTUS;
            }
            if (block == Blocks.field_222434_lW) {
                return PathNodeType.DAMAGE_OTHER;
            }
            if (block == Blocks.field_226907_mc_) {
                return PathNodeType.STICKY_HONEY;
            }
            if (block == Blocks.field_150375_by) {
                return PathNodeType.COCOA;
            }
            if (block instanceof DoorBlock && material == Material.field_151575_d && !((Boolean)blockstate.func_177229_b((IProperty)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_WOOD_CLOSED;
            }
            if (block instanceof DoorBlock && material == Material.field_151573_f && !((Boolean)blockstate.func_177229_b((IProperty)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_IRON_CLOSED;
            }
            if (block instanceof DoorBlock && ((Boolean)blockstate.func_177229_b((IProperty)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_OPEN;
            }
            if (block instanceof AbstractRailBlock) {
                return PathNodeType.RAIL;
            }
            if (block instanceof LeavesBlock) {
                return PathNodeType.LEAVES;
            }
            if (!(block.func_203417_a(BlockTags.field_219748_G) || block.func_203417_a(BlockTags.field_219757_z) || block instanceof FenceGateBlock && !((Boolean)blockstate.func_177229_b((IProperty)FenceGateBlock.field_176466_a)).booleanValue())) {
                IFluidState ifluidstate = p_189553_0_.func_204610_c(blockpos);
                if (ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
                    return PathNodeType.WATER;
                }
                if (ifluidstate.func_206884_a(FluidTags.field_206960_b)) {
                    return PathNodeType.LAVA;
                }
                return blockstate.func_196957_g(p_189553_0_, blockpos, PathType.LAND) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
            }
            return PathNodeType.FENCE;
        }
        return PathNodeType.TRAPDOOR;
    }
}

