/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CookingRecipeSerializer<T extends AbstractCookingRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final int field_222178_t;
    private final IFactory<T> field_222179_u;

    public CookingRecipeSerializer(IFactory<T> p_i50025_1_, int p_i50025_2_) {
        this.field_222178_t = p_i50025_2_;
        this.field_222179_u = p_i50025_1_;
    }

    @Override
    public T func_199425_a_(ResourceLocation recipeId, JsonObject json) {
        ItemStack itemstack;
        String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonelement);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("result").isJsonObject()) {
            itemstack = ShapedRecipe.func_199798_a(JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        } else {
            String s1 = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(s1);
            itemstack = new ItemStack((IItemProvider)Registry.field_212630_s.func_218349_b(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
        }
        float f = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
        int i = JSONUtils.func_151208_a((JsonObject)json, (String)"cookingtime", (int)this.field_222178_t);
        return this.field_222179_u.create(recipeId, s, ingredient, itemstack, f, i);
    }

    @Override
    public T func_199426_a_(ResourceLocation recipeId, PacketBuffer buffer) {
        String s = buffer.func_150789_c(Short.MAX_VALUE);
        Ingredient ingredient = Ingredient.func_199566_b(buffer);
        ItemStack itemstack = buffer.func_150791_c();
        float f = buffer.readFloat();
        int i = buffer.func_150792_a();
        return this.field_222179_u.create(recipeId, s, ingredient, itemstack, f, i);
    }

    @Override
    public void func_199427_a_(PacketBuffer buffer, T recipe) {
        buffer.func_180714_a(((AbstractCookingRecipe)recipe).field_222141_c);
        ((AbstractCookingRecipe)recipe).field_222142_d.func_199564_a(buffer);
        buffer.func_150788_a(((AbstractCookingRecipe)recipe).field_222143_e);
        buffer.writeFloat(((AbstractCookingRecipe)recipe).field_222144_f);
        buffer.func_150787_b(((AbstractCookingRecipe)recipe).field_222145_g);
    }

    static interface IFactory<T extends AbstractCookingRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4, float var5, int var6);
    }
}

