/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.fluid;

import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.extensions.IForgeFluid;
import net.minecraftforge.common.util.ReverseTagWrapper;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class Fluid
extends ForgeRegistryEntry<Fluid>
implements IForgeFluid {
    public static final ObjectIntIdentityMap<IFluidState> field_207201_d = new ObjectIntIdentityMap();
    protected final StateContainer<Fluid, IFluidState> field_207202_e;
    private IFluidState field_207200_b;
    private final ReverseTagWrapper<Fluid> reverseTags = new ReverseTagWrapper((Object)this, FluidTags::getGeneration, FluidTags::func_226157_a_);
    private FluidAttributes forgeFluidAttributes;

    protected Fluid() {
        StateContainer.Builder builder = new StateContainer.Builder((Object)this);
        this.func_207184_a((StateContainer.Builder<Fluid, IFluidState>)builder);
        this.field_207202_e = builder.func_206893_a(FluidState::new);
        this.func_207183_f((IFluidState)this.field_207202_e.func_177621_b());
    }

    protected void func_207184_a(StateContainer.Builder<Fluid, IFluidState> builder) {
    }

    public StateContainer<Fluid, IFluidState> func_207182_e() {
        return this.field_207202_e;
    }

    protected final void func_207183_f(IFluidState state) {
        this.field_207200_b = state;
    }

    public final IFluidState func_207188_f() {
        return this.field_207200_b;
    }

    public abstract Item func_204524_b();

    @OnlyIn(value=Dist.CLIENT)
    protected void func_204522_a(World worldIn, BlockPos pos, IFluidState state, Random random) {
    }

    protected void func_207191_a(World worldIn, BlockPos pos, IFluidState state) {
    }

    protected void func_207186_b(World p_207186_1_, BlockPos pos, IFluidState state, Random random) {
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    protected IParticleData func_204521_c() {
        return null;
    }

    protected abstract boolean func_215665_a(IFluidState var1, IBlockReader var2, BlockPos var3, Fluid var4, Direction var5);

    protected abstract Vec3d func_215663_a(IBlockReader var1, BlockPos var2, IFluidState var3);

    public abstract int func_205569_a(IWorldReader var1);

    protected boolean func_207196_h() {
        return false;
    }

    protected boolean func_204538_c() {
        return false;
    }

    protected abstract float func_210195_d();

    public abstract float func_215662_a(IFluidState var1, IBlockReader var2, BlockPos var3);

    public abstract float func_223407_a(IFluidState var1);

    protected abstract BlockState func_204527_a(IFluidState var1);

    public abstract boolean func_207193_c(IFluidState var1);

    public abstract int func_207192_d(IFluidState var1);

    public boolean func_207187_a(Fluid fluidIn) {
        return fluidIn == this;
    }

    public boolean func_207185_a(Tag<Fluid> tagIn) {
        return tagIn.func_199685_a_(this);
    }

    public abstract VoxelShape func_215664_b(IFluidState var1, IBlockReader var2, BlockPos var3);

    public Set<ResourceLocation> getTags() {
        return this.reverseTags.getTagNames();
    }

    protected FluidAttributes createAttributes() {
        return ForgeHooks.createVanillaFluidAttributes((Fluid)this);
    }

    public final FluidAttributes getAttributes() {
        if (this.forgeFluidAttributes == null) {
            this.forgeFluidAttributes = this.createAttributes();
        }
        return this.forgeFluidAttributes;
    }
}

