/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.LocationInput;
import net.minecraft.command.arguments.RotationArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;

public class TeleportCommand {
    public static void func_198809_a(CommandDispatcher<CommandSource> dispatcher) {
        LiteralCommandNode literalcommandnode = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("teleport").requires(p_198816_0_ -> p_198816_0_.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a("targets", EntityArgument.func_197093_b()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a("location", Vec3Argument.func_197301_a()).executes(p_198807_0_ -> TeleportCommand.func_200559_a((CommandSource)p_198807_0_.getSource(), EntityArgument.func_197097_b((CommandContext)p_198807_0_, (String)"targets"), ((CommandSource)p_198807_0_.getSource()).func_197023_e(), Vec3Argument.func_200385_b((CommandContext)p_198807_0_, (String)"location"), null, null))).then(Commands.func_197056_a("rotation", RotationArgument.func_197288_a()).executes(p_198811_0_ -> TeleportCommand.func_200559_a((CommandSource)p_198811_0_.getSource(), EntityArgument.func_197097_b((CommandContext)p_198811_0_, (String)"targets"), ((CommandSource)p_198811_0_.getSource()).func_197023_e(), Vec3Argument.func_200385_b((CommandContext)p_198811_0_, (String)"location"), RotationArgument.func_200384_a((CommandContext)p_198811_0_, (String)"rotation"), null)))).then(((LiteralArgumentBuilder)Commands.func_197057_a("facing").then(Commands.func_197057_a("entity").then(((RequiredArgumentBuilder)Commands.func_197056_a("facingEntity", EntityArgument.func_197086_a()).executes(p_198806_0_ -> TeleportCommand.func_200559_a((CommandSource)p_198806_0_.getSource(), EntityArgument.func_197097_b((CommandContext)p_198806_0_, (String)"targets"), ((CommandSource)p_198806_0_.getSource()).func_197023_e(), Vec3Argument.func_200385_b((CommandContext)p_198806_0_, (String)"location"), null, new Facing(EntityArgument.func_197088_a((CommandContext)p_198806_0_, (String)"facingEntity"), EntityAnchorArgument.Type.FEET)))).then(Commands.func_197056_a("facingAnchor", EntityAnchorArgument.func_201024_a()).executes(p_198812_0_ -> TeleportCommand.func_200559_a((CommandSource)p_198812_0_.getSource(), EntityArgument.func_197097_b((CommandContext)p_198812_0_, (String)"targets"), ((CommandSource)p_198812_0_.getSource()).func_197023_e(), Vec3Argument.func_200385_b((CommandContext)p_198812_0_, (String)"location"), null, new Facing(EntityArgument.func_197088_a((CommandContext)p_198812_0_, (String)"facingEntity"), EntityAnchorArgument.func_201023_a((CommandContext)p_198812_0_, (String)"facingAnchor")))))))).then(Commands.func_197056_a("facingLocation", Vec3Argument.func_197301_a()).executes(p_198805_0_ -> TeleportCommand.func_200559_a((CommandSource)p_198805_0_.getSource(), EntityArgument.func_197097_b((CommandContext)p_198805_0_, (String)"targets"), ((CommandSource)p_198805_0_.getSource()).func_197023_e(), Vec3Argument.func_200385_b((CommandContext)p_198805_0_, (String)"location"), null, new Facing(Vec3Argument.func_197300_a((CommandContext)p_198805_0_, (String)"facingLocation")))))))).then(Commands.func_197056_a("destination", EntityArgument.func_197086_a()).executes(p_198814_0_ -> TeleportCommand.func_201126_a((CommandSource)p_198814_0_.getSource(), EntityArgument.func_197097_b((CommandContext)p_198814_0_, (String)"targets"), EntityArgument.func_197088_a((CommandContext)p_198814_0_, (String)"destination")))))).then(Commands.func_197056_a("location", Vec3Argument.func_197301_a()).executes(p_200560_0_ -> TeleportCommand.func_200559_a((CommandSource)p_200560_0_.getSource(), Collections.singleton(((CommandSource)p_200560_0_.getSource()).func_197027_g()), ((CommandSource)p_200560_0_.getSource()).func_197023_e(), Vec3Argument.func_200385_b((CommandContext)p_200560_0_, (String)"location"), (ILocationArgument)LocationInput.func_200383_d(), null)))).then(Commands.func_197056_a("destination", EntityArgument.func_197086_a()).executes(p_200562_0_ -> TeleportCommand.func_201126_a((CommandSource)p_200562_0_.getSource(), Collections.singleton(((CommandSource)p_200562_0_.getSource()).func_197027_g()), EntityArgument.func_197088_a((CommandContext)p_200562_0_, (String)"destination")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("tp").requires(p_200556_0_ -> p_200556_0_.func_197034_c(2))).redirect((CommandNode)literalcommandnode));
    }

    private static int func_201126_a(CommandSource source, Collection<? extends Entity> targets, Entity destination) {
        for (Entity entity : targets) {
            TeleportCommand.func_201127_a(source, entity, (ServerWorld)destination.field_70170_p, destination.func_226277_ct_(), destination.func_226278_cu_(), destination.func_226281_cx_(), EnumSet.noneOf(SPlayerPositionLookPacket.Flags.class), destination.field_70177_z, destination.field_70125_A, null);
        }
        if (targets.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.teleport.success.entity.single", targets.iterator().next().func_145748_c_(), destination.func_145748_c_()), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.teleport.success.entity.multiple", targets.size(), destination.func_145748_c_()), true);
        }
        return targets.size();
    }

    private static int func_200559_a(CommandSource source, Collection<? extends Entity> targets, ServerWorld worldIn, ILocationArgument position, @Nullable ILocationArgument rotationIn, @Nullable Facing facing) throws CommandSyntaxException {
        Vec3d vec3d = position.func_197281_a(source);
        Vec2f vec2f = rotationIn == null ? null : rotationIn.func_197282_b(source);
        EnumSet<SPlayerPositionLookPacket.Flags> set = EnumSet.noneOf(SPlayerPositionLookPacket.Flags.class);
        if (position.func_200380_a()) {
            set.add(SPlayerPositionLookPacket.Flags.X);
        }
        if (position.func_200381_b()) {
            set.add(SPlayerPositionLookPacket.Flags.Y);
        }
        if (position.func_200382_c()) {
            set.add(SPlayerPositionLookPacket.Flags.Z);
        }
        if (rotationIn == null) {
            set.add(SPlayerPositionLookPacket.Flags.X_ROT);
            set.add(SPlayerPositionLookPacket.Flags.Y_ROT);
        } else {
            if (rotationIn.func_200380_a()) {
                set.add(SPlayerPositionLookPacket.Flags.X_ROT);
            }
            if (rotationIn.func_200381_b()) {
                set.add(SPlayerPositionLookPacket.Flags.Y_ROT);
            }
        }
        for (Entity entity : targets) {
            if (rotationIn == null) {
                TeleportCommand.func_201127_a(source, entity, worldIn, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, set, entity.field_70177_z, entity.field_70125_A, facing);
                continue;
            }
            TeleportCommand.func_201127_a(source, entity, worldIn, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, set, vec2f.field_189983_j, vec2f.field_189982_i, facing);
        }
        if (targets.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.teleport.success.location.single", targets.iterator().next().func_145748_c_(), vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.teleport.success.location.multiple", targets.size(), vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c), true);
        }
        return targets.size();
    }

    private static void func_201127_a(CommandSource source, Entity entityIn, ServerWorld worldIn, double x, double y, double z, Set<SPlayerPositionLookPacket.Flags> relativeList, float yaw, float pitch, @Nullable Facing facing) {
        if (entityIn instanceof ServerPlayerEntity) {
            ChunkPos chunkpos = new ChunkPos(new BlockPos(x, y, z));
            worldIn.func_72863_F().func_217228_a(TicketType.field_223185_g, chunkpos, 1, (Object)entityIn.func_145782_y());
            entityIn.func_184210_p();
            if (((ServerPlayerEntity)entityIn).func_70608_bn()) {
                ((ServerPlayerEntity)entityIn).func_225652_a_(true, true);
            }
            if (worldIn == entityIn.field_70170_p) {
                ((ServerPlayerEntity)entityIn).field_71135_a.func_175089_a(x, y, z, yaw, pitch, relativeList);
            } else {
                ((ServerPlayerEntity)entityIn).func_200619_a(worldIn, x, y, z, yaw, pitch);
            }
            entityIn.func_70034_d(yaw);
        } else {
            float f1 = MathHelper.func_76142_g((float)yaw);
            float f = MathHelper.func_76142_g((float)pitch);
            f = MathHelper.func_76131_a((float)f, (float)-90.0f, (float)90.0f);
            if (worldIn == entityIn.field_70170_p) {
                entityIn.func_70012_b(x, y, z, f1, f);
                entityIn.func_70034_d(f1);
            } else {
                entityIn.func_213319_R();
                entityIn.field_71093_bK = worldIn.field_73011_w.func_186058_p();
                Entity entity = entityIn;
                entityIn = entityIn.func_200600_R().func_200721_a(worldIn);
                if (entityIn == null) {
                    return;
                }
                entityIn.func_180432_n(entity);
                entityIn.func_70012_b(x, y, z, f1, f);
                entityIn.func_70034_d(f1);
                worldIn.func_217460_e(entityIn);
            }
        }
        if (facing != null) {
            facing.func_201124_a(source, entityIn);
        }
        if (!(entityIn instanceof LivingEntity) || !((LivingEntity)entityIn).func_184613_cA()) {
            entityIn.func_213317_d(entityIn.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            entityIn.field_70122_E = true;
        }
    }

    static class Facing {
        private final Vec3d field_200549_a;
        private final Entity field_200550_b;
        private final EntityAnchorArgument.Type field_201125_c;

        public Facing(Entity entityIn, EntityAnchorArgument.Type anchorIn) {
            this.field_200550_b = entityIn;
            this.field_201125_c = anchorIn;
            this.field_200549_a = anchorIn.func_201017_a(entityIn);
        }

        public Facing(Vec3d positionIn) {
            this.field_200550_b = null;
            this.field_200549_a = positionIn;
            this.field_201125_c = null;
        }

        public void func_201124_a(CommandSource source, Entity entityIn) {
            if (this.field_200550_b != null) {
                if (entityIn instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)entityIn).func_200618_a(source.func_201008_k(), this.field_200550_b, this.field_201125_c);
                } else {
                    entityIn.func_200602_a(source.func_201008_k(), this.field_200549_a);
                }
            } else {
                entityIn.func_200602_a(source.func_201008_k(), this.field_200549_a);
            }
        }
    }
}

