/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.FluidBlockRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.ForgeBlockModelRenderer;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;

@OnlyIn(value=Dist.CLIENT)
public class BlockRendererDispatcher
implements IResourceManagerReloadListener {
    private final BlockModelShapes field_175028_a;
    private final BlockModelRenderer field_175027_c;
    private final FluidBlockRenderer field_175025_e;
    private final Random field_195476_e = new Random();
    private final BlockColors field_228790_e_;

    public BlockRendererDispatcher(BlockModelShapes shapes, BlockColors colors) {
        this.field_175028_a = shapes;
        this.field_228790_e_ = colors;
        this.field_175027_c = new ForgeBlockModelRenderer(this.field_228790_e_);
        this.field_175025_e = new FluidBlockRenderer();
    }

    public BlockModelShapes func_175023_a() {
        return this.field_175028_a;
    }

    @Deprecated
    public void func_228792_a_(BlockState blockStateIn, BlockPos posIn, ILightReader lightReaderIn, MatrixStack matrixStackIn, IVertexBuilder vertexBuilderIn) {
        this.renderModel(blockStateIn, posIn, lightReaderIn, matrixStackIn, vertexBuilderIn, (IModelData)EmptyModelData.INSTANCE);
    }

    public void renderModel(BlockState blockStateIn, BlockPos posIn, ILightReader lightReaderIn, MatrixStack matrixStackIn, IVertexBuilder vertexBuilderIn, IModelData modelData) {
        if (blockStateIn.func_185901_i() == BlockRenderType.MODEL) {
            IBakedModel ibakedmodel = this.field_175028_a.func_178125_b(blockStateIn);
            long i = blockStateIn.func_209533_a(posIn);
            this.field_175027_c.renderModel(lightReaderIn, ibakedmodel, blockStateIn, posIn, matrixStackIn, vertexBuilderIn, true, this.field_195476_e, i, OverlayTexture.field_229196_a_, modelData);
        }
    }

    @Deprecated
    public boolean func_228793_a_(BlockState blockStateIn, BlockPos posIn, ILightReader lightReaderIn, MatrixStack matrixStackIn, IVertexBuilder vertexBuilderIn, boolean checkSides, Random rand) {
        return this.renderModel(blockStateIn, posIn, lightReaderIn, matrixStackIn, vertexBuilderIn, checkSides, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderModel(BlockState blockStateIn, BlockPos posIn, ILightReader lightReaderIn, MatrixStack matrixStackIn, IVertexBuilder vertexBuilderIn, boolean checkSides, Random rand, IModelData modelData) {
        try {
            BlockRenderType blockrendertype = blockStateIn.func_185901_i();
            return blockrendertype != BlockRenderType.MODEL ? false : this.field_175027_c.renderModel(lightReaderIn, this.func_184389_a(blockStateIn), blockStateIn, posIn, matrixStackIn, vertexBuilderIn, checkSides, rand, blockStateIn.func_209533_a(posIn), OverlayTexture.field_229196_a_, modelData);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_175750_a(crashreportcategory, posIn, blockStateIn);
            throw new ReportedException(crashreport);
        }
    }

    public boolean func_228794_a_(BlockPos posIn, ILightReader lightReaderIn, IVertexBuilder vertexBuilderIn, IFluidState fluidStateIn) {
        try {
            return this.field_175025_e.func_228796_a_(lightReaderIn, posIn, vertexBuilderIn, fluidStateIn);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Tesselating liquid in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_175750_a(crashreportcategory, posIn, null);
            throw new ReportedException(crashreport);
        }
    }

    public BlockModelRenderer func_175019_b() {
        return this.field_175027_c;
    }

    public IBakedModel func_184389_a(BlockState state) {
        return this.field_175028_a.func_178125_b(state);
    }

    @Deprecated
    public void func_228791_a_(BlockState blockStateIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferTypeIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderBlock(blockStateIn, matrixStackIn, bufferTypeIn, combinedLightIn, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
    }

    public void renderBlock(BlockState blockStateIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferTypeIn, int combinedLightIn, int combinedOverlayIn, IModelData modelData) {
        BlockRenderType blockrendertype = blockStateIn.func_185901_i();
        if (blockrendertype != BlockRenderType.INVISIBLE) {
            switch (blockrendertype) {
                case MODEL: {
                    IBakedModel ibakedmodel = this.func_184389_a(blockStateIn);
                    int i = this.field_228790_e_.func_228054_a_(blockStateIn, null, null, 0);
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    this.field_175027_c.renderModel(matrixStackIn.func_227866_c_(), bufferTypeIn.getBuffer(RenderTypeLookup.func_228394_b_(blockStateIn)), blockStateIn, ibakedmodel, f, f1, f2, combinedLightIn, combinedOverlayIn, modelData);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack(blockStateIn.func_177230_c());
                    stack.func_77973_b().getItemStackTileEntityRenderer().func_228364_a_(stack, matrixStackIn, bufferTypeIn, combinedLightIn, combinedOverlayIn);
                }
            }
        }
    }

    @Override
    public void func_195410_a(IResourceManager resourceManager) {
        this.field_175025_e.func_178268_a();
    }

    @Override
    public IResourceType getResourceType() {
        return VanillaResourceType.MODELS;
    }
}

