/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import javax.annotation.Nullable;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.SettingsScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.OptionButton;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.settings.AbstractOption;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.resource.VanillaResourceType;

@OnlyIn(value=Dist.CLIENT)
public class LanguageScreen
extends SettingsScreen {
    private List field_146450_f;
    private final LanguageManager field_146454_h;
    private OptionButton field_211832_i;
    private Button field_146452_r;

    public LanguageScreen(Screen screen, GameSettings gameSettingsObj, LanguageManager manager) {
        super(screen, gameSettingsObj, (ITextComponent)new TranslationTextComponent("options.language", new Object[0]));
        this.field_146454_h = manager;
    }

    protected void init() {
        this.field_146450_f = new List(this.minecraft);
        this.children.add(this.field_146450_f);
        this.field_211832_i = (OptionButton)this.addButton((Widget)new OptionButton(this.width / 2 - 155, this.height - 38, 150, 20, (AbstractOption)AbstractOption.field_216684_H, AbstractOption.field_216684_H.func_216743_c(this.field_228183_b_), p_213037_1_ -> {
            AbstractOption.field_216684_H.func_216740_a(this.field_228183_b_);
            this.field_228183_b_.func_74303_b();
            p_213037_1_.setMessage(AbstractOption.field_216684_H.func_216743_c(this.field_228183_b_));
            this.minecraft.func_213226_a();
        }));
        this.field_146452_r = (Button)this.addButton((Widget)new Button(this.width / 2 - 155 + 160, this.height - 38, 150, 20, I18n.func_135052_a("gui.done", new Object[0]), p_213036_1_ -> {
            List.LanguageEntry languagescreen$list$languageentry = (List.LanguageEntry)((Object)((Object)this.field_146450_f.getSelected()));
            if (languagescreen$list$languageentry != null && !languagescreen$list$languageentry.field_214398_b.getCode().equals(this.field_146454_h.func_135041_c().getCode())) {
                this.field_146454_h.func_135045_a(languagescreen$list$languageentry.field_214398_b);
                this.field_228183_b_.field_74363_ab = languagescreen$list$languageentry.field_214398_b.getCode();
                ForgeHooksClient.refreshResources((Minecraft)this.minecraft, (VanillaResourceType[])new VanillaResourceType[]{VanillaResourceType.LANGUAGES});
                this.font.func_78275_b(this.field_146454_h.func_135044_b());
                this.field_146452_r.setMessage(I18n.func_135052_a("gui.done", new Object[0]));
                this.field_211832_i.setMessage(AbstractOption.field_216684_H.func_216743_c(this.field_228183_b_));
                this.field_228183_b_.func_74303_b();
            }
            this.minecraft.func_147108_a(this.field_228182_a_);
        }));
        super.init();
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.field_146450_f.render(p_render_1_, p_render_2_, p_render_3_);
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 16, 0xFFFFFF);
        this.drawCenteredString(this.font, "(" + I18n.func_135052_a("options.languageWarning", new Object[0]) + ")", this.width / 2, this.height - 56, 0x808080);
        super.render(p_render_1_, p_render_2_, p_render_3_);
    }

    @OnlyIn(value=Dist.CLIENT)
    class List
    extends ExtendedList<LanguageEntry> {
        public List(Minecraft mcIn) {
            super(mcIn, LanguageScreen.this.width, LanguageScreen.this.height, 32, LanguageScreen.this.height - 65 + 4, 18);
            for (Language language : LanguageScreen.this.field_146454_h.func_135040_d()) {
                LanguageEntry languagescreen$list$languageentry = new LanguageEntry(language);
                this.addEntry((AbstractList.AbstractListEntry)((Object)languagescreen$list$languageentry));
                if (!LanguageScreen.this.field_146454_h.func_135041_c().getCode().equals(language.getCode())) continue;
                this.setSelected(languagescreen$list$languageentry);
            }
            if (this.getSelected() != null) {
                this.centerScrollOn(this.getSelected());
            }
        }

        protected int getScrollbarPosition() {
            return super.getScrollbarPosition() + 20;
        }

        public int getRowWidth() {
            return super.getRowWidth() + 50;
        }

        public void setSelected(@Nullable LanguageEntry p_setSelected_1_) {
            super.setSelected((AbstractList.AbstractListEntry)((Object)p_setSelected_1_));
            if (p_setSelected_1_ != null) {
                NarratorChatListener.field_193643_a.func_216864_a(new TranslationTextComponent("narrator.select", p_setSelected_1_.field_214398_b).getString());
            }
        }

        protected void renderBackground() {
            LanguageScreen.this.renderBackground();
        }

        protected boolean isFocused() {
            return LanguageScreen.this.getFocused() == this;
        }

        @OnlyIn(value=Dist.CLIENT)
        public class LanguageEntry
        extends ExtendedList.AbstractListEntry<LanguageEntry> {
            private final Language field_214398_b;

            public LanguageEntry(Language p_i50494_2_) {
                this.field_214398_b = p_i50494_2_;
            }

            public void render(int p_render_1_, int p_render_2_, int p_render_3_, int p_render_4_, int p_render_5_, int p_render_6_, int p_render_7_, boolean p_render_8_, float p_render_9_) {
                LanguageScreen.this.font.func_78275_b(true);
                List.this.drawCenteredString(LanguageScreen.this.font, this.field_214398_b.toString(), List.this.width / 2, p_render_2_ + 1, 0xFFFFFF);
                LanguageScreen.this.font.func_78275_b(LanguageScreen.this.field_146454_h.func_135041_c().func_135035_b());
            }

            public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                if (p_mouseClicked_5_ == 0) {
                    this.func_214395_a();
                    return true;
                }
                return false;
            }

            private void func_214395_a() {
                List.this.setSelected(this);
            }
        }
    }
}

