/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.MovingPistonBlock;
import net.minecraft.block.PistonBlockStructureHelper;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.PistonType;
import net.minecraft.tileentity.PistonTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class PistonBlock
extends DirectionalBlock {
    public static final BooleanProperty field_176320_b = BlockStateProperties.field_208181_h;
    protected static final VoxelShape field_185648_b = Block.func_208617_a(0.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    protected static final VoxelShape field_185649_c = Block.func_208617_a(4.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185650_d = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 12.0);
    protected static final VoxelShape field_185651_e = Block.func_208617_a(0.0, 0.0, 4.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185652_f = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);
    protected static final VoxelShape field_185653_g = Block.func_208617_a(0.0, 4.0, 0.0, 16.0, 16.0, 16.0);
    private final boolean field_150082_a;

    public PistonBlock(boolean sticky, Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176387_N, (Comparable)((Object)Direction.NORTH)))).func_206870_a((IProperty)field_176320_b, Boolean.valueOf(false))));
        this.field_150082_a = sticky;
    }

    public boolean func_229869_c_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)field_176320_b) == false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (((Boolean)state.func_177229_b((IProperty)field_176320_b)).booleanValue()) {
            switch ((Direction)((Object)state.func_177229_b((IProperty)field_176387_N))) {
                case DOWN: {
                    return field_185653_g;
                }
                default: {
                    return field_185652_f;
                }
                case NORTH: {
                    return field_185651_e;
                }
                case SOUTH: {
                    return field_185650_d;
                }
                case WEST: {
                    return field_185649_c;
                }
                case EAST: 
            }
            return field_185648_b;
        }
        return VoxelShapes.func_197868_b();
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            this.func_176316_e(worldIn, pos, state);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            this.func_176316_e(worldIn, pos, state);
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c() && !worldIn.field_72995_K && worldIn.func_175625_s(pos) == null) {
            this.func_176316_e(worldIn, pos, state);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((Object)((BlockState)((Object)this.func_176223_P().func_206870_a((IProperty)field_176387_N, (Comparable)((Object)context.func_196010_d().func_176734_d())))).func_206870_a((IProperty)field_176320_b, Boolean.valueOf(false)));
    }

    private void func_176316_e(World worldIn, BlockPos pos, BlockState state) {
        Direction direction = (Direction)((Object)state.func_177229_b((IProperty)field_176387_N));
        boolean flag = this.func_176318_b(worldIn, pos, direction);
        if (flag && !((Boolean)state.func_177229_b((IProperty)field_176320_b)).booleanValue()) {
            if (new PistonBlockStructureHelper(worldIn, pos, direction, true).func_177253_a()) {
                worldIn.func_175641_c(pos, (Block)((Object)this), 0, direction.func_176745_a());
            }
        } else if (!flag && ((Boolean)state.func_177229_b((IProperty)field_176320_b)).booleanValue()) {
            PistonTileEntity pistontileentity;
            TileEntity tileentity;
            BlockPos blockpos = pos.func_177967_a(direction, 2);
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            int i = 1;
            if (blockstate.func_177230_c() == Blocks.field_196603_bb && blockstate.func_177229_b((IProperty)field_176387_N) == direction && (tileentity = worldIn.func_175625_s(blockpos)) instanceof PistonTileEntity && (pistontileentity = (PistonTileEntity)tileentity).func_145868_b() && (pistontileentity.func_145860_a(0.0f) < 0.5f || worldIn.func_82737_E() == pistontileentity.func_211146_k() || ((ServerWorld)worldIn).func_211158_j_())) {
                i = 2;
            }
            worldIn.func_175641_c(pos, (Block)((Object)this), i, direction.func_176745_a());
        }
    }

    private boolean func_176318_b(World worldIn, BlockPos pos, Direction facing) {
        for (Direction direction : Direction.values()) {
            if (direction == facing || !worldIn.func_175709_b(pos.func_177972_a(direction), direction)) continue;
            return true;
        }
        if (worldIn.func_175709_b(pos, Direction.DOWN)) {
            return true;
        }
        BlockPos blockpos = pos.func_177984_a();
        for (Direction direction1 : Direction.values()) {
            if (direction1 == Direction.DOWN || !worldIn.func_175709_b(blockpos.func_177972_a(direction1), direction1)) continue;
            return true;
        }
        return false;
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        Direction direction = (Direction)((Object)state.func_177229_b((IProperty)field_176387_N));
        if (!worldIn.field_72995_K) {
            boolean flag = this.func_176318_b(worldIn, pos, direction);
            if (flag && (id == 1 || id == 2)) {
                worldIn.func_180501_a(pos, (BlockState)((Object)state.func_206870_a((IProperty)field_176320_b, Boolean.valueOf(true))), 2);
                return false;
            }
            if (!flag && id == 0) {
                return false;
            }
        }
        if (id == 0) {
            if (ForgeEventFactory.onPistonMovePre((World)worldIn, (BlockPos)pos, (Direction)direction, (boolean)true)) {
                return false;
            }
            if (!this.func_176319_a(worldIn, pos, direction, true)) {
                return false;
            }
            worldIn.func_180501_a(pos, (BlockState)((Object)state.func_206870_a((IProperty)field_176320_b, Boolean.valueOf(true))), 67);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.25f + 0.6f);
        } else if (id == 1 || id == 2) {
            if (ForgeEventFactory.onPistonMovePre((World)worldIn, (BlockPos)pos, (Direction)direction, (boolean)false)) {
                return false;
            }
            TileEntity tileentity1 = worldIn.func_175625_s(pos.func_177972_a(direction));
            if (tileentity1 instanceof PistonTileEntity) {
                ((PistonTileEntity)tileentity1).func_145866_f();
            }
            worldIn.func_180501_a(pos, (BlockState)((Object)((BlockState)((Object)Blocks.field_196603_bb.func_176223_P().func_206870_a((IProperty)MovingPistonBlock.field_196344_a, (Comparable)((Object)direction)))).func_206870_a((IProperty)MovingPistonBlock.field_196345_b, (Comparable)(this.field_150082_a ? PistonType.STICKY : PistonType.DEFAULT))), 3);
            worldIn.func_175690_a(pos, MovingPistonBlock.func_196343_a((BlockState)((Object)this.func_176223_P().func_206870_a((IProperty)field_176387_N, (Comparable)((Object)Direction.func_82600_a(param & 7)))), direction, false, true));
            if (this.field_150082_a) {
                PistonTileEntity pistontileentity;
                TileEntity tileentity;
                BlockPos blockpos = pos.func_177982_a(direction.func_82601_c() * 2, direction.func_96559_d() * 2, direction.func_82599_e() * 2);
                BlockState blockstate = worldIn.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                boolean flag1 = false;
                if (block == Blocks.field_196603_bb && (tileentity = worldIn.func_175625_s(blockpos)) instanceof PistonTileEntity && (pistontileentity = (PistonTileEntity)tileentity).func_212363_d() == direction && pistontileentity.func_145868_b()) {
                    pistontileentity.func_145866_f();
                    flag1 = true;
                }
                if (!flag1) {
                    if (id != 1 || blockstate.isAir((IBlockReader)((Object)worldIn), blockpos) || !PistonBlock.func_185646_a(blockstate, worldIn, blockpos, direction.func_176734_d(), false, direction) || blockstate.func_185905_o() != PushReaction.NORMAL && block != Blocks.field_150331_J && block != Blocks.field_150320_F) {
                        worldIn.func_217377_a(pos.func_177972_a(direction), false);
                    } else {
                        this.func_176319_a(worldIn, pos, direction, false);
                    }
                }
            } else {
                worldIn.func_217377_a(pos.func_177972_a(direction), false);
            }
            worldIn.func_184133_a(null, pos, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.15f + 0.6f);
        }
        ForgeEventFactory.onPistonMovePost((World)worldIn, (BlockPos)pos, (Direction)direction, (id == 0 ? 1 : 0) != 0);
        return true;
    }

    public static boolean func_185646_a(BlockState blockStateIn, World worldIn, BlockPos pos, Direction facing, boolean destroyBlocks, Direction p_185646_5_) {
        Block block = blockStateIn.func_177230_c();
        if (block == Blocks.field_150343_Z) {
            return false;
        }
        if (!worldIn.func_175723_af().func_177746_a(pos)) {
            return false;
        }
        if (pos.func_177956_o() >= 0 && (facing != Direction.DOWN || pos.func_177956_o() != 0)) {
            if (pos.func_177956_o() <= worldIn.func_217301_I() - 1 && (facing != Direction.UP || pos.func_177956_o() != worldIn.func_217301_I() - 1)) {
                if (block != Blocks.field_150331_J && block != Blocks.field_150320_F) {
                    if (blockStateIn.func_185887_b((IBlockReader)((Object)worldIn), pos) == -1.0f) {
                        return false;
                    }
                    switch (blockStateIn.func_185905_o()) {
                        case BLOCK: {
                            return false;
                        }
                        case DESTROY: {
                            return destroyBlocks;
                        }
                        case PUSH_ONLY: {
                            return facing == p_185646_5_;
                        }
                    }
                } else if (((Boolean)blockStateIn.func_177229_b((IProperty)field_176320_b)).booleanValue()) {
                    return false;
                }
                return !blockStateIn.hasTileEntity();
            }
            return false;
        }
        return false;
    }

    private boolean func_176319_a(World worldIn, BlockPos pos, Direction directionIn, boolean extending) {
        PistonBlockStructureHelper pistonblockstructurehelper;
        BlockPos blockpos = pos.func_177972_a(directionIn);
        if (!extending && worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150332_K) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 20);
        }
        if (!(pistonblockstructurehelper = new PistonBlockStructureHelper(worldIn, pos, directionIn, extending)).func_177253_a()) {
            return false;
        }
        HashMap map = Maps.newHashMap();
        List<BlockPos> list = pistonblockstructurehelper.func_177254_c();
        ArrayList list1 = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            BlockPos blockpos1 = list.get(i);
            BlockState blockstate = worldIn.func_180495_p(blockpos1);
            list1.add(blockstate);
            map.put(blockpos1, blockstate);
        }
        List<BlockPos> list2 = pistonblockstructurehelper.func_177252_d();
        int k = list.size() + list2.size();
        BlockState[] ablockstate = new BlockState[k];
        Direction direction = extending ? directionIn : directionIn.func_176734_d();
        for (int j = list2.size() - 1; j >= 0; --j) {
            BlockPos blockpos2 = list2.get(j);
            BlockState blockState = worldIn.func_180495_p(blockpos2);
            TileEntity tileentity = blockState.hasTileEntity() ? worldIn.func_175625_s(blockpos2) : null;
            PistonBlock.func_220059_a((BlockState)blockState, (World)worldIn, (BlockPos)blockpos2, (TileEntity)tileentity);
            worldIn.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 18);
            ablockstate[--k] = blockState;
        }
        for (int l = list.size() - 1; l >= 0; --l) {
            BlockPos blockpos3 = list.get(l);
            BlockState blockState = worldIn.func_180495_p(blockpos3);
            blockpos3 = blockpos3.func_177972_a(direction);
            map.remove(blockpos3);
            worldIn.func_180501_a(blockpos3, (BlockState)((Object)Blocks.field_196603_bb.func_176223_P().func_206870_a((IProperty)field_176387_N, (Comparable)((Object)directionIn))), 68);
            worldIn.func_175690_a(blockpos3, MovingPistonBlock.func_196343_a((BlockState)((Object)list1.get(l)), directionIn, extending, false));
            ablockstate[--k] = blockState;
        }
        if (extending) {
            PistonType pistontype = this.field_150082_a ? PistonType.STICKY : PistonType.DEFAULT;
            BlockState blockstate4 = (BlockState)((Object)((BlockState)((Object)Blocks.field_150332_K.func_176223_P().func_206870_a((IProperty)PistonHeadBlock.field_176387_N, (Comparable)((Object)directionIn)))).func_206870_a((IProperty)PistonHeadBlock.field_176325_b, (Comparable)pistontype));
            BlockState blockState = (BlockState)((Object)((BlockState)((Object)Blocks.field_196603_bb.func_176223_P().func_206870_a((IProperty)MovingPistonBlock.field_196344_a, (Comparable)((Object)directionIn)))).func_206870_a((IProperty)MovingPistonBlock.field_196345_b, (Comparable)(this.field_150082_a ? PistonType.STICKY : PistonType.DEFAULT)));
            map.remove(blockpos);
            worldIn.func_180501_a(blockpos, blockState, 68);
            worldIn.func_175690_a(blockpos, MovingPistonBlock.func_196343_a(blockstate4, directionIn, true, true));
        }
        BlockState blockstate3 = Blocks.field_150350_a.func_176223_P();
        for (BlockPos blockPos : map.keySet()) {
            worldIn.func_180501_a(blockPos, blockstate3, 82);
        }
        for (Map.Entry entry : map.entrySet()) {
            BlockPos blockpos5 = (BlockPos)entry.getKey();
            BlockState blockstate2 = (BlockState)((Object)entry.getValue());
            blockstate2.func_196948_b(worldIn, blockpos5, 2);
            blockstate3.func_196946_a(worldIn, blockpos5, 2);
            blockstate3.func_196948_b(worldIn, blockpos5, 2);
        }
        for (int i1 = list2.size() - 1; i1 >= 0; --i1) {
            BlockState blockState = ablockstate[k++];
            BlockPos blockpos6 = list2.get(i1);
            blockState.func_196948_b(worldIn, blockpos6, 2);
            worldIn.func_195593_d(blockpos6, blockState.func_177230_c());
        }
        for (int j1 = list.size() - 1; j1 >= 0; --j1) {
            worldIn.func_195593_d(list.get(j1), ablockstate[k++].func_177230_c());
        }
        if (extending) {
            worldIn.func_195593_d(blockpos, Blocks.field_150332_K);
        }
        return true;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)((Object)state.func_206870_a((IProperty)field_176387_N, (Comparable)((Object)rot.func_185831_a((Direction)((Object)state.func_177229_b((IProperty)field_176387_N))))));
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return (Boolean)state.func_177229_b((IProperty)field_176320_b) != false ? state : super.rotate(state, world, pos, direction);
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)((Object)state.func_177229_b((IProperty)field_176387_N))));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176387_N, field_176320_b});
    }

    public boolean func_220074_n(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)field_176320_b);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

