/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import java.util.Random;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.CitySphere;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.Condition;
import mcjty.lostcities.worldgen.lost.cityassets.ConditionContext;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ChunkFixer {
    private static void generateTrees(Random random, int chunkX, int chunkZ, IWorld world, IDimensionInfo provider) {
        BuildingInfo info = BuildingInfo.getBuildingInfo(chunkX, chunkZ, provider);
        for (BlockPos pos : info.getSaplingTodo()) {
            BlockState state = world.func_180495_p(pos);
            if (!(state.func_177230_c() instanceof SaplingBlock)) continue;
        }
        info.clearSaplingTodo();
    }

    private static void generateVines(Random random, int chunkX, int chunkZ, IWorld world, IDimensionInfo provider) {
        int x;
        int y;
        int z;
        int bottom;
        BuildingInfo adjacent;
        float vineChance = provider.getProfile().VINE_CHANCE;
        if ((double)vineChance < 1.0E-6) {
            return;
        }
        int cx = chunkX * 16;
        int cz = chunkZ * 16;
        BuildingInfo info = BuildingInfo.getBuildingInfo(chunkX, chunkZ, provider);
        int maxHeight = info.getMaxHeight();
        if (info.hasBuilding && world.func_212866_a_(chunkX + 1, chunkZ).func_201589_g().func_209003_a(ChunkStatus.field_222613_i)) {
            adjacent = info.getXmax();
            bottom = Math.max(adjacent.getCityGroundLevel() + 3, adjacent.hasBuilding ? adjacent.getMaxHeight() : adjacent.getCityGroundLevel() + 3);
            for (z = 0; z < 15; ++z) {
                for (y = bottom; y < maxHeight; ++y) {
                    if (!(world.func_201674_k().nextFloat() < vineChance)) continue;
                    ChunkFixer.createVineStrip(world, bottom, VineBlock.field_176280_O, new BlockPos(cx + 16, y, cz + z), new BlockPos(cx + 15, y, cz + z));
                }
            }
        }
        if (info.getXmax().hasBuilding && world.func_212866_a_(chunkX + 1, chunkZ).func_201589_g().func_209003_a(ChunkStatus.field_222613_i)) {
            adjacent = info.getXmax();
            bottom = Math.max(info.getCityGroundLevel() + 3, info.hasBuilding ? maxHeight : info.getCityGroundLevel() + 3);
            for (z = 0; z < 15; ++z) {
                for (y = bottom; y < adjacent.getMaxHeight(); ++y) {
                    if (!(world.func_201674_k().nextFloat() < vineChance)) continue;
                    ChunkFixer.createVineStrip(world, bottom, VineBlock.field_176278_M, new BlockPos(cx + 15, y, cz + z), new BlockPos(cx + 16, y, cz + z));
                }
            }
        }
        if (info.hasBuilding && world.func_212866_a_(chunkX, chunkZ + 1).func_201589_g().func_209003_a(ChunkStatus.field_222613_i)) {
            adjacent = info.getZmax();
            bottom = Math.max(adjacent.getCityGroundLevel() + 3, adjacent.hasBuilding ? adjacent.getMaxHeight() : adjacent.getCityGroundLevel() + 3);
            for (x = 0; x < 15; ++x) {
                for (y = bottom; y < maxHeight; ++y) {
                    if (!(world.func_201674_k().nextFloat() < vineChance)) continue;
                    ChunkFixer.createVineStrip(world, bottom, VineBlock.field_176273_b, new BlockPos(cx + x, y, cz + 16), new BlockPos(cx + x, y, cz + 15));
                }
            }
        }
        if (info.getZmax().hasBuilding && world.func_212866_a_(chunkX, chunkZ + 1).func_201589_g().func_209003_a(ChunkStatus.field_222613_i)) {
            adjacent = info.getZmax();
            bottom = Math.max(info.getCityGroundLevel() + 3, info.hasBuilding ? maxHeight : info.getCityGroundLevel() + 3);
            for (x = 0; x < 15; ++x) {
                for (y = bottom; y < adjacent.getMaxHeight(); ++y) {
                    if (!(world.func_201674_k().nextFloat() < vineChance)) continue;
                    ChunkFixer.createVineStrip(world, bottom, VineBlock.field_176279_N, new BlockPos(cx + x, y, cz + 15), new BlockPos(cx + x, y, cz + 16));
                }
            }
        }
    }

    private static void createVineStrip(IWorld world, int bottom, BooleanProperty direction, BlockPos pos, BlockPos vineHolderPos) {
        if (world.func_175623_d(vineHolderPos)) {
            return;
        }
        if (!world.func_175623_d(pos)) {
            return;
        }
        BlockState state = (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)direction, (Comparable)Boolean.valueOf(true));
        world.func_180501_a(pos, state, 0);
        pos = pos.func_177977_b();
        while (pos.func_177956_o() >= bottom && world.func_201674_k().nextFloat() < 0.8f) {
            if (!world.func_175623_d(pos)) {
                return;
            }
            world.func_180501_a(pos, state, 0);
            pos = pos.func_177977_b();
        }
    }

    private static void generateLootSpawners(Random random, final int chunkX, final int chunkZ, final IWorld world, final IDimensionInfo diminfo) {
        BlockState state;
        BlockPos pos;
        BuildingInfo info = BuildingInfo.getBuildingInfo(chunkX, chunkZ, diminfo);
        for (Pair<BlockPos, BuildingInfo.ConditionTodo> pair : info.getMobSpawnerTodo()) {
            pos = (BlockPos)pair.getKey();
            state = world.func_180495_p(pos);
            world.func_180501_a(pos, state, 3);
            if (state.func_177230_c() != Blocks.field_150474_ac) continue;
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof MobSpawnerTileEntity) {
                int floor;
                MobSpawnerTileEntity spawner = (MobSpawnerTileEntity)tileentity;
                BuildingInfo.ConditionTodo todo = (BuildingInfo.ConditionTodo)pair.getValue();
                String condition = todo.getCondition();
                Condition cnd = AssetRegistries.CONDITIONS.get(condition);
                if (cnd == null) {
                    throw new RuntimeException("Cannot find condition '" + condition + "'!");
                }
                int level = (pos.func_177956_o() - diminfo.getProfile().GROUNDLEVEL) / 6;
                ConditionContext conditionContext = new ConditionContext(level, floor = (pos.func_177956_o() - info.getCityGroundLevel()) / 6, info.floorsBelowGround, info.getNumFloors(), todo.getPart(), todo.getBuilding(), info.chunkX, info.chunkZ){

                    @Override
                    public boolean isSphere() {
                        return CitySphere.isInSphere(chunkX, chunkZ, pos, diminfo);
                    }

                    @Override
                    public ResourceLocation getBiome() {
                        return world.func_226691_t_(pos).getRegistryName();
                    }
                };
                String randomValue = cnd.getRandomValue(random, conditionContext);
                if (randomValue == null) {
                    throw new RuntimeException("Condition '" + cnd.getName() + "' did not return a valid mob!");
                }
                AbstractSpawner logic = spawner.func_145881_a();
                logic.func_200876_a((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(randomValue)));
                spawner.func_70296_d();
                if (!LostCityConfiguration.DEBUG) continue;
                LostCities.setup.getLogger().debug("generateLootSpawners: mob=" + randomValue + " pos=" + pos.toString());
                continue;
            }
            if (tileentity != null) {
                LostCities.setup.getLogger().error("The mob spawner at (" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ") has a TileEntity of incorrect type " + tileentity.getClass().getName() + "!");
                continue;
            }
            LostCities.setup.getLogger().error("The mob spawner at (" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ") is missing its TileEntity!");
        }
        info.clearMobSpawnerTodo();
        for (Pair<BlockPos, BuildingInfo.ConditionTodo> pair : info.getLootTodo()) {
            Block block;
            pos = (BlockPos)pair.getKey();
            state = world.func_180495_p(pos);
            world.func_180501_a(pos, state, 3);
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof LockableLootTileEntity) {
                if (!diminfo.getProfile().GENERATE_LOOT) continue;
                ChunkFixer.createLoot(info, random, world, pos, (BuildingInfo.ConditionTodo)pair.getRight(), diminfo);
                continue;
            }
            if (te != null || !(block = state.func_177230_c()).hasTileEntity(state)) continue;
            LostCities.setup.getLogger().error("The block " + block.getRegistryName() + " (" + block.getClass().getName() + ") at (" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ") is missing its TileEntity!");
        }
        info.clearLootTodo();
    }

    private static void createLoot(final BuildingInfo info, Random random, final IWorld world, final BlockPos pos, BuildingInfo.ConditionTodo todo, final IDimensionInfo diminfo) {
        if (random.nextFloat() < diminfo.getProfile().CHEST_WITHOUT_LOOT_CHANCE) {
            return;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof LockableLootTileEntity && todo != null) {
            String lootTable = todo.getCondition();
            int level = (pos.func_177956_o() - diminfo.getProfile().GROUNDLEVEL) / 6;
            int floor = (pos.func_177956_o() - info.getCityGroundLevel()) / 6;
            ConditionContext conditionContext = new ConditionContext(level, floor, info.floorsBelowGround, info.getNumFloors(), todo.getPart(), todo.getBuilding(), info.chunkX, info.chunkZ){

                @Override
                public boolean isSphere() {
                    return CitySphere.isInSphere(info.chunkX, info.chunkZ, pos, diminfo);
                }

                @Override
                public ResourceLocation getBiome() {
                    return world.func_226691_t_(pos).getRegistryName();
                }
            };
            String randomValue = AssetRegistries.CONDITIONS.get(lootTable).getRandomValue(random, conditionContext);
            if (randomValue == null) {
                throw new RuntimeException("Condition '" + lootTable + "' did not return a table under certain conditions!");
            }
            LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)random, (BlockPos)pos, (ResourceLocation)new ResourceLocation(randomValue));
        }
    }

    public static void fix(IDimensionInfo info, int chunkX, int chunkZ) {
        ChunkFixer.generateTrees(info.getRandom(), chunkX, chunkZ, info.getWorld(), info);
        ChunkFixer.generateVines(info.getRandom(), chunkX, chunkZ, info.getWorld(), info);
        ChunkFixer.generateLootSpawners(info.getRandom(), chunkX, chunkZ, info.getWorld(), info);
    }
}

