/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.config.BiomeSelectionStrategy;
import mcjty.lostcities.config.LostCityConfiguration;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeTranslator {
    private final String[] allowedBiomeFactors;
    private final String[] manualBiomeMappings;
    private final BiomeSelectionStrategy strategy;
    private final Map<ResourceLocation, Biome> translationMap = new HashMap<ResourceLocation, Biome>();

    public BiomeTranslator(String[] allowedBiomeFactors, String[] manualBiomeMappings, BiomeSelectionStrategy strategy) {
        for (String s : allowedBiomeFactors) {
            if (s.indexOf(61) != -1) continue;
            throw new IllegalArgumentException("Biome factor missing equals sign: " + s);
        }
        this.allowedBiomeFactors = allowedBiomeFactors;
        for (String s : manualBiomeMappings) {
            if (s.indexOf(61) != -1) continue;
            throw new IllegalArgumentException("Biome mapping missing equals sign: " + s);
        }
        this.manualBiomeMappings = manualBiomeMappings;
        this.strategy = strategy;
    }

    private static List<Pair<ResourceLocation, Biome>> parseManualBiomes(String[] manualBiomeMappings) {
        ArrayList<Pair<ResourceLocation, Biome>> mapping = new ArrayList<Pair<ResourceLocation, Biome>>();
        for (String s : manualBiomeMappings) {
            String[] split = StringUtils.split((String)s, (char)'=');
            String biomeId = split[0];
            String destBiomeId = split[1];
            Biome biome = BiomeTranslator.findBiome(biomeId);
            Biome destBiome = BiomeTranslator.findBiome(destBiomeId);
            if (biome != null && destBiome != null) {
                mapping.add((Pair<ResourceLocation, Biome>)Pair.of((Object)biome.getRegistryName(), (Object)destBiome));
                continue;
            }
            if (biome == null) {
                LostCities.setup.getLogger().warn("Could not find biome '" + biomeId + "'!");
                continue;
            }
            if (destBiome != null) continue;
            LostCities.setup.getLogger().warn("Could not find biome '" + destBiomeId + "'!");
        }
        return mapping;
    }

    public static List<Pair<Float, Biome>> parseBiomes(String[] allowedBiomeFactors) {
        ArrayList<Pair<Float, Biome>> biomes = new ArrayList<Pair<Float, Biome>>();
        for (String s : allowedBiomeFactors) {
            String[] split = StringUtils.split((String)s, (char)'=');
            float f = Float.parseFloat(split[1]);
            String biomeId = split[0];
            Biome biome = BiomeTranslator.findBiome(biomeId);
            if (biome != null) {
                biomes.add((Pair<Float, Biome>)Pair.of((Object)Float.valueOf(f), (Object)biome));
                continue;
            }
            LostCities.setup.getLogger().warn("Could not find biome '" + biomeId + "'!");
        }
        return biomes;
    }

    private static Biome findBiome(String biomeId) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeId));
        return biome;
    }

    private void dumpTranslationMap() {
        LostCities.setup.getLogger().info("Dumping biome mapping");
        for (Map.Entry<ResourceLocation, Biome> entry : this.translationMap.entrySet()) {
            ResourceLocation biomeKey = ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)entry.getValue());
            LostCities.setup.getLogger().info("biome: " + entry.getKey() + " -> " + entry.getValue().func_210773_k() + " (" + biomeKey.toString() + ")");
        }
    }

    private void generateTranslationMapOriginal(List<Pair<Float, Biome>> biomes) {
        for (Biome biome : ForgeRegistries.BIOMES) {
            Biome bestFit = null;
            double bestDist = 1.0E9;
            for (Pair<Float, Biome> pair : biomes) {
                Biome b = (Biome)pair.getRight();
                double distance = BiomeTranslator.calculateBiomeDistance(biome, b) * (double)((Float)pair.getLeft()).floatValue();
                if (!(distance < bestDist)) continue;
                bestDist = distance;
                bestFit = b;
            }
            if (bestFit == null) {
                bestFit = Biomes.field_76772_c;
            }
            this.translationMap.put(biome.getRegistryName(), bestFit);
        }
    }

    private void generateTranslationMapNG(List<Pair<Float, Biome>> biomes, float samenessFactor) {
        for (Biome biome : ForgeRegistries.BIOMES) {
            ArrayList<Biome> bestFit = new ArrayList<Biome>();
            double bestDist = 1.0E9;
            for (Pair<Float, Biome> pair : biomes) {
                Biome b = (Biome)pair.getRight();
                double distance = BiomeTranslator.calculateBiomeDistance(biome, b) * (double)((Float)pair.getLeft()).floatValue();
                if (Math.abs(distance - bestDist) < (double)samenessFactor) {
                    bestFit.add(b);
                    continue;
                }
                if (!(distance < bestDist)) continue;
                bestDist = distance;
                bestFit.clear();
                bestFit.add(b);
            }
            if (bestFit.isEmpty()) {
                bestFit.add(Biomes.field_76772_c);
            }
            if (bestFit.size() == 1) {
                this.translationMap.put(biome.getRegistryName(), (Biome)bestFit.get(0));
                continue;
            }
            long seed = biome.getRegistryName().hashCode();
            Random random = new Random(seed);
            random.nextFloat();
            random.nextFloat();
            this.translationMap.put(biome.getRegistryName(), (Biome)bestFit.get(random.nextInt(bestFit.size())));
        }
    }

    public Biome translate(Biome biome) {
        if (this.translationMap.isEmpty()) {
            List<Pair<Float, Biome>> biomes = BiomeTranslator.parseBiomes(this.allowedBiomeFactors);
            switch (this.strategy) {
                case ORIGINAL: {
                    this.generateTranslationMapOriginal(biomes);
                    break;
                }
                case RANDOMIZED: {
                    this.generateTranslationMapNG(biomes, 0.2f);
                    break;
                }
                case VARIED: {
                    this.generateTranslationMapNG(biomes, 1.0f);
                }
            }
            List<Pair<ResourceLocation, Biome>> manualMappings = BiomeTranslator.parseManualBiomes(this.manualBiomeMappings);
            for (Pair<ResourceLocation, Biome> pair : manualMappings) {
                this.translationMap.put((ResourceLocation)pair.getKey(), (Biome)pair.getValue());
            }
            if (LostCityConfiguration.DEBUG) {
                this.dumpTranslationMap();
            }
        }
        return this.translationMap.get(biome.getRegistryName());
    }

    private static double calculateBiomeDistance(Biome a, Biome b) {
        if (a == b) {
            return -1000.0;
        }
        float dt = a.func_185353_n() - b.func_185353_n();
        return 0.0;
    }
}

