/*
 * Decompiled with CFR 0.152.
 */
package com.nothome.delta;

import com.nothome.delta.ByteBufferSeekableSource;
import com.nothome.delta.PatchException;
import com.nothome.delta.RandomAccessFileSeekableSource;
import com.nothome.delta.SeekableSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class GDiffPatcher {
    private ByteBuffer buf = ByteBuffer.allocate(1024);
    private byte[] buf2 = this.buf.array();

    public void patch(File sourceFile, File patchFile, File outputFile) throws IOException {
        RandomAccessFileSeekableSource source = new RandomAccessFileSeekableSource(new RandomAccessFile(sourceFile, "r"));
        FileInputStream patch = new FileInputStream(patchFile);
        FileOutputStream output = new FileOutputStream(outputFile);
        try {
            this.patch(source, (InputStream)patch, (OutputStream)output);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            source.close();
            ((InputStream)patch).close();
            ((OutputStream)output).close();
        }
    }

    public void patch(byte[] source, InputStream patch, OutputStream output) throws IOException {
        this.patch(new ByteBufferSeekableSource(source), patch, output);
    }

    public byte[] patch(byte[] source, byte[] patch) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.patch(source, (InputStream)new ByteArrayInputStream(patch), (OutputStream)os);
        return os.toByteArray();
    }

    public void patch(SeekableSource source, InputStream patch, OutputStream out) throws IOException {
        int command;
        DataOutputStream outOS = new DataOutputStream(out);
        DataInputStream patchIS = new DataInputStream(patch);
        if (patchIS.readUnsignedByte() != 209 || patchIS.readUnsignedByte() != 255 || patchIS.readUnsignedByte() != 209 || patchIS.readUnsignedByte() != 255 || patchIS.readUnsignedByte() != 4) {
            throw new PatchException("magic string not found, aborting!");
        }
        block11: while ((command = patchIS.readUnsignedByte()) != 0) {
            if (command <= 246) {
                this.append(command, patchIS, outOS);
                continue;
            }
            switch (command) {
                case 247: {
                    int length = patchIS.readUnsignedShort();
                    this.append(length, patchIS, outOS);
                    continue block11;
                }
                case 248: {
                    int length = patchIS.readInt();
                    this.append(length, patchIS, outOS);
                    continue block11;
                }
                case 249: {
                    int offset = patchIS.readUnsignedShort();
                    int length = patchIS.readUnsignedByte();
                    this.copy(offset, length, source, outOS);
                    continue block11;
                }
                case 250: {
                    int offset = patchIS.readUnsignedShort();
                    int length = patchIS.readUnsignedShort();
                    this.copy(offset, length, source, outOS);
                    continue block11;
                }
                case 251: {
                    int offset = patchIS.readUnsignedShort();
                    int length = patchIS.readInt();
                    this.copy(offset, length, source, outOS);
                    continue block11;
                }
                case 252: {
                    int offset = patchIS.readInt();
                    int length = patchIS.readUnsignedByte();
                    this.copy(offset, length, source, outOS);
                    continue block11;
                }
                case 253: {
                    int offset = patchIS.readInt();
                    int length = patchIS.readUnsignedShort();
                    this.copy(offset, length, source, outOS);
                    continue block11;
                }
                case 254: {
                    int offset = patchIS.readInt();
                    int length = patchIS.readInt();
                    this.copy(offset, length, source, outOS);
                    continue block11;
                }
                case 255: {
                    long loffset = patchIS.readLong();
                    int length = patchIS.readInt();
                    this.copy(loffset, length, source, outOS);
                    continue block11;
                }
            }
            throw new IllegalStateException("command " + command);
        }
        outOS.flush();
    }

    private void copy(long offset, int length, SeekableSource source, OutputStream output) throws IOException {
        source.seek(offset);
        while (length > 0) {
            int len = Math.min(this.buf.capacity(), length);
            this.buf.clear().limit(len);
            int res = source.read(this.buf);
            if (res == -1) {
                throw new EOFException("in copy " + offset + " " + length);
            }
            output.write(this.buf.array(), 0, res);
            length -= res;
        }
    }

    private void append(int length, InputStream patch, OutputStream output) throws IOException {
        while (length > 0) {
            int len = Math.min(this.buf2.length, length);
            int res = patch.read(this.buf2, 0, len);
            if (res == -1) {
                throw new EOFException("cannot read " + length);
            }
            output.write(this.buf2, 0, res);
            length -= res;
        }
    }

    public static void main(String[] argv) {
        if (argv.length != 3) {
            System.err.println("usage GDiffPatch source patch output");
            System.err.println("aborting..");
            return;
        }
        try {
            File sourceFile = new File(argv[0]);
            File patchFile = new File(argv[1]);
            File outputFile = new File(argv[2]);
            if (sourceFile.length() > Integer.MAX_VALUE || patchFile.length() > Integer.MAX_VALUE) {
                System.err.println("source or patch is too large, max length is 2147483647");
                System.err.println("aborting..");
                return;
            }
            GDiffPatcher patcher = new GDiffPatcher();
            patcher.patch(sourceFile, patchFile, outputFile);
            System.out.println("finished patching file");
        }
        catch (Exception ioe) {
            System.err.println("error while patching: " + ioe);
        }
    }
}

