/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.classloader;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import sun.misc.Unsafe;

public class ClassLoaderUtils {
    public static final String URL_CLASS_LOADER_CLASS = "java.net.URLClassLoader";
    public static final String BUILTIN_CLASS_LOADER_CLASS = "jdk.internal.loader.BuiltinClassLoader";
    public static final String URL_CLASS_PATH_CLASS = "jdk.internal.loader.URLClassPath";

    public static void appendToClassPath(URL url) throws Throwable {
        ClassLoaderUtils.appendToClassPath(ClassLoaderUtils.class.getClassLoader(), url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendToClassPath(ClassLoader classLoader, URL url) throws Throwable {
        block9: {
            Class<?> classLoaderClass2;
            try {
                classLoaderClass2 = Class.forName(URL_CLASS_LOADER_CLASS);
                if (classLoaderClass2.isInstance(classLoader)) {
                    Method addURLMethod = classLoaderClass2.getDeclaredMethod("addURL", URL.class);
                    addURLMethod.setAccessible(true);
                    addURLMethod.invoke((Object)classLoader, url);
                    return;
                }
            }
            catch (ClassNotFoundException classLoaderClass2) {
                // empty catch block
            }
            try {
                Collection urls;
                classLoaderClass2 = Class.forName(BUILTIN_CLASS_LOADER_CLASS);
                Class<?> classPathClass = Class.forName(URL_CLASS_PATH_CLASS);
                if (!classLoaderClass2.isInstance(classLoader)) break block9;
                Unsafe unsafe = ClassLoaderUtils.getUnsafe();
                Field ucpField = classLoaderClass2.getDeclaredField("ucp");
                long ucpFieldOffset = unsafe.objectFieldOffset(ucpField);
                Object ucpObject = unsafe.getObject(classLoader, ucpFieldOffset);
                Field pathField = classPathClass.getDeclaredField("path");
                long pathFieldOffset = unsafe.objectFieldOffset(pathField);
                ArrayList path = (ArrayList)unsafe.getObject(ucpObject, pathFieldOffset);
                Field urlsField = ClassLoaderUtils.getField(classPathClass.getDeclaredFields(), "urls", "unopenedUrls");
                long urlsFieldOffset = unsafe.objectFieldOffset(urlsField);
                Collection collection = urls = (Collection)unsafe.getObject(ucpObject, urlsFieldOffset);
                synchronized (collection) {
                    if (!path.contains(url)) {
                        urls.add(url);
                        path.add(url);
                    }
                }
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new UnsupportedOperationException("Unsupported ClassLoader");
    }

    public static URL[] getSystemClassPathURLs() throws Throwable {
        return ClassLoaderUtils.getSystemClassPathURLs(ClassLoaderUtils.class.getClassLoader());
    }

    public static URL[] getSystemClassPathURLs(ClassLoader classLoader) throws Throwable {
        Class<?> classLoaderClass2;
        Objects.requireNonNull(classLoader, "ClassLoader cannot be null");
        try {
            classLoaderClass2 = Class.forName(URL_CLASS_LOADER_CLASS);
            if (classLoaderClass2.isInstance(classLoader)) {
                Method getURLsMethod = classLoaderClass2.getMethod("getURLs", new Class[0]);
                return (URL[])getURLsMethod.invoke((Object)classLoader, new Object[0]);
            }
        }
        catch (ClassNotFoundException classLoaderClass2) {
            // empty catch block
        }
        try {
            classLoaderClass2 = Class.forName(BUILTIN_CLASS_LOADER_CLASS);
            if (classLoaderClass2.isInstance(classLoader)) {
                Unsafe unsafe = ClassLoaderUtils.getUnsafe();
                Field ucpField = classLoaderClass2.getDeclaredField("ucp");
                long ucpFieldOffset = unsafe.objectFieldOffset(ucpField);
                Object ucpObject = unsafe.getObject(classLoader, ucpFieldOffset);
                Field pathField = ucpField.getType().getDeclaredField("path");
                long pathFieldOffset = unsafe.objectFieldOffset(pathField);
                ArrayList path = (ArrayList)unsafe.getObject(ucpObject, pathFieldOffset);
                return path.toArray(new URL[0]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new UnsupportedOperationException("Unsupported ClassLoader");
    }

    private static Field getField(Field[] fields, String ... names) throws NoSuchFieldException {
        for (Field field : fields) {
            for (String name : names) {
                if (!field.getName().equals(name)) continue;
                return field;
            }
        }
        throw new NoSuchFieldException(String.join((CharSequence)", ", names));
    }

    private static Unsafe getUnsafe() throws Throwable {
        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
        unsafeField.setAccessible(true);
        return (Unsafe)unsafeField.get(null);
    }
}

