/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.client;

import com.google.common.collect.Lists;
import gigaherz.toolbelt.BeltFinder;
import gigaherz.toolbelt.ConfigData;
import gigaherz.toolbelt.ToolBelt;
import gigaherz.toolbelt.client.ClientEvents;
import gigaherz.toolbelt.client.radial.GenericRadialMenu;
import gigaherz.toolbelt.client.radial.IRadialMenuHost;
import gigaherz.toolbelt.client.radial.ItemStackRadialMenuItem;
import gigaherz.toolbelt.client.radial.RadialMenuItem;
import gigaherz.toolbelt.client.radial.TextRadialMenuItem;
import gigaherz.toolbelt.network.SwapItems;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RadialMenuScreen
extends Screen {
    private final BeltFinder.BeltGetter getter;
    private ItemStack stackEquipped;
    private IItemHandler inventory;
    private boolean keyCycleBeforeL = false;
    private boolean keyCycleBeforeR = false;
    private boolean needsRecheckStacks = true;
    private final List<ItemStackRadialMenuItem> cachedMenuItems = Lists.newArrayList();
    private final TextRadialMenuItem insertMenuItem;
    private final GenericRadialMenu menu;

    private ItemRenderer getItemRenderer() {
        return this.itemRenderer;
    }

    public RadialMenuScreen(BeltFinder.BeltGetter getter) {
        super((ITextComponent)new StringTextComponent("RADIAL MENU"));
        this.getter = getter;
        this.stackEquipped = getter.getBelt();
        this.inventory = this.stackEquipped.func_190916_E() > 0 ? (IItemHandler)this.stackEquipped.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(null) : null;
        this.menu = new GenericRadialMenu(Minecraft.func_71410_x(), new IRadialMenuHost(){

            @Override
            public Screen getScreen() {
                return RadialMenuScreen.this;
            }

            @Override
            public FontRenderer getFontRenderer() {
                return RadialMenuScreen.this.font;
            }

            @Override
            public ItemRenderer getItemRenderer() {
                return RadialMenuScreen.this.getItemRenderer();
            }
        }){

            @Override
            public void onClickOutside() {
                this.close();
            }
        };
        this.insertMenuItem = new TextRadialMenuItem(this.menu, (ITextComponent)new TranslationTextComponent("text.toolbelt.insert", new Object[0])){

            @Override
            public boolean onClick() {
                return RadialMenuScreen.this.trySwap(-1, ItemStack.field_190927_a);
            }
        };
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof RadialMenuScreen) {
            event.setCanceled(true);
        }
    }

    public void removed() {
        super.removed();
        ClientEvents.wipeOpen();
    }

    public void tick() {
        super.tick();
        this.menu.tick();
        if (this.menu.isClosed()) {
            Minecraft.func_71410_x().func_147108_a(null);
            ClientEvents.wipeOpen();
        }
        if (!this.menu.isReady() || this.inventory == null) {
            return;
        }
        ItemStack inHand = this.minecraft.field_71439_g.func_184614_ca();
        if (!ConfigData.isItemStackAllowed(inHand)) {
            this.inventory = null;
        } else {
            ItemStack stack = this.getter.getBelt();
            if (stack.func_190916_E() <= 0) {
                this.inventory = null;
                this.stackEquipped = null;
            } else if (this.stackEquipped != stack) {
                this.stackEquipped = stack;
                this.inventory = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(() -> new RuntimeException("No inventory?"));
                this.needsRecheckStacks = true;
            }
        }
        if (this.inventory == null) {
            Minecraft.func_71410_x().func_147108_a(null);
        } else if (!InputMappings.func_216506_a((long)this.minecraft.func_228018_at_().func_198092_i(), (int)ClientEvents.OPEN_TOOL_MENU_KEYBIND.getKey().func_197937_c())) {
            if (ConfigData.releaseToSwap) {
                this.processClick(false);
            } else {
                this.menu.close();
            }
        }
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.processClick(true);
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    protected void processClick(boolean triggeredByMouse) {
        this.menu.clickItem();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (this.inventory == null) {
            return;
        }
        ItemStack inHand = this.minecraft.field_71439_g.func_184614_ca();
        if (!ConfigData.isItemStackAllowed(inHand)) {
            return;
        }
        if (this.needsRecheckStacks) {
            this.cachedMenuItems.clear();
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack inSlot = this.inventory.getStackInSlot(i);
                ItemStackRadialMenuItem item = new ItemStackRadialMenuItem(this.menu, i, inSlot, (ITextComponent)new TranslationTextComponent("text.toolbelt.empty", new Object[0])){

                    @Override
                    public boolean onClick() {
                        return RadialMenuScreen.this.trySwap(this.getSlot(), this.getStack());
                    }
                };
                item.setVisible(inSlot.func_190916_E() > 0 || ConfigData.displayEmptySlots);
                if (inHand.func_190916_E() > 0) {
                    if (inSlot.func_190916_E() > 0) {
                        item.setCentralText((ITextComponent)new TranslationTextComponent("text.toolbelt.swap", new Object[0]));
                    } else {
                        item.setCentralText((ITextComponent)new TranslationTextComponent("text.toolbelt.insert", new Object[0]));
                    }
                } else if (inSlot.func_190916_E() > 0) {
                    item.setCentralText((ITextComponent)new TranslationTextComponent("text.toolbelt.extract", new Object[0]));
                } else {
                    item.setCentralText((ITextComponent)new TranslationTextComponent("text.toolbelt.empty", new Object[0]));
                }
                this.cachedMenuItems.add(item);
            }
            this.menu.clear();
            this.menu.addAll(this.cachedMenuItems);
            this.menu.add(this.insertMenuItem);
            this.needsRecheckStacks = false;
        }
        boolean hasAddButton = false;
        if (!ConfigData.displayEmptySlots && !this.cachedMenuItems.stream().allMatch(RadialMenuItem::isVisible) && inHand.func_190916_E() > 0) {
            hasAddButton = true;
        }
        this.insertMenuItem.setVisible(hasAddButton);
        if (this.cachedMenuItems.stream().noneMatch(RadialMenuItem::isVisible)) {
            this.menu.setCentralText((ITextComponent)new TranslationTextComponent("text.toolbelt.empty", new Object[0]));
        } else {
            this.menu.setCentralText(null);
        }
        this.checkCycleKeybinds();
        this.menu.draw(partialTicks, mouseX, mouseY);
    }

    private boolean trySwap(int slotNumber, ItemStack itemMouseOver) {
        ItemStack inHand = this.minecraft.field_71439_g.func_184614_ca();
        if (!ConfigData.isItemStackAllowed(inHand)) {
            return false;
        }
        if (inHand.func_190916_E() > 0 || itemMouseOver.func_190916_E() > 0) {
            SwapItems.swapItem(slotNumber, (PlayerEntity)this.minecraft.field_71439_g);
            ToolBelt.channel.sendToServer((Object)new SwapItems(slotNumber));
        }
        this.menu.close();
        return true;
    }

    private void checkCycleKeybinds() {
        if (ClientEvents.isKeyDown(ClientEvents.CYCLE_TOOL_MENU_LEFT_KEYBIND)) {
            if (!this.keyCycleBeforeL) {
                this.menu.cyclePrevious();
            }
            this.keyCycleBeforeL = true;
        } else {
            this.keyCycleBeforeL = false;
        }
        if (ClientEvents.isKeyDown(ClientEvents.CYCLE_TOOL_MENU_RIGHT_KEYBIND)) {
            if (!this.keyCycleBeforeR) {
                this.menu.cycleNext();
            }
            this.keyCycleBeforeR = true;
        } else {
            this.keyCycleBeforeR = false;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

