/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.ServerProxy;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.citadel.client.model.TabulaModelHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientProxy
extends ServerProxy {
    private static final ResourceLocation CITADEL_TEXTURE = new ResourceLocation("citadel", "textures/citadel_model.png");
    private static final ResourceLocation CITADEL_GLOW_TEXTURE = new ResourceLocation("citadel", "textures/citadel_model_glow.png");
    private static SegmentedModel CITADEL_MODEL;

    @Override
    public void onPreInit() {
        try {
            CITADEL_MODEL = new TabulaModel(TabulaModelHandler.INSTANCE.loadTabulaModel("/assets/citadel/models/citadel_model"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void playerRender(RenderPlayerEvent.Post event) {
        MatrixStack matrixStackIn = event.getMatrixStack();
        String username = event.getPlayer().func_200200_C_().func_150261_e();
        if (Citadel.PATREONS.contains(username)) {
            IVertexBuilder textureBuilder = event.getBuffers().getBuffer(RenderType.func_228640_c_((ResourceLocation)CITADEL_TEXTURE));
            float tick = (float)(event.getEntity().field_70173_aa - 1) + event.getPartialRenderTick();
            float bob = (float)(Math.sin(tick * 0.1f) * 1.0 * (double)0.05f - (double)0.05f);
            float scale = 0.4f;
            float rotation = MathHelper.func_76142_g((float)(tick % 360.0f));
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
            matrixStackIn.func_227861_a_(0.0, (double)(event.getEntity().func_213302_cg() + bob), (double)(event.getEntity().func_213311_cf() + 1.75f + bob * 5.0f));
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation * 10.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(75.0f));
            matrixStackIn.func_227862_a_(scale, scale, scale);
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            CITADEL_MODEL.func_225598_a_(matrixStackIn, textureBuilder, event.getLight(), OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227865_b_();
        }
    }

    @Override
    public void handleAnimationPacket(int entityId, int index) {
        IAnimatedEntity entity;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (entity = (IAnimatedEntity)player.field_70170_p.func_73045_a(entityId)) != null) {
            if (index == -1) {
                entity.setAnimation(IAnimatedEntity.NO_ANIMATION);
            } else {
                entity.setAnimation(entity.getAnimations()[index]);
            }
            entity.setAnimationTick(0);
        }
    }
}

