/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.network.pipe.fluid;

import com.raoulvdberge.refinedpipes.RefinedPipes;
import com.raoulvdberge.refinedpipes.message.FluidPipeMessage;
import com.raoulvdberge.refinedpipes.network.fluid.FluidNetwork;
import com.raoulvdberge.refinedpipes.network.pipe.Pipe;
import com.raoulvdberge.refinedpipes.network.pipe.fluid.FluidPipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FluidPipe
extends Pipe {
    public static final ResourceLocation ID = new ResourceLocation("refinedpipes", "fluid");
    private final FluidPipeType type;
    private float lastFullness = 0.0f;

    public FluidPipe(World world, BlockPos pos, FluidPipeType type) {
        super(world, pos);
        this.type = type;
    }

    @Override
    public void update() {
        super.update();
        float f = this.getFullness();
        if ((double)Math.abs(this.lastFullness - f) >= 0.1) {
            this.lastFullness = f;
            this.sendFluidPipeUpdate();
        }
    }

    public void sendFluidPipeUpdate() {
        RefinedPipes.NETWORK.sendInArea(this.world, this.pos, 32, new FluidPipeMessage(this.pos, ((FluidNetwork)this.network).getFluidTank().getFluid(), this.getFullness()));
    }

    public float getFullness() {
        int cap = ((FluidNetwork)this.network).getFluidTank().getCapacity();
        int stored = ((FluidNetwork)this.network).getFluidTank().getFluidAmount();
        return (float)Math.round((float)stored / (float)cap * 10.0f) / 10.0f;
    }

    public FluidPipeType getType() {
        return this.type;
    }

    @Override
    public CompoundNBT writeToNbt(CompoundNBT tag) {
        tag = super.writeToNbt(tag);
        tag.func_74768_a("type", this.type.ordinal());
        return tag;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public ResourceLocation getNetworkType() {
        return this.type.getNetworkType();
    }
}

