/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.network.pipe;

import com.raoulvdberge.refinedpipes.network.Network;
import com.raoulvdberge.refinedpipes.network.pipe.attachment.Attachment;
import com.raoulvdberge.refinedpipes.network.pipe.attachment.ServerAttachmentManager;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Pipe {
    private final Logger logger = LogManager.getLogger(this.getClass());
    protected final World world;
    protected final BlockPos pos;
    protected final ServerAttachmentManager attachmentManager = new ServerAttachmentManager(this);
    protected Network network;

    public Pipe(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public void update() {
        for (Attachment attachment : this.attachmentManager.getAttachments()) {
            attachment.update();
        }
    }

    public ServerAttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Network getNetwork() {
        return this.network;
    }

    public void joinNetwork(Network network) {
        this.network = network;
        this.logger.debug(this.pos + " joined network " + network.getId());
        this.sendBlockUpdate();
    }

    public void leaveNetwork() {
        this.logger.debug(this.pos + " left network " + this.network.getId());
        this.network = null;
        this.sendBlockUpdate();
    }

    public void sendBlockUpdate() {
        BlockState state = this.world.func_180495_p(this.pos);
        this.world.func_184138_a(this.pos, state, state, 3);
    }

    public CompoundNBT writeToNbt(CompoundNBT tag) {
        tag.func_74772_a("pos", this.pos.func_218275_a());
        this.attachmentManager.writeToNbt(tag);
        return tag;
    }

    public abstract ResourceLocation getId();

    public abstract ResourceLocation getNetworkType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pipe pipe = (Pipe)o;
        return this.world.equals(pipe.world) && this.pos.equals((Object)pipe.pos);
    }

    public int hashCode() {
        return Objects.hash(this.world, this.pos);
    }
}

