/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.function.Consumer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ILootEntry;
import net.minecraft.world.storage.loot.ILootGenerator;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.ValidationTracker;
import net.minecraft.world.storage.loot.conditions.ILootCondition;

public abstract class ParentedLootEntry
extends LootEntry {
    protected final LootEntry[] field_216147_c;
    private final ILootEntry field_216148_e;

    protected ParentedLootEntry(LootEntry[] lootEntryArray, ILootCondition[] iLootConditionArray) {
        super(iLootConditionArray);
        this.field_216147_c = lootEntryArray;
        this.field_216148_e = this.func_216146_a(lootEntryArray);
    }

    @Override
    public void func_225579_a_(ValidationTracker validationTracker) {
        super.func_225579_a_(validationTracker);
        if (this.field_216147_c.length == 0) {
            validationTracker.func_227530_a_("Empty children list");
        }
        for (int i = 0; i < this.field_216147_c.length; ++i) {
            this.field_216147_c[i].func_225579_a_(validationTracker.func_227534_b_(".entry[" + i + "]"));
        }
    }

    protected abstract ILootEntry func_216146_a(ILootEntry[] var1);

    @Override
    public final boolean expand(LootContext lootContext, Consumer<ILootGenerator> consumer) {
        if (!this.func_216141_a(lootContext)) {
            return false;
        }
        return this.field_216148_e.expand(lootContext, consumer);
    }

    public static <T extends ParentedLootEntry> AbstractSerializer<T> func_216145_a(ResourceLocation resourceLocation, Class<T> clazz, final IFactory<T> iFactory) {
        return new AbstractSerializer<T>(resourceLocation, clazz){

            @Override
            protected T func_216186_a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootEntry[] lootEntryArray, ILootCondition[] iLootConditionArray) {
                return iFactory.create(lootEntryArray, iLootConditionArray);
            }
        };
    }

    public static abstract class AbstractSerializer<T extends ParentedLootEntry>
    extends LootEntry.Serializer<T> {
        public AbstractSerializer(ResourceLocation resourceLocation, Class<T> clazz) {
            super(resourceLocation, clazz);
        }

        @Override
        public void func_212830_a_(JsonObject jsonObject, T t, JsonSerializationContext jsonSerializationContext) {
            jsonObject.add("children", jsonSerializationContext.serialize((Object)((ParentedLootEntry)t).field_216147_c));
        }

        @Override
        public final T func_212865_b_(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            LootEntry[] lootEntryArray = JSONUtils.func_188174_a(jsonObject, "children", jsonDeserializationContext, LootEntry[].class);
            return this.func_216186_a(jsonObject, jsonDeserializationContext, lootEntryArray, iLootConditionArray);
        }

        protected abstract T func_216186_a(JsonObject var1, JsonDeserializationContext var2, LootEntry[] var3, ILootCondition[] var4);

        @Override
        public /* synthetic */ LootEntry func_212865_b_(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            return this.func_212865_b_(jsonObject, jsonDeserializationContext, iLootConditionArray);
        }
    }

    @FunctionalInterface
    public static interface IFactory<T extends ParentedLootEntry> {
        public T create(LootEntry[] var1, ILootCondition[] var2);
    }
}

