/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTables;

public class IglooPieces {
    private static final ResourceLocation field_202592_e = new ResourceLocation("igloo/top");
    private static final ResourceLocation field_202593_f = new ResourceLocation("igloo/middle");
    private static final ResourceLocation field_202594_g = new ResourceLocation("igloo/bottom");
    private static final Map<ResourceLocation, BlockPos> field_207621_d = ImmutableMap.of((Object)field_202592_e, (Object)new BlockPos(3, 5, 5), (Object)field_202593_f, (Object)new BlockPos(1, 3, 1), (Object)field_202594_g, (Object)new BlockPos(3, 6, 7));
    private static final Map<ResourceLocation, BlockPos> field_207622_e = ImmutableMap.of((Object)field_202592_e, (Object)BlockPos.field_177992_a, (Object)field_202593_f, (Object)new BlockPos(2, -3, 4), (Object)field_202594_g, (Object)new BlockPos(0, -3, -2));

    public static void func_207617_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation, List<StructurePiece> list2, Random random, NoFeatureConfig noFeatureConfig) {
        List<StructurePiece> list2;
        if (random.nextDouble() < 0.5) {
            int n = random.nextInt(8) + 4;
            list2.add(new Piece(templateManager, field_202594_g, blockPos, rotation, n * 3));
            for (\u2603 = 0; \u2603 < n - 1; ++\u2603) {
                list2.add(new Piece(templateManager, field_202593_f, blockPos, rotation, \u2603 * 3));
            }
        }
        list2.add(new Piece(templateManager, field_202592_e, blockPos, rotation, 0));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation field_207615_d;
        private final Rotation field_207616_e;

        public Piece(TemplateManager templateManager, ResourceLocation resourceLocation, BlockPos blockPos, Rotation rotation, int n) {
            super(IStructurePieceType.field_214764_K, 0);
            this.field_207615_d = resourceLocation;
            BlockPos blockPos2 = (BlockPos)field_207622_e.get(resourceLocation);
            this.field_186178_c = blockPos.func_177982_a(blockPos2.func_177958_n(), blockPos2.func_177956_o() - n, blockPos2.func_177952_p());
            this.field_207616_e = rotation;
            this.func_207614_a(templateManager);
        }

        public Piece(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214764_K, compoundNBT);
            this.field_207615_d = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.field_207616_e = Rotation.valueOf(compoundNBT.func_74779_i("Rot"));
            this.func_207614_a(templateManager);
        }

        private void func_207614_a(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.field_207615_d);
            PlacementSettings \u26032 = new PlacementSettings().func_186220_a(this.field_207616_e).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)field_207621_d.get(this.field_207615_d)).func_215222_a(BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, \u26032);
        }

        @Override
        protected void func_143011_b(CompoundNBT compoundNBT) {
            super.func_143011_b(compoundNBT);
            compoundNBT.func_74778_a("Template", this.field_207615_d.toString());
            compoundNBT.func_74778_a("Rot", this.field_207616_e.name());
        }

        @Override
        protected void func_186175_a(String string, BlockPos blockPos, IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox) {
            if (!"chest".equals(string)) {
                return;
            }
            iWorld.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 3);
            TileEntity tileEntity = iWorld.func_175625_s(blockPos.func_177977_b());
            if (tileEntity instanceof ChestTileEntity) {
                ((ChestTileEntity)tileEntity).func_189404_a(LootTables.field_186431_m, random.nextLong());
            }
        }

        @Override
        public boolean func_225577_a_(IWorld iWorld, ChunkGenerator<?> chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            PlacementSettings placementSettings = new PlacementSettings().func_186220_a(this.field_207616_e).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)field_207621_d.get(this.field_207615_d)).func_215222_a(BlockIgnoreStructureProcessor.field_215204_a);
            BlockPos \u26032 = (BlockPos)field_207622_e.get(this.field_207615_d);
            BlockPos \u26033 = this.field_186178_c.func_177971_a(Template.func_186266_a(placementSettings, new BlockPos(3 - \u26032.func_177958_n(), 0, 0 - \u26032.func_177952_p())));
            int \u26034 = iWorld.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, \u26033.func_177958_n(), \u26033.func_177952_p());
            BlockPos \u26035 = this.field_186178_c;
            this.field_186178_c = this.field_186178_c.func_177982_a(0, \u26034 - 90 - 1, 0);
            boolean \u26036 = super.func_225577_a_(iWorld, chunkGenerator, random, mutableBoundingBox, chunkPos);
            if (this.field_207615_d.equals(field_202592_e) && !(\u2603 = iWorld.func_180495_p((\u2603 = this.field_186178_c.func_177971_a(Template.func_186266_a(placementSettings, new BlockPos(3, 0, 5)))).func_177977_b())).func_196958_f() && \u2603.func_177230_c() != Blocks.field_150468_ap) {
                iWorld.func_180501_a(\u2603, Blocks.field_196604_cC.func_176223_P(), 3);
            }
            this.field_186178_c = \u26035;
            return \u26036;
        }
    }
}

