/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.EndCityPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class EndCityStructure
extends Structure<NoFeatureConfig> {
    public EndCityStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> function) {
        super(function);
    }

    @Override
    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int n, int n2, int n3, int n4) {
        \u2603 = ((GenerationSettings)chunkGenerator.func_201496_a_()).func_202178_h();
        \u2603 = ((GenerationSettings)chunkGenerator.func_201496_a_()).func_211728_o();
        \u2603 = n + \u2603 * n3;
        \u2603 = n2 + \u2603 * n4;
        \u2603 = \u2603 < 0 ? \u2603 - \u2603 + 1 : \u2603;
        \u2603 = \u2603 < 0 ? \u2603 - \u2603 + 1 : \u2603;
        \u2603 = \u2603 / \u2603;
        \u2603 = \u2603 / \u2603;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), \u2603, \u2603, 10387313);
        \u2603 *= \u2603;
        \u2603 *= \u2603;
        return new ChunkPos(\u2603 += (random.nextInt(\u2603 - \u2603) + random.nextInt(\u2603 - \u2603)) / 2, \u2603 += (random.nextInt(\u2603 - \u2603) + random.nextInt(\u2603 - \u2603)) / 2);
    }

    @Override
    public boolean func_225558_a_(BiomeManager biomeManager, ChunkGenerator<?> chunkGenerator, Random random, int n, int n2, Biome biome) {
        ChunkPos chunkPos = this.func_211744_a(chunkGenerator, random, n, n2, 0, 0);
        if (n == chunkPos.field_77276_a && n2 == chunkPos.field_77275_b) {
            if (!chunkGenerator.func_202094_a(biome, this)) {
                return false;
            }
            int n3 = EndCityStructure.func_191070_b(n, n2, chunkGenerator);
            return n3 >= 60;
        }
        return false;
    }

    @Override
    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    @Override
    public String func_143025_a() {
        return "EndCity";
    }

    @Override
    public int func_202367_b() {
        return 8;
    }

    private static int func_191070_b(int n, int n2, ChunkGenerator<?> chunkGenerator) {
        Random random = new Random(n + n2 * 10387313);
        Rotation \u26032 = Rotation.values()[random.nextInt(Rotation.values().length)];
        int \u26033 = 5;
        int \u26034 = 5;
        if (\u26032 == Rotation.CLOCKWISE_90) {
            \u26033 = -5;
        } else if (\u26032 == Rotation.CLOCKWISE_180) {
            \u26033 = -5;
            \u26034 = -5;
        } else if (\u26032 == Rotation.COUNTERCLOCKWISE_90) {
            \u26034 = -5;
        }
        int \u26035 = (n << 4) + 7;
        int \u26036 = (n2 << 4) + 7;
        int \u26037 = chunkGenerator.func_222531_c(\u26035, \u26036, Heightmap.Type.WORLD_SURFACE_WG);
        int \u26038 = chunkGenerator.func_222531_c(\u26035, \u26036 + \u26034, Heightmap.Type.WORLD_SURFACE_WG);
        int \u26039 = chunkGenerator.func_222531_c(\u26035 + \u26033, \u26036, Heightmap.Type.WORLD_SURFACE_WG);
        int \u260310 = chunkGenerator.func_222531_c(\u26035 + \u26033, \u26036 + \u26034, Heightmap.Type.WORLD_SURFACE_WG);
        return Math.min(Math.min(\u26037, \u26038), Math.min(\u26039, \u260310));
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structure, int n, int n2, MutableBoundingBox mutableBoundingBox, int n3, long l) {
            super(structure, n, n2, mutableBoundingBox, n3, l);
        }

        @Override
        public void func_214625_a(ChunkGenerator<?> chunkGenerator, TemplateManager templateManager, int n, int n2, Biome biome) {
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            int \u26032 = EndCityStructure.func_191070_b(n, n2, chunkGenerator);
            if (\u26032 < 60) {
                return;
            }
            BlockPos \u26033 = new BlockPos(n * 16 + 8, \u26032, n2 * 16 + 8);
            EndCityPieces.func_191087_a(templateManager, \u26033, rotation, this.field_75075_a, this.field_214631_d);
            this.func_202500_a();
        }
    }
}

