/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.ConfiguredRandomFeatureList;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfiguredFeature<FC extends IFeatureConfig, F extends Feature<FC>> {
    public static final Logger field_227226_a_ = LogManager.getLogger();
    public final F field_222737_a;
    public final FC field_222738_b;

    public ConfiguredFeature(F f, FC FC) {
        this.field_222737_a = f;
        this.field_222738_b = FC;
    }

    public ConfiguredFeature(F f, Dynamic<?> dynamic) {
        this(f, ((Feature)f).func_214470_a(dynamic));
    }

    public ConfiguredFeature<?, ?> func_227228_a_(ConfiguredPlacement<?> configuredPlacement) {
        Feature<DecoratedFeatureConfig> feature = this.field_222737_a instanceof FlowersFeature ? Feature.field_214484_aL : Feature.field_214483_aK;
        return feature.func_225566_b_(new DecoratedFeatureConfig(this, configuredPlacement));
    }

    public ConfiguredRandomFeatureList<FC> func_227227_a_(float f) {
        return new ConfiguredRandomFeatureList(this, f);
    }

    public <T> Dynamic<T> func_222735_a(DynamicOps<T> dynamicOps) {
        return new Dynamic(dynamicOps, dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("name"), (Object)dynamicOps.createString(Registry.field_218379_q.func_177774_c((Feature<?>)this.field_222737_a).toString()), (Object)dynamicOps.createString("config"), (Object)this.field_222738_b.func_214634_a(dynamicOps).getValue())));
    }

    public boolean func_222734_a(IWorld iWorld, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, BlockPos blockPos) {
        return ((Feature)this.field_222737_a).func_212245_a(iWorld, chunkGenerator, random, blockPos, this.field_222738_b);
    }

    public static <T> ConfiguredFeature<?, ?> func_222736_a(Dynamic<T> dynamic) {
        String string = dynamic.get("name").asString("");
        Feature<?> \u26032 = Registry.field_218379_q.func_82594_a(new ResourceLocation(string));
        try {
            return new ConfiguredFeature(\u26032, (Dynamic<?>)dynamic.get("config").orElseEmptyMap());
        }
        catch (RuntimeException \u26033) {
            field_227226_a_.warn("Error while deserializing {}", (Object)string);
            return new ConfiguredFeature<NoFeatureConfig, Feature<NoFeatureConfig>>(Feature.field_227245_q_, NoFeatureConfig.field_202429_e);
        }
    }
}

