/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldGenTickList;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldGenRegion
implements IWorld {
    private static final Logger field_208303_a = LogManager.getLogger();
    private final List<IChunk> field_201684_a;
    private final int field_201685_b;
    private final int field_201686_c;
    private final int field_217380_e;
    private final ServerWorld field_201689_f;
    private final long field_201690_g;
    private final int field_201691_h;
    private final WorldInfo field_201692_i;
    private final Random field_201693_j;
    private final Dimension field_201694_k;
    private final GenerationSettings field_201695_l;
    private final ITickList<Block> field_205336_m = new WorldGenTickList<Block>(blockPos -> this.func_217349_x((BlockPos)blockPos).func_205218_i_());
    private final ITickList<Fluid> field_205337_n = new WorldGenTickList<Fluid>(blockPos -> this.func_217349_x((BlockPos)blockPos).func_212247_j());
    private final BiomeManager field_229862_o_;

    public WorldGenRegion(ServerWorld serverWorld, List<IChunk> list) {
        int n = MathHelper.func_76128_c(Math.sqrt(list.size()));
        if (n * n != list.size()) {
            throw Util.func_229757_c_(new IllegalStateException("Cache size is not a square."));
        }
        ChunkPos \u26032 = list.get(list.size() / 2).func_76632_l();
        this.field_201684_a = list;
        this.field_201685_b = \u26032.field_77276_a;
        this.field_201686_c = \u26032.field_77275_b;
        this.field_217380_e = n;
        this.field_201689_f = serverWorld;
        this.field_201690_g = serverWorld.func_72905_C();
        this.field_201695_l = serverWorld.func_72863_F().func_201711_g().func_201496_a_();
        this.field_201691_h = serverWorld.func_181545_F();
        this.field_201692_i = serverWorld.func_72912_H();
        this.field_201693_j = serverWorld.func_201674_k();
        this.field_201694_k = serverWorld.func_201675_m();
        this.field_229862_o_ = new BiomeManager(this, WorldInfo.func_227498_c_(this.field_201690_g), this.field_201694_k.func_186058_p().func_227176_e_());
    }

    public int func_201679_a() {
        return this.field_201685_b;
    }

    public int func_201680_b() {
        return this.field_201686_c;
    }

    @Override
    public IChunk func_212866_a_(int n, int n2) {
        return this.func_217348_a(n, n2, ChunkStatus.field_223226_a_);
    }

    @Override
    @Nullable
    public IChunk func_217353_a(int n, int n2, ChunkStatus chunkStatus, boolean bl) {
        IChunk \u26034;
        if (this.func_217354_b(n, n2)) {
            Object object = this.field_201684_a.get(0).func_76632_l();
            int \u26032 = n - ((ChunkPos)object).field_77276_a;
            int \u26033 = n2 - ((ChunkPos)object).field_77275_b;
            \u26034 = this.field_201684_a.get(\u26032 + \u26033 * this.field_217380_e);
            if (\u26034.func_201589_g().func_209003_a(chunkStatus)) {
                return \u26034;
            }
        } else {
            \u26034 = null;
        }
        if (!bl) {
            return null;
        }
        object = this.field_201684_a.get(0);
        IChunk iChunk = this.field_201684_a.get(this.field_201684_a.size() - 1);
        field_208303_a.error("Requested chunk : {} {}", (Object)n, (Object)n2);
        field_208303_a.error("Region bounds : {} {} | {} {}", (Object)object.func_76632_l().field_77276_a, (Object)object.func_76632_l().field_77275_b, (Object)iChunk.func_76632_l().field_77276_a, (Object)iChunk.func_76632_l().field_77275_b);
        if (\u26034 != null) {
            throw Util.func_229757_c_(new RuntimeException(String.format("Chunk is not of correct status. Expecting %s, got %s | %s %s", chunkStatus, \u26034.func_201589_g(), n, n2)));
        }
        throw Util.func_229757_c_(new RuntimeException(String.format("We are asking a region for a chunk out of bound | %s %s", n, n2)));
    }

    @Override
    public boolean func_217354_b(int n, int n2) {
        IChunk iChunk = this.field_201684_a.get(0);
        \u2603 = this.field_201684_a.get(this.field_201684_a.size() - 1);
        return n >= iChunk.func_76632_l().field_77276_a && n <= \u2603.func_76632_l().field_77276_a && n2 >= iChunk.func_76632_l().field_77275_b && n2 <= \u2603.func_76632_l().field_77275_b;
    }

    @Override
    public BlockState func_180495_p(BlockPos blockPos) {
        return this.func_212866_a_(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4).func_180495_p(blockPos);
    }

    @Override
    public IFluidState func_204610_c(BlockPos blockPos) {
        return this.func_217349_x(blockPos).func_204610_c(blockPos);
    }

    @Override
    @Nullable
    public PlayerEntity func_190525_a(double d, double d2, double d3, double d4, Predicate<Entity> predicate) {
        return null;
    }

    @Override
    public int func_175657_ab() {
        return 0;
    }

    @Override
    public BiomeManager func_225523_d_() {
        return this.field_229862_o_;
    }

    @Override
    public Biome func_225604_a_(int n, int n2, int n3) {
        return this.field_201689_f.func_225604_a_(n, n2, n3);
    }

    @Override
    public WorldLightManager func_225524_e_() {
        return this.field_201689_f.func_225524_e_();
    }

    @Override
    public boolean func_225521_a_(BlockPos blockPos2, boolean bl, @Nullable Entity entity) {
        BlockPos blockPos2;
        BlockState blockState = this.func_180495_p(blockPos2);
        if (blockState.func_196958_f()) {
            return false;
        }
        if (bl) {
            TileEntity tileEntity = blockState.func_177230_c().func_149716_u() ? this.func_175625_s(blockPos2) : null;
            Block.func_220054_a(blockState, this.field_201689_f, blockPos2, tileEntity, entity, ItemStack.field_190927_a);
        }
        return this.func_180501_a(blockPos2, Blocks.field_150350_a.func_176223_P(), 3);
    }

    @Override
    @Nullable
    public TileEntity func_175625_s(BlockPos blockPos) {
        IChunk iChunk = this.func_217349_x(blockPos);
        TileEntity \u26032 = iChunk.func_175625_s(blockPos);
        if (\u26032 != null) {
            return \u26032;
        }
        CompoundNBT \u26033 = iChunk.func_201579_g(blockPos);
        if (\u26033 != null) {
            if ("DUMMY".equals(\u26033.func_74779_i("id"))) {
                Block block = this.func_180495_p(blockPos).func_177230_c();
                if (!(block instanceof ITileEntityProvider)) {
                    return null;
                }
                \u26032 = ((ITileEntityProvider)((Object)block)).func_196283_a_(this.field_201689_f);
            } else {
                \u26032 = TileEntity.func_203403_c(\u26033);
            }
            if (\u26032 != null) {
                iChunk.func_177426_a(blockPos, \u26032);
                return \u26032;
            }
        }
        if (iChunk.func_180495_p(blockPos).func_177230_c() instanceof ITileEntityProvider) {
            field_208303_a.warn("Tried to access a block entity before it was created. {}", (Object)blockPos);
        }
        return null;
    }

    @Override
    public boolean func_180501_a(BlockPos blockPos, BlockState blockState2, int n) {
        BlockState blockState2;
        IChunk iChunk = this.func_217349_x(blockPos);
        BlockState \u26032 = iChunk.func_177436_a(blockPos, blockState2, false);
        if (\u26032 != null) {
            this.field_201689_f.func_217393_a(blockPos, \u26032, blockState2);
        }
        if ((\u2603 = blockState2.func_177230_c()).func_149716_u()) {
            if (iChunk.func_201589_g().func_202129_d() == ChunkStatus.Type.LEVELCHUNK) {
                iChunk.func_177426_a(blockPos, ((ITileEntityProvider)((Object)\u2603)).func_196283_a_(this));
            } else {
                CompoundNBT compoundNBT = new CompoundNBT();
                compoundNBT.func_74768_a("x", blockPos.func_177958_n());
                compoundNBT.func_74768_a("y", blockPos.func_177956_o());
                compoundNBT.func_74768_a("z", blockPos.func_177952_p());
                compoundNBT.func_74778_a("id", "DUMMY");
                iChunk.func_201591_a(compoundNBT);
            }
        } else if (\u26032 != null && \u26032.func_177230_c().func_149716_u()) {
            iChunk.func_177425_e(blockPos);
        }
        if (blockState2.func_202065_c(this, blockPos)) {
            this.func_201683_l(blockPos);
        }
        return true;
    }

    private void func_201683_l(BlockPos blockPos) {
        this.func_217349_x(blockPos).func_201594_d(blockPos);
    }

    @Override
    public boolean func_217376_c(Entity entity) {
        int n = MathHelper.func_76128_c(entity.func_226277_ct_() / 16.0);
        \u2603 = MathHelper.func_76128_c(entity.func_226281_cx_() / 16.0);
        this.func_212866_a_(n, \u2603).func_76612_a(entity);
        return true;
    }

    @Override
    public boolean func_217377_a(BlockPos blockPos, boolean bl) {
        return this.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 3);
    }

    @Override
    public WorldBorder func_175723_af() {
        return this.field_201689_f.func_175723_af();
    }

    @Override
    public boolean func_201670_d() {
        return false;
    }

    @Override
    @Deprecated
    public ServerWorld func_201672_e() {
        return this.field_201689_f;
    }

    @Override
    public WorldInfo func_72912_H() {
        return this.field_201692_i;
    }

    @Override
    public DifficultyInstance func_175649_E(BlockPos blockPos) {
        if (!this.func_217354_b(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4)) {
            throw new RuntimeException("We are asking a region for a chunk out of bound");
        }
        return new DifficultyInstance(this.field_201689_f.func_175659_aa(), this.field_201689_f.func_72820_D(), 0L, this.field_201689_f.func_130001_d());
    }

    @Override
    public AbstractChunkProvider func_72863_F() {
        return this.field_201689_f.func_72863_F();
    }

    @Override
    public long func_72905_C() {
        return this.field_201690_g;
    }

    @Override
    public ITickList<Block> func_205220_G_() {
        return this.field_205336_m;
    }

    @Override
    public ITickList<Fluid> func_205219_F_() {
        return this.field_205337_n;
    }

    @Override
    public int func_181545_F() {
        return this.field_201691_h;
    }

    @Override
    public Random func_201674_k() {
        return this.field_201693_j;
    }

    @Override
    public void func_195592_c(BlockPos blockPos, Block block) {
    }

    @Override
    public int func_201676_a(Heightmap.Type type, int n, int n2) {
        return this.func_212866_a_(n >> 4, n2 >> 4).func_201576_a(type, n & 0xF, n2 & 0xF) + 1;
    }

    @Override
    public void func_184133_a(@Nullable PlayerEntity playerEntity, BlockPos blockPos, SoundEvent soundEvent, SoundCategory soundCategory, float f, float f2) {
    }

    @Override
    public void func_195594_a(IParticleData iParticleData, double d, double d2, double d3, double d4, double d5, double d6) {
    }

    @Override
    public void func_217378_a(@Nullable PlayerEntity playerEntity, int n, BlockPos blockPos, int n2) {
    }

    @Override
    public Dimension func_201675_m() {
        return this.field_201694_k;
    }

    @Override
    public boolean func_217375_a(BlockPos blockPos, Predicate<BlockState> predicate) {
        return predicate.test(this.func_180495_p(blockPos));
    }

    @Override
    public <T extends Entity> List<T> func_175647_a(Class<? extends T> clazz, AxisAlignedBB axisAlignedBB, @Nullable Predicate<? super T> predicate) {
        return Collections.emptyList();
    }

    @Override
    public List<Entity> func_175674_a(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, @Nullable Predicate<? super Entity> predicate) {
        return Collections.emptyList();
    }

    public List<PlayerEntity> func_217369_A() {
        return Collections.emptyList();
    }

    @Override
    @Deprecated
    public /* synthetic */ World func_201672_e() {
        return this.func_201672_e();
    }
}

