/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.AbstractCollection;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.world.ITickList;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimerTickList;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.lighting.WorldLightManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkPrimer
implements IChunk {
    private static final Logger field_201653_a = LogManager.getLogger();
    private final ChunkPos field_201654_b;
    private volatile boolean field_201655_c;
    @Nullable
    private BiomeContainer field_201656_d;
    @Nullable
    private volatile WorldLightManager field_217334_e;
    private final Map<Heightmap.Type, Heightmap> field_201657_e = Maps.newEnumMap(Heightmap.Type.class);
    private volatile ChunkStatus field_201658_f = ChunkStatus.field_223226_a_;
    private final Map<BlockPos, TileEntity> field_201659_g = Maps.newHashMap();
    private final Map<BlockPos, CompoundNBT> field_201660_h = Maps.newHashMap();
    private final ChunkSection[] field_201661_i = new ChunkSection[16];
    private final List<CompoundNBT> field_201662_j = Lists.newArrayList();
    private final List<BlockPos> field_201663_k = Lists.newArrayList();
    private final ShortList[] field_201665_m = new ShortList[16];
    private final Map<String, StructureStart> field_201666_n = Maps.newHashMap();
    private final Map<String, LongSet> field_201667_o = Maps.newHashMap();
    private final UpgradeData field_201668_p;
    private final ChunkPrimerTickList<Block> field_201664_l;
    private final ChunkPrimerTickList<Fluid> field_205333_q;
    private long field_209217_s;
    private final Map<GenerationStage.Carving, BitSet> field_205769_s = Maps.newHashMap();
    private volatile boolean field_217335_u;

    public ChunkPrimer(ChunkPos chunkPos, UpgradeData upgradeData) {
        this(chunkPos, upgradeData, null, new ChunkPrimerTickList<Block>(block -> block == null || block.func_176223_P().func_196958_f(), chunkPos), new ChunkPrimerTickList<Fluid>(fluid -> fluid == null || fluid == Fluids.field_204541_a, chunkPos));
    }

    public ChunkPrimer(ChunkPos chunkPos, UpgradeData upgradeData, @Nullable ChunkSection[] chunkSectionArray, ChunkPrimerTickList<Block> chunkPrimerTickList, ChunkPrimerTickList<Fluid> chunkPrimerTickList2) {
        this.field_201654_b = chunkPos;
        this.field_201668_p = upgradeData;
        this.field_201664_l = chunkPrimerTickList;
        this.field_205333_q = chunkPrimerTickList2;
        if (chunkSectionArray != null) {
            if (this.field_201661_i.length == chunkSectionArray.length) {
                System.arraycopy(chunkSectionArray, 0, this.field_201661_i, 0, this.field_201661_i.length);
            } else {
                field_201653_a.warn("Could not set level chunk sections, array length is {} instead of {}", (Object)chunkSectionArray.length, (Object)this.field_201661_i.length);
            }
        }
    }

    @Override
    public BlockState func_180495_p(BlockPos blockPos) {
        int n = blockPos.func_177956_o();
        if (World.func_217405_b(n)) {
            return Blocks.field_201940_ji.func_176223_P();
        }
        ChunkSection \u26032 = this.func_76587_i()[n >> 4];
        if (ChunkSection.func_222628_a(\u26032)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return \u26032.func_177485_a(blockPos.func_177958_n() & 0xF, n & 0xF, blockPos.func_177952_p() & 0xF);
    }

    @Override
    public IFluidState func_204610_c(BlockPos blockPos) {
        int n = blockPos.func_177956_o();
        if (World.func_217405_b(n)) {
            return Fluids.field_204541_a.func_207188_f();
        }
        ChunkSection \u26032 = this.func_76587_i()[n >> 4];
        if (ChunkSection.func_222628_a(\u26032)) {
            return Fluids.field_204541_a.func_207188_f();
        }
        return \u26032.func_206914_b(blockPos.func_177958_n() & 0xF, n & 0xF, blockPos.func_177952_p() & 0xF);
    }

    @Override
    public Stream<BlockPos> func_217304_m() {
        return this.field_201663_k.stream();
    }

    public ShortList[] func_201647_i() {
        ShortList[] shortListArray = new ShortList[16];
        for (BlockPos blockPos : this.field_201663_k) {
            IChunk.func_217308_a(shortListArray, blockPos.func_177956_o() >> 4).add(ChunkPrimer.func_201651_i(blockPos));
        }
        return shortListArray;
    }

    public void func_201646_a(short s, int n) {
        this.func_201637_h(ChunkPrimer.func_201635_a(s, n, this.field_201654_b));
    }

    public void func_201637_h(BlockPos blockPos) {
        this.field_201663_k.add(blockPos.func_185334_h());
    }

    @Override
    @Nullable
    public BlockState func_177436_a(BlockPos blockPos, BlockState blockState, boolean bl) {
        Object object;
        int n = blockPos.func_177958_n();
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p();
        if (\u2603 < 0 || \u2603 >= 256) {
            return Blocks.field_201940_ji.func_176223_P();
        }
        if (this.field_201661_i[\u2603 >> 4] == Chunk.field_186036_a && blockState.func_177230_c() == Blocks.field_150350_a) {
            return blockState;
        }
        if (blockState.func_185906_d() > 0) {
            this.field_201663_k.add(new BlockPos((n & 0xF) + this.func_76632_l().func_180334_c(), \u2603, (\u2603 & 0xF) + this.func_76632_l().func_180333_d()));
        }
        ChunkSection \u26032 = this.func_217332_a(\u2603 >> 4);
        BlockState \u26033 = \u26032.func_222629_a(n & 0xF, \u2603 & 0xF, \u2603 & 0xF, blockState);
        if (this.field_201658_f.func_209003_a(ChunkStatus.field_222613_i) && blockState != \u26033 && (blockState.func_200016_a(this, blockPos) != \u26033.func_200016_a(this, blockPos) || blockState.func_185906_d() != \u26033.func_185906_d() || blockState.func_215691_g() || \u26033.func_215691_g())) {
            object = this.func_217307_e();
            ((WorldLightManager)object).func_215568_a(blockPos);
        }
        object = this.func_201589_g().func_222595_h();
        EnumSet<Heightmap.Type> \u26034 = null;
        Iterator iterator = ((AbstractCollection)object).iterator();
        while (iterator.hasNext()) {
            Heightmap.Type type = (Heightmap.Type)((Object)iterator.next());
            Heightmap \u26035 = this.field_201657_e.get((Object)type);
            if (\u26035 != null) continue;
            if (\u26034 == null) {
                \u26034 = EnumSet.noneOf(Heightmap.Type.class);
            }
            \u26034.add(type);
        }
        if (\u26034 != null) {
            Heightmap.func_222690_a(this, \u26034);
        }
        iterator = ((AbstractCollection)object).iterator();
        while (iterator.hasNext()) {
            type = (Heightmap.Type)((Object)iterator.next());
            this.field_201657_e.get((Object)type).func_202270_a(n & 0xF, \u2603, \u2603 & 0xF, blockState);
        }
        return \u26033;
    }

    public ChunkSection func_217332_a(int n) {
        if (this.field_201661_i[n] == Chunk.field_186036_a) {
            this.field_201661_i[n] = new ChunkSection(n << 4);
        }
        return this.field_201661_i[n];
    }

    @Override
    public void func_177426_a(BlockPos blockPos, TileEntity tileEntity) {
        tileEntity.func_174878_a(blockPos);
        this.field_201659_g.put(blockPos, tileEntity);
    }

    @Override
    public Set<BlockPos> func_203066_o() {
        HashSet hashSet = Sets.newHashSet(this.field_201660_h.keySet());
        hashSet.addAll(this.field_201659_g.keySet());
        return hashSet;
    }

    @Override
    @Nullable
    public TileEntity func_175625_s(BlockPos blockPos) {
        return this.field_201659_g.get(blockPos);
    }

    public Map<BlockPos, TileEntity> func_201627_k() {
        return this.field_201659_g;
    }

    public void func_201626_b(CompoundNBT compoundNBT) {
        this.field_201662_j.add(compoundNBT);
    }

    @Override
    public void func_76612_a(Entity entity) {
        CompoundNBT compoundNBT = new CompoundNBT();
        entity.func_70039_c(compoundNBT);
        this.func_201626_b(compoundNBT);
    }

    public List<CompoundNBT> func_201652_l() {
        return this.field_201662_j;
    }

    public void func_225548_a_(BiomeContainer biomeContainer) {
        this.field_201656_d = biomeContainer;
    }

    @Override
    @Nullable
    public BiomeContainer func_225549_i_() {
        return this.field_201656_d;
    }

    @Override
    public void func_177427_f(boolean bl) {
        this.field_201655_c = bl;
    }

    @Override
    public boolean func_201593_f() {
        return this.field_201655_c;
    }

    @Override
    public ChunkStatus func_201589_g() {
        return this.field_201658_f;
    }

    public void func_201574_a(ChunkStatus chunkStatus) {
        this.field_201658_f = chunkStatus;
        this.func_177427_f(true);
    }

    @Override
    public ChunkSection[] func_76587_i() {
        return this.field_201661_i;
    }

    @Nullable
    public WorldLightManager func_217307_e() {
        return this.field_217334_e;
    }

    @Override
    public Collection<Map.Entry<Heightmap.Type, Heightmap>> func_217311_f() {
        return Collections.unmodifiableSet(this.field_201657_e.entrySet());
    }

    @Override
    public void func_201607_a(Heightmap.Type type, long[] lArray) {
        this.func_217303_b(type).func_202268_a(lArray);
    }

    @Override
    public Heightmap func_217303_b(Heightmap.Type type2) {
        return this.field_201657_e.computeIfAbsent(type2, type -> new Heightmap(this, (Heightmap.Type)((Object)type)));
    }

    @Override
    public int func_201576_a(Heightmap.Type type, int n, int n2) {
        Heightmap heightmap = this.field_201657_e.get((Object)type);
        if (heightmap == null) {
            Heightmap.func_222690_a(this, EnumSet.of(type));
            heightmap = this.field_201657_e.get((Object)type);
        }
        return heightmap.func_202273_a(n & 0xF, n2 & 0xF) - 1;
    }

    @Override
    public ChunkPos func_76632_l() {
        return this.field_201654_b;
    }

    @Override
    public void func_177432_b(long l) {
    }

    @Override
    @Nullable
    public StructureStart func_201585_a(String string) {
        return this.field_201666_n.get(string);
    }

    @Override
    public void func_201584_a(String string, StructureStart structureStart) {
        this.field_201666_n.put(string, structureStart);
        this.field_201655_c = true;
    }

    @Override
    public Map<String, StructureStart> func_201609_c() {
        return Collections.unmodifiableMap(this.field_201666_n);
    }

    @Override
    public void func_201612_a(Map<String, StructureStart> map) {
        this.field_201666_n.clear();
        this.field_201666_n.putAll(map);
        this.field_201655_c = true;
    }

    @Override
    public LongSet func_201578_b(String string2) {
        return this.field_201667_o.computeIfAbsent(string2, string -> new LongOpenHashSet());
    }

    @Override
    public void func_201583_a(String string2, long l) {
        this.field_201667_o.computeIfAbsent(string2, string -> new LongOpenHashSet()).add(l);
        this.field_201655_c = true;
    }

    @Override
    public Map<String, LongSet> func_201604_d() {
        return Collections.unmodifiableMap(this.field_201667_o);
    }

    @Override
    public void func_201606_b(Map<String, LongSet> map) {
        this.field_201667_o.clear();
        this.field_201667_o.putAll(map);
        this.field_201655_c = true;
    }

    public static short func_201651_i(BlockPos blockPos) {
        int n = blockPos.func_177958_n();
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p();
        \u2603 = n & 0xF;
        \u2603 = \u2603 & 0xF;
        \u2603 = \u2603 & 0xF;
        return (short)(\u2603 | \u2603 << 4 | \u2603 << 8);
    }

    public static BlockPos func_201635_a(short s, int n, ChunkPos chunkPos) {
        int n2 = (s & 0xF) + (chunkPos.field_77276_a << 4);
        \u2603 = (s >>> 4 & 0xF) + (n << 4);
        \u2603 = (s >>> 8 & 0xF) + (chunkPos.field_77275_b << 4);
        return new BlockPos(n2, \u2603, \u2603);
    }

    @Override
    public void func_201594_d(BlockPos blockPos) {
        if (!World.func_189509_E(blockPos)) {
            IChunk.func_217308_a(this.field_201665_m, blockPos.func_177956_o() >> 4).add(ChunkPrimer.func_201651_i(blockPos));
        }
    }

    @Override
    public ShortList[] func_201614_D() {
        return this.field_201665_m;
    }

    @Override
    public void func_201636_b(short s, int n) {
        IChunk.func_217308_a(this.field_201665_m, n).add(s);
    }

    public ChunkPrimerTickList<Block> func_205218_i_() {
        return this.field_201664_l;
    }

    public ChunkPrimerTickList<Fluid> func_212247_j() {
        return this.field_205333_q;
    }

    @Override
    public UpgradeData func_196966_y() {
        return this.field_201668_p;
    }

    @Override
    public void func_177415_c(long l) {
        this.field_209217_s = l;
    }

    @Override
    public long func_177416_w() {
        return this.field_209217_s;
    }

    @Override
    public void func_201591_a(CompoundNBT compoundNBT) {
        this.field_201660_h.put(new BlockPos(compoundNBT.func_74762_e("x"), compoundNBT.func_74762_e("y"), compoundNBT.func_74762_e("z")), compoundNBT);
    }

    public Map<BlockPos, CompoundNBT> func_201632_q() {
        return Collections.unmodifiableMap(this.field_201660_h);
    }

    @Override
    public CompoundNBT func_201579_g(BlockPos blockPos) {
        return this.field_201660_h.get(blockPos);
    }

    @Override
    @Nullable
    public CompoundNBT func_223134_j(BlockPos blockPos) {
        TileEntity tileEntity = this.func_175625_s(blockPos);
        if (tileEntity != null) {
            return tileEntity.func_189515_b(new CompoundNBT());
        }
        return this.field_201660_h.get(blockPos);
    }

    @Override
    public void func_177425_e(BlockPos blockPos) {
        this.field_201659_g.remove(blockPos);
        this.field_201660_h.remove(blockPos);
    }

    @Override
    public BitSet func_205749_a(GenerationStage.Carving carving2) {
        return this.field_205769_s.computeIfAbsent(carving2, carving -> new BitSet(65536));
    }

    public void func_205767_a(GenerationStage.Carving carving, BitSet bitSet) {
        this.field_205769_s.put(carving, bitSet);
    }

    public void func_217306_a(WorldLightManager worldLightManager) {
        this.field_217334_e = worldLightManager;
    }

    @Override
    public boolean func_217310_r() {
        return this.field_217335_u;
    }

    @Override
    public void func_217305_b(boolean bl) {
        this.field_217335_u = bl;
        this.func_177427_f(true);
    }

    public /* synthetic */ ITickList func_212247_j() {
        return this.func_212247_j();
    }

    public /* synthetic */ ITickList func_205218_i_() {
        return this.func_205218_i_();
    }
}

