/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;

public class WeightedList<U> {
    protected final List<Entry<? extends U>> field_220658_a = Lists.newArrayList();
    private final Random field_220659_b;

    public WeightedList(Random random) {
        this.field_220659_b = random;
    }

    public WeightedList() {
        this(new Random());
    }

    public <T> WeightedList(Dynamic<T> dynamic2, Function<Dynamic<T>, U> function) {
        this();
        dynamic2.asStream().forEach(dynamic -> dynamic.get("data").map(dynamic2 -> {
            Object r = function.apply((Dynamic)dynamic2);
            int \u26032 = dynamic.get("weight").asInt(1);
            return this.func_226313_a_(r, \u26032);
        }));
    }

    public <T> T func_226310_a_(DynamicOps<T> dynamicOps, Function<U, Dynamic<T>> function) {
        return (T)dynamicOps.createList(this.func_226319_c_().map(entry -> dynamicOps.createMap((Map)ImmutableMap.builder().put(dynamicOps.createString("data"), ((Dynamic)function.apply(entry.func_220647_b())).getValue()).put(dynamicOps.createString("weight"), dynamicOps.createInt(entry.func_226322_b_())).build())));
    }

    public WeightedList<U> func_226313_a_(U u, int n) {
        this.field_220658_a.add(new Entry(u, n));
        return this;
    }

    public WeightedList<U> func_226309_a_() {
        return this.func_226314_a_(this.field_220659_b);
    }

    public WeightedList<U> func_226314_a_(Random random) {
        this.field_220658_a.forEach(entry -> ((Entry)entry).func_220648_a(random.nextFloat()));
        this.field_220658_a.sort(Comparator.comparingDouble(object -> ((Entry)object).func_220649_a()));
        return this;
    }

    public Stream<? extends U> func_220655_b() {
        return this.field_220658_a.stream().map(Entry::func_220647_b);
    }

    public Stream<Entry<? extends U>> func_226319_c_() {
        return this.field_220658_a.stream();
    }

    public U func_226318_b_(Random random) {
        return this.func_226314_a_(random).func_220655_b().findFirst().orElseThrow(RuntimeException::new);
    }

    public String toString() {
        return "WeightedList[" + this.field_220658_a + "]";
    }

    public class Entry<T> {
        private final T field_220651_b;
        private final int field_220652_c;
        private double field_220653_d;

        private Entry(T t, int n) {
            this.field_220652_c = n;
            this.field_220651_b = t;
        }

        private double func_220649_a() {
            return this.field_220653_d;
        }

        private void func_220648_a(float f) {
            this.field_220653_d = -Math.pow(f, 1.0f / (float)this.field_220652_c);
        }

        public T func_220647_b() {
            return this.field_220651_b;
        }

        public int func_226322_b_() {
            return this.field_220652_c;
        }

        public String toString() {
            return "" + this.field_220652_c + ":" + this.field_220651_b;
        }
    }
}

