/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Direction;

public enum Rotation {
    NONE,
    CLOCKWISE_90,
    CLOCKWISE_180,
    COUNTERCLOCKWISE_90;


    public Rotation func_185830_a(Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                switch (this) {
                    case NONE: {
                        return CLOCKWISE_180;
                    }
                    case CLOCKWISE_90: {
                        return COUNTERCLOCKWISE_90;
                    }
                    case CLOCKWISE_180: {
                        return NONE;
                    }
                    case COUNTERCLOCKWISE_90: {
                        return CLOCKWISE_90;
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch (this) {
                    case NONE: {
                        return COUNTERCLOCKWISE_90;
                    }
                    case CLOCKWISE_90: {
                        return NONE;
                    }
                    case CLOCKWISE_180: {
                        return CLOCKWISE_90;
                    }
                    case COUNTERCLOCKWISE_90: {
                        return CLOCKWISE_180;
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (this) {
                    case NONE: {
                        return CLOCKWISE_90;
                    }
                    case CLOCKWISE_90: {
                        return CLOCKWISE_180;
                    }
                    case CLOCKWISE_180: {
                        return COUNTERCLOCKWISE_90;
                    }
                    case COUNTERCLOCKWISE_90: {
                        return NONE;
                    }
                }
            }
        }
        return this;
    }

    public Direction func_185831_a(Direction direction) {
        if (direction.func_176740_k() == Direction.Axis.Y) {
            return direction;
        }
        switch (this) {
            case CLOCKWISE_180: {
                return direction.func_176734_d();
            }
            case COUNTERCLOCKWISE_90: {
                return direction.func_176735_f();
            }
            case CLOCKWISE_90: {
                return direction.func_176746_e();
            }
        }
        return direction;
    }

    public int func_185833_a(int n, int n2) {
        switch (this) {
            case CLOCKWISE_180: {
                return (n + n2 / 2) % n2;
            }
            case COUNTERCLOCKWISE_90: {
                return (n + n2 * 3 / 4) % n2;
            }
            case CLOCKWISE_90: {
                return (n + n2 / 4) % n2;
            }
        }
        return n;
    }

    public static Rotation func_222466_a(Random random) {
        Rotation[] rotationArray = Rotation.values();
        return rotationArray[random.nextInt(rotationArray.length)];
    }

    public static List<Rotation> func_222467_b(Random random) {
        ArrayList arrayList = Lists.newArrayList((Object[])Rotation.values());
        Collections.shuffle(arrayList, random);
        return arrayList;
    }
}

