/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.brain.task;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;

public class GiveHeroGiftsTask
extends Task<VillagerEntity> {
    private static final Map<VillagerProfession, ResourceLocation> field_220403_a = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
        hashMap.put(VillagerProfession.field_221152_b, LootTables.field_215798_ag);
        hashMap.put(VillagerProfession.field_221153_c, LootTables.field_215799_ah);
        hashMap.put(VillagerProfession.field_221154_d, LootTables.field_215800_ai);
        hashMap.put(VillagerProfession.field_221155_e, LootTables.field_215801_aj);
        hashMap.put(VillagerProfession.field_221156_f, LootTables.field_215802_ak);
        hashMap.put(VillagerProfession.field_221157_g, LootTables.field_215803_al);
        hashMap.put(VillagerProfession.field_221158_h, LootTables.field_215804_am);
        hashMap.put(VillagerProfession.field_221159_i, LootTables.field_215805_an);
        hashMap.put(VillagerProfession.field_221160_j, LootTables.field_215806_ao);
        hashMap.put(VillagerProfession.field_221161_k, LootTables.field_215807_ap);
        hashMap.put(VillagerProfession.field_221163_m, LootTables.field_215808_aq);
        hashMap.put(VillagerProfession.field_221164_n, LootTables.field_215809_ar);
        hashMap.put(VillagerProfession.field_221165_o, LootTables.field_215810_as);
    });
    private int field_220404_b = 600;
    private boolean field_220405_c;
    private long field_220406_d;

    public GiveHeroGiftsTask(int n) {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of(MemoryModuleType.field_220950_k, (Object)((Object)MemoryModuleStatus.REGISTERED), MemoryModuleType.field_220951_l, (Object)((Object)MemoryModuleStatus.REGISTERED), MemoryModuleType.field_220952_m, (Object)((Object)MemoryModuleStatus.REGISTERED), MemoryModuleType.field_220949_j, (Object)((Object)MemoryModuleStatus.VALUE_PRESENT)), n);
    }

    @Override
    protected boolean func_212832_a_(ServerWorld serverWorld, VillagerEntity villagerEntity) {
        if (!this.func_220396_b(villagerEntity)) {
            return false;
        }
        if (this.field_220404_b > 0) {
            --this.field_220404_b;
            return false;
        }
        return true;
    }

    @Override
    protected void func_212831_a_(ServerWorld serverWorld, VillagerEntity villagerEntity, long l) {
        this.field_220405_c = false;
        this.field_220406_d = l;
        PlayerEntity playerEntity = this.func_220400_c(villagerEntity).get();
        villagerEntity.func_213375_cj().func_218205_a(MemoryModuleType.field_220952_m, playerEntity);
        BrainUtil.func_220625_c(villagerEntity, playerEntity);
    }

    @Override
    protected boolean func_212834_g_(ServerWorld serverWorld, VillagerEntity villagerEntity, long l) {
        return this.func_220396_b(villagerEntity) && !this.field_220405_c;
    }

    @Override
    protected void func_212833_d_(ServerWorld serverWorld, VillagerEntity villagerEntity, long l) {
        PlayerEntity playerEntity = this.func_220400_c(villagerEntity).get();
        BrainUtil.func_220625_c(villagerEntity, playerEntity);
        if (this.func_220401_a(villagerEntity, playerEntity)) {
            if (l - this.field_220406_d > 20L) {
                this.func_220398_a(villagerEntity, playerEntity);
                this.field_220405_c = true;
            }
        } else {
            BrainUtil.func_220621_a(villagerEntity, playerEntity, 5);
        }
    }

    @Override
    protected void func_212835_f_(ServerWorld serverWorld, VillagerEntity villagerEntity, long l) {
        this.field_220404_b = GiveHeroGiftsTask.func_220397_a(serverWorld);
        villagerEntity.func_213375_cj().func_218189_b(MemoryModuleType.field_220952_m);
        villagerEntity.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
        villagerEntity.func_213375_cj().func_218189_b(MemoryModuleType.field_220951_l);
    }

    private void func_220398_a(VillagerEntity villagerEntity, LivingEntity livingEntity) {
        List<ItemStack> list = this.func_220399_a(villagerEntity);
        for (ItemStack itemStack : list) {
            BrainUtil.func_220624_a(villagerEntity, itemStack, livingEntity);
        }
    }

    private List<ItemStack> func_220399_a(VillagerEntity villagerEntity) {
        if (villagerEntity.func_70631_g_()) {
            return ImmutableList.of((Object)new ItemStack(Items.field_221620_aV));
        }
        VillagerProfession villagerProfession = villagerEntity.func_213700_eh().func_221130_b();
        if (field_220403_a.containsKey(villagerProfession)) {
            LootTable lootTable = villagerEntity.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(field_220403_a.get(villagerProfession));
            LootContext.Builder \u26032 = new LootContext.Builder((ServerWorld)villagerEntity.field_70170_p).func_216015_a(LootParameters.field_216286_f, new BlockPos(villagerEntity)).func_216015_a(LootParameters.field_216281_a, villagerEntity).func_216023_a(villagerEntity.func_70681_au());
            return lootTable.func_216113_a(\u26032.func_216022_a(LootParameterSets.field_216264_e));
        }
        return ImmutableList.of((Object)new ItemStack(Items.field_151014_N));
    }

    private boolean func_220396_b(VillagerEntity villagerEntity) {
        return this.func_220400_c(villagerEntity).isPresent();
    }

    private Optional<PlayerEntity> func_220400_c(VillagerEntity villagerEntity) {
        return villagerEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_220949_j).filter(this::func_220402_a);
    }

    private boolean func_220402_a(PlayerEntity playerEntity) {
        return playerEntity.func_70644_a(Effects.field_220310_F);
    }

    private boolean func_220401_a(VillagerEntity villagerEntity, PlayerEntity playerEntity) {
        BlockPos blockPos = new BlockPos(playerEntity);
        \u2603 = new BlockPos(villagerEntity);
        return \u2603.func_218141_a(blockPos, 5.0);
    }

    private static int func_220397_a(ServerWorld serverWorld) {
        return 600 + serverWorld.field_73012_v.nextInt(6001);
    }

    @Override
    protected /* synthetic */ boolean func_212834_g_(ServerWorld serverWorld, LivingEntity livingEntity, long l) {
        return this.func_212834_g_(serverWorld, (VillagerEntity)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void func_212835_f_(ServerWorld serverWorld, LivingEntity livingEntity, long l) {
        this.func_212835_f_(serverWorld, (VillagerEntity)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void func_212833_d_(ServerWorld serverWorld, LivingEntity livingEntity, long l) {
        this.func_212833_d_(serverWorld, (VillagerEntity)livingEntity, l);
    }
}

